<?php
    /**
     * The template for displaying all pages
     * This is the template that displays all pages by default.
     * Please note that this is the WordPress construct of pages
     * and that other 'pages' on your WordPress site will use a
     * different template.
     * @package UnderStrap
     *          Template Name: Bigform
     */
    
    defined('ABSPATH') || exit;
    
    get_header();
    
    $container = get_theme_mod('understrap_container_type');

?>
	<div class="wrapper" id="page-wrapper">
		<div class="<?php echo esc_attr($container); ?>" id="content" tabindex="-1">
			<div class="row">
                <?php get_template_part('global-templates/left-sidebar-check'); ?>
				<main class="site-main" id="main">
                    <?php
                        while (have_posts()) {
                            the_post();
                            get_template_part('loop-templates/content', 'bigform');
                            
                        }
                    ?>
				</main>
			</div>
		</div>
	</div>
<?php
    get_footer();
