<?php
    defined('ABSPATH') or die('');
    
    add_action('init', 'create_menus');
    
    function create_menus()
    {
        
        $menus = array(
            'services_menu'        => __('Services Menu'),
            'regions_menu'         => __('Regions Menu'),
            'cities_menu'          => __('Cities Menu'),
            'services_and_regions' => __('Services And Regions Menu')
        );
        
        register_nav_menus($menus);
        
        foreach ($menus as $key => $val) {
            $name = $key;
            wp_create_nav_menu($name);
            $services_menu   = get_term_by('name', $name, 'nav_menu');
            $locations       = get_theme_mod('nav_menu_locations');
            $locations[$key] = $services_menu->term_id;
            // if ($key == 'services_menu') $locations['primary'] = $services_menu->term_id;
            set_theme_mod('nav_menu_locations', $locations);
        }
    }
    
    function service_menu_fill($items, $args)
    {
        global $wpdb;
        global $post;
        
        $current_v_id = (isset($post->v_id)) ? $post->v_id : 0;
        
        $table_name_services = DC_SERVICES;
        
        $query_services = "SELECT * FROM $table_name_services";
        $services       = $wpdb->get_results($query_services);
        
        $menu_level = (isset(get_option('dc_option')['menu_level'])) ? 1 : 2;
        
        $show_service_name_on_subitems = (isset(get_option('dc_option')['show_service_name_on_subitems'])) ? true : false;
        $current_menu_item             = array();
        
        switch ($menu_level) {
            case 1:
            default:
                if (( ! is_object($args->menu) && $args->menu == 'services_menu') || (isset($args->menu->name) && $args->menu->name == 'services_menu')) {
                    foreach ($services as $service) {
                        if ($service->id == $current_v_id) {
                            $current_menu_item["class"] = " current_page_item current_menu_item";
                            $current_menu_item["aria"]  = ' aria-current="page"';
                        } else {
                            $current_menu_item["class"] = "";
                            $current_menu_item["aria"]  = "";
                        }
                        $items .= '<li id="menu-item-' . $service->id . '" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-' . $service->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . $service->alias . '/' . '"' . $current_menu_item["aria"] . '>' . __($service->service_name) . '</a></li>';
                    }
                }
                break;
            
            case 2:
                $table_name_regions = DC_REGIONS;
                $query_regions      = "SELECT * FROM $table_name_regions";
                $regions            = $wpdb->get_results($query_regions);
                
                $services_menu_separator = (isset(get_option('dc_option')['services_menu_separator'])) ? get_option('dc_option')['services_menu_separator'] : '';
                
                if (( ! is_object($args->menu) && $args->menu == 'services_menu') || (isset($args->menu->name) && $args->menu->name == 'services_menu')) {
                    foreach ($services as $service) {
                        if ($service->id == $current_v_id) {
                            $current_menu_item["class"] = " current_page_item current_menu_item";
                            $current_menu_item["aria"]  = ' aria-current="page"';
                        } else {
                            $current_menu_item["class"] = "";
                            $current_menu_item["aria"]  = "";
                        }
                        
                        $items .= '<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-' . $service->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . $service->alias . '/' . '"' . $current_menu_item["aria"] . '>' . __($service->service_name) . '</a>';
                        
                        $items .= '<button class="sub-menu-toggle" aria-expanded="false" onclick="twentytwentyoneExpandSubMenu(this)"><span class="icon-plus"><svg class="svg-icon" width="18" height="18" aria-hidden="true" role="img" focusable="false" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z" fill="currentColor"></path></svg></span><span class="icon-minus"><svg class="svg-icon" width="18" height="18" aria-hidden="true" role="img" focusable="false" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6 11h12v2H6z" fill="currentColor"></path></svg></span><span class="screen-reader-text">Открыть меню</span></button>';
                        $items .= '<ul class="sub-menu">';
                        
                        foreach ($regions as $region) {
                            if ($show_service_name_on_subitems) {
                                $service_name = $service->service_name;
                            } else {
                                $service_name            = "";
                                $services_menu_separator = "";
                            }
                            
                            if ($region->id == $current_v_id) {
                                $current_menu_item["class"] = " current_page_item current_menu_item";
                                $current_menu_item["aria"]  = ' aria-current="page"';
                            } else {
                                $current_menu_item["class"] = "";
                                $current_menu_item["aria"]  = "";
                            }
                            
                            $items .= '<li id="menu-item-' . $region->id . '" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-' . $region->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . $service->alias . '/' . $region->alias . '/' . '"' . $current_menu_item["aria"] . '>' . __($service_name) . __($services_menu_separator) . __($region->region_name) . '</a>';
                        }
                        
                        $items .= '</ul></li>';
                    }
                }
                break;
        }
        
        return $items;
    }
    
    function single_service_menu_fill($items, $args)
    {
        global $wpdb;
        global $post;
        $plugin_options                = get_option('dc_option');
        $current_v_id                  = (isset($post->v_id)) ? $post->v_id : 0;
        $service                       = get_single_service();
        $menu_item_name                = isset($plugin_options['menu_item_name']) ? $plugin_options['menu_item_name'] : null;
        $service->service_name         = (is_null($menu_item_name) || $menu_item_name == '') ? $service->service_name : $menu_item_name;
        $menu_level                    = (isset(get_option('dc_option')['menu_level'])) ? 1 : 2;
        $show_service_name_on_subitems = (isset(get_option('dc_option')['show_service_name_on_subitems'])) ? true : false;
        $current_menu_item             = array();
        
        switch ($menu_level) {
            case 1:
            default:
                if (( ! is_object($args->menu) && $args->menu == 'services_menu') || (isset($args->menu->name) && $args->menu->name == 'services_menu')) {
                    if ($service->id == $current_v_id) {
                        $current_menu_item["class"] = " current_page_item current_menu_item";
                        $current_menu_item["aria"]  = ' aria-current="page"';
                    } else {
                        $current_menu_item["class"] = "";
                        $current_menu_item["aria"]  = "";
                    }
                    $items .= '<li id="menu-item-' . $service->id . '" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-' . $service->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . '"' . $current_menu_item["aria"] . '>' . __($service->service_name) . '</a></li>';
                }
                break;
            
            case 2:
                $table_name_regions = DC_REGIONS;
                $query_regions      = "SELECT * FROM $table_name_regions";
                $regions            = $wpdb->get_results($query_regions);
                
                $services_menu_separator = isset(get_option('dc_option')['services_menu_separator']) ? get_option('dc_option')['services_menu_separator'] : '';
                
                if (( ! is_object($args->menu) && $args->menu == 'services_menu') || (isset($args->menu->name) && $args->menu->name == 'services_menu')) {
                    if ($service->id == $current_v_id) {
                        $current_menu_item["class"] = " current_page_item current_menu_item";
                        $current_menu_item["aria"]  = ' aria-current="page"';
                    } else {
                        $current_menu_item["class"] = "";
                        $current_menu_item["aria"]  = "";
                    }
                    
                    $items .= '<li class="menu-item menu-item-type-custom menu-item-object-custom menu-item-has-children menu-item-' . $service->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . '"' . $current_menu_item["aria"] . '>' . __($service->service_name) . '</a>';
                    
                    $items .= '<button class="sub-menu-toggle" aria-expanded="false" onclick="twentytwentyoneExpandSubMenu(this)"><span class="icon-plus"><svg class="svg-icon" width="18" height="18" aria-hidden="true" role="img" focusable="false" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z" fill="currentColor"></path></svg></span><span class="icon-minus"><svg class="svg-icon" width="18" height="18" aria-hidden="true" role="img" focusable="false" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M6 11h12v2H6z" fill="currentColor"></path></svg></span><span class="screen-reader-text">Открыть меню</span></button>';
                    $items .= '<ul class="sub-menu">';
                    
                    foreach ($regions as $region) {
                        if ($show_service_name_on_subitems) {
                            $service_name = $service->service_name;
                        } else {
                            $service_name            = "";
                            $services_menu_separator = "";
                        }
                        
                        if ($region->id == $current_v_id) {
                            $current_menu_item["class"] = " current_page_item current_menu_item";
                            $current_menu_item["aria"]  = ' aria-current="page"';
                        } else {
                            $current_menu_item["class"] = "";
                            $current_menu_item["aria"]  = "";
                        }
                        
                        $items .= '<li id="menu-item-' . $region->id . '" class="menu-item menu-item-type-custom menu-item-object-custom menu-item-' . $region->id . $current_menu_item["class"] . '"><a href="' . home_url('/') . $region->alias . '/' . '"' . $current_menu_item["aria"] . '>' . __($service_name) . __($services_menu_separator) . __($region->region_name) . '</a>';
                    }
                    
                    $items .= '</ul></li>';
                }
                break;
        }
        
        return $items;
    }
    
    function dynamic_catalog_admin_menu()
    { // step2_installation page slug
        
        $page_title     = 'Dynamic Catalog';
        $menu_title     = 'Dynamic Catalog';
        $capability     = 'manage_options';
        $main_menu_slug = 'dc-catalog';
        $function       = 'main_settings_page'; // → settings.php
        $icon_url       = 'dashicons-media-spreadsheet';
        $position       = 2;
        add_menu_page($page_title, $menu_title, $capability, $main_menu_slug, $function, $icon_url, $position);
        add_submenu_page(false, 'Step 2', 'Step 2', 'activate_plugins', 'step2_installation', 'installation_step_2');
        
        
        // TEMPLATES
        $page5_title = 'DC Templates';
        $menu_title  = 'Templates';
        $capability  = 'manage_options';
        $menu_slug   = 'dc-catalog-templates';
        $function    = 'dc_admin_templates_page';
        $position    = 3;
        add_submenu_page($main_menu_slug, $page5_title, $menu_title, $capability, $menu_slug, $function, $position);
        add_submenu_page('dc-catalog-templates', __('Add new', 'dc'), __('Add new', 'dc'), 'activate_plugins',
            'templates_form', 'dc_templates_form_page');
        
        
        // SERVICES
        $page2_title = 'DC Services';
        $menu_title  = 'Services';
        $capability  = 'manage_options';
        $menu_slug   = 'dc-catalog-services';
        $function    = 'dc_admin_services_page';
        $position    = 4;
        add_submenu_page($main_menu_slug, $page2_title, $menu_title, $capability, $menu_slug, $function, $position);
        add_submenu_page('dc-catalog-services', __('Add new', 'dc'), __('Add new', 'dc'), 'activate_plugins',
            'services_form', 'dc_services_form_page');
        
        
        // REGIONS
        $page3_title = 'DC Regions';
        $menu_title  = 'Regions';
        $capability  = 'manage_options';
        $menu_slug   = 'dc-catalog-regions';
        $function    = 'dc_admin_regions_page';
        $position    = 5;
        add_submenu_page($main_menu_slug, $page3_title, $menu_title, $capability, $menu_slug, $function, $position);
        add_submenu_page('dc-catalog-regions', __('Add new', 'dc'), __('Add new', 'dc'), 'activate_plugins',
            'regions_form', 'dc_regions_form_page');
        
        
        // CITIES
        $page4_title = 'DC Cities';
        $menu_title  = 'Cities';
        $capability  = 'manage_options';
        $menu_slug   = 'dc-catalog-cities';
        $function    = 'dc_admin_cities_page';
        $position    = 6;
        add_submenu_page($main_menu_slug, $page4_title, $menu_title, $capability, $menu_slug, $function, $position);
        add_submenu_page('dc-catalog-cities', __('Add new', 'dc'), __('Add new', 'dc'), 'activate_plugins',
            'cities_form', 'dc_cities_form_page');
        
        
        // COMPANIES
        $page4_title = 'DC Companies';
        $menu_title  = 'Companies';
        $capability  = 'manage_options';
        $menu_slug   = 'dc-catalog-companies';
        $function    = 'dc_admin_companies_page';
        $position    = 7;
        add_submenu_page($main_menu_slug, $page4_title, $menu_title, $capability, $menu_slug, $function, $position);
        add_submenu_page('dc-catalog-companies', __('Add new', 'dc'), __('Add new', 'dc'), 'activate_plugins',
            'companies_form', 'dc_companies_form_page');
    
        // Links filtering
        $page8_title = 'Filtering Data for GSC queue';
        $capability  = 'manage_options';
        $menu_title  = 'Links Filter';
        $menu_slug   = 'links_filter';
        $function = 'gsc_links_filter';
        $position = 8;
        add_submenu_page($main_menu_slug, $page8_title, $menu_title, $capability, $menu_slug, $function, 9);
        
        // GOOGLE Indexing API
        $page7_title = 'Google Search Console Managing';
        //$menu_title  = '<span class="text-red">GSC Queue</span>';
        $menu_title  = 'GSC Queue';
        $capability  = 'manage_options';
        $menu_slug   = 'gsc';
        $function = 'dc_admin_gsc';
        $position = 9;
        add_submenu_page($main_menu_slug, $page7_title, $menu_title, $capability, $menu_slug, $function, $position);
    
        
        // DB Managing
        $page6_title = 'DB manage';
        $menu_title  = 'DB manage';
        $capability  = 'manage_options';
        $menu_slug   = 'db_manage';
        $function    = 'dc_admin_db_manage';
        $position    = 10;
        add_submenu_page($main_menu_slug, $page6_title, $menu_title, $capability, $menu_slug, $function, $position);
        //add_submenu_page(false, 'Add Cities CSV', 'Add Cities CSV', 'activate_plugins', 'import_cities_csv','import_cities_csv');
    }