<?php
    defined('ABSPATH') or die('');
    
    add_action('admin_menu', 'dynamic_catalog_admin_menu');
    
    /*add_action('init', 'dc_languages');
    function dc_languages()
    {
        load_plugin_textdomain('dc', false, dirname(plugin_basename('pgen')));
    }
    */
    function dc_install()
    {
        if ( ! current_user_can('activate_plugins')) {
            return;
        }
        
        global $wpdb;
        
        $table_name_templates = $wpdb->prefix . 'page_templates';
        $table_name_regions   = $wpdb->prefix . 'regions';
        $table_name_services  = $wpdb->prefix . 'services';
        $table_name_cities    = $wpdb->prefix . 'new_cities';
        
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name_templates (
                      id int(11) NOT NULL AUTO_INCREMENT,
                      template_name text CHARACTER SET utf8 NOT NULL,
                      description text CHARACTER SET utf8,
                      title text CHARACTER SET utf8,
                      seo_h1 text CHARACTER SET utf8,
                      seo_description text CHARACTER SET utf8,
                      seo_excerpt text CHARACTER SET utf8,
                      content text CHARACTER SET utf8,
                      markup_file tinytext CHARACTER SET utf8 NOT NULL,
                      PRIMARY KEY (id) USING BTREE
                    ) $charset_collate;";
        $wpdb->query($sql);
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name_regions (
                      id int(11) NOT NULL AUTO_INCREMENT,
                      region_name text CHARACTER SET utf8 NOT NULL,
                      region_code tinytext CHARACTER SET utf8 NOT NULL,
                      alias text CHARACTER SET utf8,
                      description text CHARACTER SET utf8,
                      title text CHARACTER SET utf8,
                      seo_h1 text CHARACTER SET utf8,
                      seo_description text CHARACTER SET utf8,
                      seo_excerpt text CHARACTER SET utf8,
                      content text CHARACTER SET utf8,
                      template_id int(11) NOT NULL DEFAULT '1',
                      PRIMARY KEY (id) USING BTREE
                    ) $charset_collate;";
        $wpdb->query($sql);
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name_services (
                      id int(11) NOT NULL AUTO_INCREMENT,
                      service_name text CHARACTER SET utf8 NOT NULL,
                      plural text CHARACTER SET utf8 NOT NULL,
                      syn_1 text CHARACTER SET utf8 NOT NULL,
                      syn_2 text CHARACTER SET utf8 NOT NULL,
                      syn_3 text CHARACTER SET utf8 NOT NULL,
                      alias text CHARACTER SET utf8,
                      description text CHARACTER SET utf8,
                      title text CHARACTER SET utf8,
                      seo_h1 text CHARACTER SET utf8,
                      seo_description text CHARACTER SET utf8,
                      content text CHARACTER SET utf8,
                      seo_excerpt text CHARACTER SET utf8,
                      template_id int(11) NOT NULL DEFAULT '1',
                      PRIMARY KEY (id)
                    )  $charset_collate;";
        $wpdb->query($sql);
        
        $sql = "CREATE TABLE IF NOT EXISTS $table_name_cities (
                      id int(11) NOT NULL AUTO_INCREMENT,
                      city_name text CHARACTER SET utf8 NOT NULL,
                      city_code tinytext CHARACTER SET utf8 NOT NULL,
                      region_id int(5) NOT NULL DEFAULT '9999',
                      alias text CHARACTER SET utf8,
                      description text CHARACTER SET utf8,
                      region text CHARACTER SET utf8,
                      region_alias text CHARACTER SET utf8,
                      title text CHARACTER SET utf8,
                      seo_h1 text CHARACTER SET utf8,
                      seo_description text CHARACTER SET utf8,
                      seo_excerpt text CHARACTER SET utf8,
                      content text CHARACTER SET utf8,
                      template_id int(11) NOT NULL DEFAULT '1',
                      PRIMARY KEY (id) USING BTREE
                    ) $charset_collate;";
        $wpdb->query($sql);
    }
    
    function dc_deactivated()
    {
        if ( ! current_user_can('activate_plugins')) {
            return;
        }
        delete_option('dc_option');
    }
    
    function insert_mysql_data()
    {
        define('DC_PLUGIN_DIR', plugin_dir_path(__FILE__));
        $val = get_option('dc_option');
        
        $inst_type = isset($val['dc_installation_type']) ? $val['dc_installation_type'] : null;
        
        switch ($inst_type) {
            case 1:
                $services_file = DC_PLUGIN_DIR . "/csv/service.csv";
                break;
            
            case 2:
                $services_file = DC_PLUGIN_DIR . "/csv/services.csv";
                break;
            
            default:
                exit(wp_redirect(admin_url('admin.php?page=dc-catalog'))); // перенаправляем на выбор типа установки
                break;
        }
        
        global $wpdb, $wp_filesystem;
        if ( ! function_exists('unzip_file')) {
            require_once(ABSPATH . 'wp-admin/includes/file.php');
        }
        if ( ! $wp_filesystem) {
            WP_Filesystem();
        }
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        
        $page_templates_file = DC_PLUGIN_DIR . "/csv/page_templates.csv";
        $cities_file         = DC_PLUGIN_DIR . "/csv/cities.csv";
        $regions_file        = DC_PLUGIN_DIR . "/csv/regions.csv";
        
        $table_name_templates = $wpdb->prefix . 'page_templates';
        $table_name_regions   = $wpdb->prefix . 'regions';
        $table_name_services  = $wpdb->prefix . 'services';
        $table_name_cities    = $wpdb->prefix . 'new_cities';
        
        if (file_exists($cities_file) && is_readable($cities_file)) {
            $sql_insert = $wp_filesystem->get_contents($cities_file);
            $cities_sql = "INSERT INTO $table_name_cities (id,city_name,city_code,region_id,alias,description,region,region_alias,title,seo_h1,seo_description,seo_excerpt,content,template_id) VALUES $sql_insert;";
            dbDelta($cities_sql);
        }
        if (file_exists($regions_file) && is_readable($regions_file)) {
            $sql_insert  = $wp_filesystem->get_contents($regions_file);
            $regions_sql = "INSERT INTO $table_name_regions (id, region_name, region_code, alias, description, title, seo_h1, seo_description, seo_excerpt, content, template_id) VALUES $sql_insert;";
            dbDelta($regions_sql);
        }
        if (file_exists($services_file) && is_readable($services_file)) {
            $sql_insert   = $wp_filesystem->get_contents($services_file);
            $services_sql = "INSERT INTO $table_name_services (id, service_name, plural, syn_1, syn_2, syn_3, alias, description, title, seo_h1, seo_description, content, seo_excerpt, template_id) VALUES $sql_insert;";
            dbDelta($services_sql);
        }
        if (file_exists($page_templates_file) && is_readable($page_templates_file)) {
            $sql_insert         = $wp_filesystem->get_contents($page_templates_file);
            $page_templates_sql = "INSERT INTO $table_name_templates (id, template_name, description, title, seo_h1, seo_description, seo_excerpt, content, markup_file) VALUES $sql_insert;";
            dbDelta($page_templates_sql);
        }
        $val['mysql_installed'] = 1;
        update_option('dc_option', $val, 'no');
    }