<?php
    
    
    class IndexingTable extends WP_List_Table
    {
        
        public ?string $all_elements;
        
        function __construct()
        {
            parent::__construct(array(
                'singular' => 'link',
                'plural'   => 'links',
            ));
        }
        
        function column_default($item, $column_name)
        {
            return $item[$column_name];
        }
        
        function column_queue($item)
        {
            return ($item['queue'] == '999999') ? 'sent' : $item['queue'];
        }
        
        function column_url($item)
        {
            return '<a href="' . $item['url'] . '" target="_blank">' . $item['url'] . '</a>';
        }
        
        function column_type($item)
        {
            return $item['type'];
        }
        
        function column_status($item)
        {
            if ($item['status'] == 1) { // waiting
                $path   = plugin_dir_url(__FILE__) . 'images/clock.png';
                $output = '<img src="' . $path . '" />';
            } else {
                $path   = plugin_dir_url(__FILE__) . 'images/tick.png';
                $output = '<img src="' . $path . '" />';
            }
            
            return $output;
        }
        
        function column_description($item)
        {
            //return '<em>' . $item['description'] . '</em>';
        }
        
        function column_updated($item)
        {
            return (isset($item['updated'])) ? date('d.m.y H:i', strtotime($item['updated'])) : '';
            
        }
        
        function column_added($item)
        {
            return (isset($item['added'])) ? date('d.m.y H:i', strtotime($item['added'])) : '';
        }
        
        function column_created($item)
        {
            return (isset($item['created'])) ? date('d.m.y H:i', strtotime($item['created'])) : '';
        }
        
        function column_notes($item)
        {
            //return $item['notes'];
        }
        
        
        function column_cb($item)
        {
            return sprintf(
                '<input type="checkbox" name="id[]" value="%s" />',
                $item['id']
            );
        }
        
        
        function get_bulk_actions()
        {
            $actions = array(
                'up'     => '↑ UP ↑',
                'delete' => 'Delete'
            );
            
            return $actions;
        }
        
        function prepare_items()
        {
            global $wpdb;
            $table_name = DC_INDEXING;
            
            $per_page = 100;
            
            $columns  = $this->get_columns();
            $hidden   = array();
            $sortable = $this->get_sortable_columns();
            
            $this->_column_headers = array($columns, $hidden, $sortable);
            
            $this->process_bulk_action();
            $search_string = " WHERE `id`>0 ";
            
            if (isset($_REQUEST['s']) && strlen($_REQUEST['s']) > 2) {
                $prepare       = $wpdb->esc_like($_REQUEST['s']);
                $search_string .= " AND `url` LIKE '%$prepare%'";
            }
            
            if (isset($_REQUEST['type']) && strlen($_REQUEST['type']) > 2) {
                $search_string .= $wpdb->prepare(" AND `type`=%s", $_REQUEST['type']);
            }
            
            if (isset($_REQUEST['status']) && strlen($_REQUEST['status']) > 0) {
                $search_string .= $wpdb->prepare(" AND `status`=%d", $_REQUEST['status']);
            }
            
            $total_items = $wpdb->get_var("SELECT COUNT(`id`) FROM $table_name $search_string");
            if ($total_items > $per_page) {
                $all_items = $wpdb->get_results("SELECT `id` FROM $table_name $search_string");
                $all_ids   = [];
                foreach ($all_items as $item) {
                    $all_ids[] = $item->id;
                }
                $all_items          = implode(",", $all_ids);
                $this->all_elements = $all_items;
            }
            
            $paged   = isset($_REQUEST['paged']) ? max(0, intval($_REQUEST['paged']) - 1) : 0;
            $orderby = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'],
                    array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'queue';
            $order   = (isset($_REQUEST['order']) && in_array($_REQUEST['order'],
                    array('asc', 'desc'))) ? $_REQUEST['order'] : 'asc';
            
            
            $offset      = $paged * $per_page;
            $query       = "SELECT * FROM $table_name $search_string ORDER BY $orderby $order  LIMIT $per_page OFFSET $offset";
            $this->items = $wpdb->get_results($query, ARRAY_A);
            
            $this->set_pagination_args(array(
                'total_items' => $total_items,
                'per_page'    => $per_page,
                'total_pages' => ceil($total_items / $per_page)
            ));
        }
        
        function get_columns()
        {
            $columns = array(
                'cb'          => '<input type="checkbox" />',
                'queue'       => __('Order', 'dc'),
                'status'      => __('Status', 'dc'),
                'url'         => __('URL', 'dc'),
                'type'        => __('Type', 'dc'),
                //'description' => __('Descr.', 'dc'),
                'updated'     => __('Queue updated', 'dc'),
                'added'       => __('Sent to GSC', 'dc'),
                'created'     => __('Added to queue', 'dc'),
                //'notes'       => __('Notes', 'dc')
            );
            
            return $columns;
        }
        
        function get_sortable_columns()
        {
            $sortable_columns = array(
                'queue'   => array('queue', true),
                'status'  => array('status', true),
                'url'     => array('url', true),
                'type'    => array('type', true),
                'created' => array('created', true),
                'updated' => array('updated', true),
                'added'   => array('added', true)
            );
            
            return $sortable_columns;
        }
        
        function process_bulk_action()
        {
            $ids          = isset($_REQUEST['id']) ? $_REQUEST['id'] : array();
            $all_elements = isset($_REQUEST['all_elements']) ? $_REQUEST['all_elements'] : array();
            
            if ( ! empty($all_elements)) {
                $ids = explode(",", $all_elements);
            }
            switch ($this->current_action()) {
                
                case 'delete':
                    if ( ! empty($ids)) delete_links($ids);
                    break;
                case 'up':
                    if ( ! empty($ids)) up_links($ids);
                    break;
                default:
                    break;
            }
        }
    }
    
    function show_queue_table()
    {
        $table = new IndexingTable();
        $table->prepare_items();
        
        $message = '';
        if ('delete' === $table->current_action() && is_array($_REQUEST['id'])) {
            $message = '<div class="updated below-h2" id="message"><p>' . sprintf(__('Items deleted: %d', 'dc'),
                    count($_REQUEST['id'])) . '</p></div>';
        }
        if ('up' === $table->current_action() && isset($_REQUEST['id']) && is_array($_REQUEST['id'])) {
            $message = '<div class="updated below-h2" id="message"><p>' . sprintf(__('Items UP\'ed: %d', 'dc'),
                    count($_REQUEST['id'])) . '</p></div>';
        }
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br/></div>
			<h2><?php _e('Indexing Queue Table', 'dc') ?></h2><?php
                echo $message; ?>
			<form id="indexing-links-table" method="POST">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>"/>
				<input type="hidden" name="s"
				       value="<?php (isset($_REQUEST['s'])) ? esc_attr($_REQUEST['s']) : ''; ?>"/>
				<input type="hidden" name="type"
				       value="<?php (isset($_REQUEST['type'])) ? esc_attr($_REQUEST['type']) : ''; ?>"/>
				<input type="hidden" name="status"
				       value="<?php (isset($_REQUEST['status'])) ? esc_attr($_REQUEST['status']) : ''; ?>"/><?php
                    if (isset($table->all_elements)) {
                        ?>
						<input type="hidden" id="all_elements" value="<?php echo $table->all_elements; ?>"/>
                        <?php
                    }
                ?>
                
                <?php $table->search_box(__('Search', 'dc'), 'search'); ?>
                <?php $table->display() ?>
			</form>
		</div>
        <?php
    }