<?php
    
    //define('GRAB_LINKS', true);
    
    function gsc_links_filter()
    {
        $val              = get_option('dc_option');
        $population_limit = isset($val['dc_population_limit']) ? $val['dc_population_limit'] : 10000;
        $services         = get_all_services();
        $regions          = get_regions();
        
        include "links_filtering.php";
    }
    
    function filter_gsc_links()
    {
        
        $request = $_REQUEST;
        if ( ! isset($request['task'])) die;
        $task = $request['task'];
        global $wpdb;
        $cities_table    = DC_CITIES;
        $indexing_table  = DC_INDEXING;
        $addresses_table = DC_ADDRESSES;
        $companies_table = DC_COMPANIES;
        
        $output          = new stdClass();
        $output->task    = $task;
        $output->status  = 0;
        $output->message = '';
        $output->error   = '';
        $output->regions = '';
        $output->cities  = '';
        
        switch ($task) {
            case 'truncate_queue':
                $wpdb->query("TRUNCATE $indexing_table");
                echo '<span class="success_message">Queue table truncated</span>';
                die;
                break;
            case 'get_regions':
                $services = isset($request['services']) ? $request['services'] : null;
                if ($services) {
                    $regions_whitelist = get_regions_whitelist($services, true);
                    if ($regions_whitelist) {
                        $output->regions = $regions_whitelist;
                        $output->status  = 1;
                    }
                }
                break;
            case 'get_cities':
            default:
                $val              = get_option('dc_option');
                $population_limit = isset($val['dc_population_limit']) ? $val['dc_population_limit'] : 10000;
                
                if (isset($request['population'])) {
                    $val              = get_option('dc_option');
                    $population       = $request['population'];
                    $population_limit = isset($val['dc_population_limit']) ? $val['dc_population_limit'] : 10000;
                    $population       = ($population < $population_limit) ? $population_limit : $population;
                }
                
                $regions = isset($request['regions']) ? $request['regions'] : null;
                $search  = isset($request['s']) ? $request['s'] : null;
                
                if ($regions) {
                    $region_ids = implode(",", $regions);
                    $query      = "SELECT * FROM $cities_table WHERE `region_id` IN ($region_ids)";
                    $query      .= " AND population>=$population";
                    if ($search) $query .= " AND city_name LIKE '%$search%'";
                    $query .= " ORDER BY `population` DESC";
                    
                    $cities          = $wpdb->get_results($query);
                    $output->message = '';
                    if ($cities) {
                        $output->status = 1;
                        $output->cities = $cities;
                    } else {
                        $output->status  = 0;
                        $output->message = 'No result';
                    }
                }
                break;
            case 'add_to_queue':
                $queue     = $request['queue'];
                $queue     = str_replace(']"', ']', stripslashes($queue));
                $json_data = '{"data" : ' . $queue . '}';
                
                $json_data = json_decode($json_data, true)['data'];
                
                if (is_array($json_data) && count($json_data) > 0) {
                    $services_array  = array();
                    $regions_array   = array();
                    $cities_array    = array();
                    $companies_array = array();
                    $i               = 0;
    
                    foreach ($json_data as $link) {
                        switch ($link['t']) {
                            case 'service':
                                $services_array[$i] = $link['id'];
                                break;
                            
                            case 'region':
                                $regions_array[$i] = $link['id'];
                                break;
                            
                            case 'company':
                                $companies_array[$i] = $link['id'];
                                break;
                            
                            case 'city':
                            default:
                                $cities_array[$i] = $link['id'];
                                break;
                        }
                        $i++;
                    }
                    
                    if (count($services_array) > 0) $services = get_instanse_by_id('services', implode(',', $services_array));
                    if (count($regions_array) > 0) $regions = get_instanse_by_id('regions', implode(',', $regions_array));
                    if (count($cities_array) > 0) $cities = get_instanse_by_id('new_cities', implode(',', $cities_array));
                    if (count($companies_array) > 0) $companies = get_instanse_by_id('companies', implode(',', $companies_array));
                    
                    
                    $data_to_insert = array();
                    $home           = home_url('/');
                    foreach ($json_data as $link) {
                        switch ($link['t']) {
                            case 'service':
                                $service          = search_item_by_id($link['id'], $services);
                                $data_to_insert[] = [
                                    'type'       => 'service',
                                    'url'        => $home . $service->alias . '/',
                                    'element_id' => $service->id
                                ];
                                break;
                            
                            case 'region':
                                $region           = search_item_by_id($link['id'], $regions);
                                $data_to_insert[] = [
                                    'type'       => 'region',
                                    'url'        => $home . $region->alias . '/',
                                    'element_id' => $region->id
                                ];
                                break;
                            
                            case 'company':
                                $company          = search_item_by_id($link['id'], $companies);
                                $data_to_insert[] = [
                                    'type'       => 'company',
                                    'url'        => $home . $company->alias . '/',
                                    'element_id' => $company->id
                                ];
                                break;
                            
                            case 'city':
                            default:
                                $city             = search_item_by_id($link['id'], $cities);
                                $data_to_insert[] = [
                                    'type'       => 'city',
                                    'url'        => $home . $city->region_alias . '/' . $city->alias . '/',
                                    'element_id' => $city->id
                                ];
                                break;
                        }
                    }
                    
                    
                    if (count($data_to_insert) > 0) {
                        $max_queue    = null;
                        $total_to_add = count($data_to_insert);
                        
                        if (count(get_indexing_links()) > 0) { // в очереди уже есть записи
                            
                            if (count($services_array) > 0) {
                                $services_to_delete = implode(',', $services_array);
                                delete_items_by_type_ids('service', $services_to_delete);
                            }
                            if (count($regions_array) > 0) {
                                $regions_to_delete = implode(',', $regions_array);
                                delete_items_by_type_ids('region', $regions_to_delete);
                            }
                            if (count($cities_array) > 0) {
                                $cities_to_delete = implode(',', $cities_array);
                                delete_items_by_type_ids('city', $cities_to_delete);
                            }
                            if (count($companies_array) > 0) {
                                $companies_to_delete = implode(',', $companies_array);
                                delete_items_by_type_ids('company', $companies_to_delete);
                            }
                            
                            $wpdb->query("DROP TABLE IF EXISTS tempTable");
                            $wpdb->query("CREATE TEMPORARY TABLE tempTable (id INT(11) NOT NULL) COLLATE=latin1_swedish_ci ENGINE=MyISAM ROW_FORMAT=DEFAULT");
                            $wpdb->query("INSERT INTO tempTable SELECT id FROM $indexing_table ORDER BY queue");
                            $wpdb->query("ALTER TABLE tempTable ADD COLUMN `queue` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, ADD PRIMARY KEY (`queue`)");
                            $wpdb->query("UPDATE $indexing_table INNER JOIN tempTable ON $indexing_table.id = tempTable.id SET $indexing_table.queue = tempTable.queue");
                            $wpdb->query("DROP TABLE tempTable");
                            $wpdb->query("UPDATE $indexing_table SET queue=queue+$total_to_add WHERE queue>0");
                            $wpdb->query("UPDATE $indexing_table SET queue=999999 WHERE status>1");
                            
                            
                            if ($request['add_to_end'] == 1) { // добавление в конец очереди
                                $max_queue = $wpdb->get_var("SELECT MAX(`queue`) FROM $indexing_table WHERE `queue`<999999");
                            }
                            
                        }
                        insert_values_into_queue_table($data_to_insert, $max_queue);
                        echo '<span class="success_message">' . $total_to_add . ' links added</span>';
                    } else echo '<span class="error_message">Nothing to add...</span>';
                } else echo '<span class="error_message">Something goes wrong...</span>';
                
                die;
                break;
            case 'get_parents':
                
                $query_companies_top = "SELECT COUNT(a.id) AS total, a.company_id, c.company_name AS company, c.alias
                                        FROM $addresses_table AS a
                                        INNER JOIN $companies_table AS c
                                        ON c.id=a.company_id
                                        GROUP BY (a.company_id) ORDER BY COUNT(a.id) DESC";
                $companies           = $wpdb->get_results($query_companies_top);
                
                $address_limit = (isset($request['addresses'])) ? $request['addresses'] : 1;
                $parents       = [];
                foreach ($companies as $company) {
                    if ($company->total > $address_limit) {
                        $parents[] = $company;
                    }
                }
                if (count($parents) > 0) {
                    $output->status  = 1;
                    $output->parents = $parents;
                } else { // нет компаний
                    $output->status  = 0;
                    $output->message = 'No result';
                }
                
                break;
        }
        
        echo json_encode($output);
        wp_die();
    }
    
    function delete_items_by_type_ids($type, $ids)
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        $query_delete   = $wpdb->prepare("DELETE FROM $indexing_table WHERE type=%s AND element_id IN ($ids)", $type);
        $wpdb->query($query_delete);
    }
    
    function search_item_by_id($search, $array)
    {
        foreach ($array as $item) {
            if ($item->id === $search) return $item;
        }
    }
    
    function dc_admin_gsc() // start point
    {
        require "indexing_table.php";
        show_queue_table();
    }
    
    function get_indexing_links(): array
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        $query          = "SELECT * FROM $indexing_table";
        
        return $wpdb->get_results($query, ARRAY_A);
    }
    
    function insert_values_into_queue_table($array, $max_queue = null)
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        date_default_timezone_set('Europe/Minsk');
        $current_date = date('Y-m-d H:i:s');
        $links_to_add = array();
        
        
        if (count($array) == 0) return false;
        $queue = (isset($max_queue)) ? $max_queue + 1 : 1;
        
        foreach ($array as $link) {
            $links_to_add[] = $wpdb->prepare("(NULL, %d, %s, 1, %s, %s, NULL, NULL, NULL, %s, NULL)", $queue, $link['element_id'], $link['url'], $link['type'], $current_date);
            $queue++;
        }
        $query = "INSERT IGNORE INTO $indexing_table (`id`, `queue`, `element_id`, `status`, `url`, `type`, `description`, `updated`, `added`, `created`, `notes`) VALUES ";
        $query .= implode(",\n", $links_to_add);
        
        $wpdb->query($query);
        rearrange_table();
        
        return false;
    }
    
    function delete_links($links_ids_array)
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        
        if (is_array($links_ids_array)) {
            $links_ids_comma_separated = implode(',', $links_ids_array);
        }
        foreach ($links_ids_array as $id) {
            $current_order = $wpdb->get_var($wpdb->prepare("SELECT queue FROM $indexing_table WHERE id=%d", $id));
            $wpdb->query($wpdb->prepare("UPDATE $indexing_table SET queue=queue-1 WHERE queue>%d", $current_order));
            $wpdb->query("UPDATE $indexing_table SET queue=999999 WHERE status>1");
        }
        $wpdb->query("DELETE FROM $indexing_table WHERE id IN($links_ids_comma_separated)");
    }
    
    function up_links($links_ids_array)
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        date_default_timezone_set('Europe/Minsk');
        $current_date    = date('Y-m-d H:i:s');
        $links_ids_array = array_reverse($links_ids_array);
        foreach ($links_ids_array as $id) {
            $upd_queue = "UPDATE $indexing_table SET `queue`=`queue`+1 WHERE `queue`>0";
            $wpdb->query($upd_queue);
            $set_new_order = $wpdb->prepare("UPDATE $indexing_table SET `queue`=1, `status`=1, `added`=NULL, `updated`=%s WHERE `id`=%d", $current_date, $id);
            $wpdb->query($set_new_order);
            $wpdb->query("UPDATE $indexing_table SET `queue`=999999 WHERE `status`>1");
        }
        rearrange_table();
    }
    
    function rearrange_table($direction = 'ASC')
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        $wpdb->query("DROP TABLE IF EXISTS tempTable");
        $wpdb->query("CREATE TEMPORARY TABLE tempTable (id INT(11) NOT NULL) COLLATE=latin1_swedish_ci ENGINE=MyISAM ROW_FORMAT=DEFAULT");
        $wpdb->query("INSERT INTO tempTable SELECT id FROM $indexing_table ORDER BY queue $direction");
        $wpdb->query("ALTER TABLE tempTable ADD COLUMN `queue` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT, ADD PRIMARY KEY (`queue`)");
        $wpdb->query("UPDATE $indexing_table INNER JOIN tempTable ON $indexing_table.id = tempTable.id SET $indexing_table.queue = tempTable.queue");
        $wpdb->query("DROP TABLE tempTable");
        $wpdb->query("UPDATE $indexing_table SET queue=999999 WHERE status>1");
    }
    
    add_filter('bulk_actions-edit-post', 'add_bulk_action_gsc');
    add_filter('bulk_actions-edit-page', 'add_bulk_action_gsc');
    add_filter('handle_bulk_actions-edit-post', 'adding_post_id_to_gsc', 10, 3);
    add_filter('handle_bulk_actions-edit-page', 'adding_post_id_to_gsc', 10, 3);
    
    add_action('admin_notices', 'admin_notice_gsc');
    function add_bulk_action_gsc($bulk_actions)
    {
        $bulk_actions['queue'] = __('Add to GSC queue', 'dc');
        
        return $bulk_actions;
    }
    
    function adding_post_id_to_gsc($redirect_url, $action, $post_ids)
    {
        $urls = [];
        if ($action == 'queue') {
            foreach ($post_ids as $post_id) {
                $post   = get_posts($post_id);
                $urls[] = [
                    'element_id' => $post_id,
                    'url'        => get_permalink($post_id),
                    'type'       => 'wp'
                ];
            }
            insert_values_into_queue_table($urls);
            $redirect_url = add_query_arg('added-to-gsc', count($post_ids), $redirect_url);
        }
        
        return $redirect_url;
    }
    
    function admin_notice_gsc()
    {
        if ( ! empty($_REQUEST['added-to-gsc'])) {
            $num_changed = (int)$_REQUEST['added-to-gsc'];
            printf('<div id="message" class="updated notice is-dismissable"><p>' . __('%d item(s) added to GSC', 'dc') . '</p></div>', $num_changed);
        }
    }
    
    // cron tasks
    // https://www.kobzarev.com/wordpress/debug-wordpress-cron/
    // WP CLI install : curl -O https://raw.githubusercontent.com/wp-cli/builds/gh-pages/phar/wp-cli.phar
    // php wp-cli.phar --info
    // php wp-cli.phar cron event list
    // php wp-cli.phar cron event delete gsc_queue_processing
    // php wp-cli.phar cron event run gsc
    
    include "KamaCron.php";
    
    new Kama_Cron([
        'id'     => 'gsc',
        'events' => array(
            'gsc' => array(
                'callback'      => 'gsc_queue_processing',
                'interval_name' => 'Каждые 6 часов',
                'interval_sec'  => 21600, // каждые 6 часов
                'interval_desc' => 'Каждые 6 часов',
            ),
        ),
    ]);
    //Kama_Cron::$DEBUG = 1;
    
    function gsc_queue_processing()
    {
        global $wpdb;
        $indexing_table = DC_INDEXING;
        date_default_timezone_set('Europe/Minsk');
        $current_date = date('Y-m-d H:i:s');
        
        $query_get_first = "SELECT * FROM $indexing_table WHERE `status`=1 AND `queue`<999999 ORDER BY `queue` LIMIT 0,50";
        $links           = $wpdb->get_results($query_get_first);
        if (count($links) > 0) { // есть что добавить в очередь
            $urls = [];
            $ids  = [];
            
            foreach ($links as $url) {
                $urls[] = $url->url;
                $ids[]  = $url->id;
            }
            $ids = implode(',', $ids);
            
            send_urls_to_gsc($urls); // TODO: раскомментить на проде
            
            $wpdb->query($wpdb->prepare("UPDATE $indexing_table SET `queue`=999999, `status`=2, `added`=%s WHERE `id` IN ($ids)", $current_date));
            $wpdb->query("UPDATE $indexing_table SET `queue`=queue-50 WHERE `queue`<999999");
        }
    }
    
    // API processing
    function send_urls_to_gsc($urls)
    {
        require_once 'vendor/autoload.php';
        
        $client = new Google\Client();
        
        $client->setApplicationName("PDL_GSC_Queue");
        
        $client->setAuthConfig(__DIR__ . '/usapaydayloansdl-53811e94825c.json');
        
        $client->addScope('https://www.googleapis.com/auth/indexing');
        $client->setUseBatch(true);
        
        $service = new Google_Service_Indexing($client);
        $batch   = $service->createBatch();
        
        foreach ($urls as $url) {
            $postBody = new Google_Service_Indexing_UrlNotification();
            $postBody->setType('URL_UPDATED');
            $postBody->setUrl($url);
            $batch->add(
                $service->urlNotifications->publish($postBody)
            );
        }
        $batch->execute();
    }