<?php
    function dc_regions_page_handler()
    {
        $table = new RegionTable();
        $table->prepare_items();
        
        $message = '';
        if ('delete' === $table->current_action()) {
            $message = '<div class="updated below-h2" id="message"><p>' . sprintf(__('Items deleted: %d', 'dc'),
                    count($_REQUEST['id'])) . '</p></div>';
        }
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br/></div>
			<h2><?php _e('Regions', 'dc') ?> <a class="add-new-h2" href="<?php echo get_admin_url(get_current_blog_id(),
                    'admin.php?page=regions_form'); ?>"><?php _e('Add new', 'dc') ?></a>
			</h2><?php echo $message; ?>
			<form id="regions-table" method="POST">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>"/>
                <?php $table->search_box(__('Search', 'dc'), 'search'); ?>
                <?php $table->display() ?>
			</form>
		</div>
        <?php
    }
    
    function dc_regions_form_page_handler()
    {
        global $wpdb;
        $message    = '';
        $notice     = '';
        
        $plugin_options    = get_option('dc_option');
        $installation_type = ($plugin_options['dc_installation_type'] === 1) ? 1 : 2;
        
        $services = ($installation_type == 1) ? (int)get_single_service()->id : get_all_services();
        
        $default = array(
            'id'              => 0,
            'region_name'     => '',
            'alias'           => '',
            'description'     => '',
            'title'           => null,
            'seo_h1'          => '',
            'seo_description' => '',
            'content'         => '',
            'seo_excerpt'     => '',
            'template_id'     => '1',
            'services'        => $services
        );
        
        if (isset($_REQUEST['nonce']) && wp_verify_nonce($_REQUEST['nonce'], basename(__FILE__))) {
            $item       = shortcode_atts($default, $_REQUEST);
            $item_valid = dc_region_validate_region($item);
            if ($item_valid === true) {
                if ($item['id'] == 0) { // new region
                    if (empty($item['alias'])) {
                        $item['alias'] = sanitize_title($item['region_name']);
                    }
                    $item['content']     = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt'] = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $result              = $wpdb->insert(DC_REGIONS, $item);
                    $item['id']          = $wpdb->insert_id;
                    if ($result) {
                        $message = __('region was successfully saved', 'dc');
                    } else {
                        $notice = __('There was an error while saving region', 'dc');
                    }
                } else {
                    $item['content']     = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt'] = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $result              = $wpdb->update(DC_REGIONS, $item, array('id' => $item['id']));
                    if ($result) {
                        $message = __('Item was successfully updated', 'dc');
                    } else {
                        $notice = __('There was an error while updating item', 'dc');
                    }
                }
            } else {
                $notice = $item_valid;
            }
        } else {
            $item = $default;
            $regions_table = DC_REGIONS;
            if (isset($_REQUEST['id'])) {
                $item = $wpdb->get_row($wpdb->prepare("SELECT * FROM $regions_table WHERE id = %d", $_REQUEST['id']),
                    ARRAY_A);
                if ( ! $item) {
                    $item   = $default;
                    $notice = __('Item not found', 'dc');
                }
            }
        }
        
        add_meta_box('dc_regions_form_meta_box', __('regions data', 'dc'), 'dc_regions_form_meta_box_handler', 'region', 'normal', 'default');
        
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
			<h2><?php _e('region', 'dc') ?> <a class="add-new-h2" href="<?php echo get_admin_url(get_current_blog_id(),
                    'admin.php?page=dc-catalog-regions'); ?>"><?php _e('back to regions list', 'dc') ?></a>
			</h2><?php if ( ! empty($notice)): ?>
				<div id="notice" class="error"><p><?php echo $notice ?></p></div><?php endif;
                if ( ! empty($message)): ?>
					<div id="message" class="updated"><p><?php echo $message ?></p></div><?php endif; ?>

			<form id="form" method="POST">
				<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__)) ?>"/>
				<input type="hidden" name="id" value="<?php echo $item['id'] ?>"/>
				<div class="metabox-holder" id="poststuff">
					<div id="post-body">
						<div id="post-body-content"><?php do_meta_boxes('region', 'normal', $item); ?>
							<input type="submit" value="<?php _e('Save', 'dc') ?>" id="submit" class="button-primary"
							       name="submit">
						</div>
					</div>
				</div>
			</form>
		</div>
        <?php
    }
    
    function dc_regions_form_meta_box_handler($item)
    {
        $templates = get_templates();
        $services  = get_all_services();
        ?>
		<tbody>
		<div class="formdatabc">
			<form>
				<div class="form3bc">
					<p>
						<label for="region_name"><?php _e('region', 'dc') ?></label>
						<br>
						<input id="region_name" name="region_name" type="text"
						       value="<?php echo esc_attr($item['region_name']) ?>" required>
					</p>
					<p>
						<label for="alias"><?php _e('Alias', 'dc') ?></label>
						<br>
						<input id="alias" name="alias" type="text" value="<?php echo esc_attr($item['alias']) ?>">
					</p>
					<p>
						<label for="description"><?php _e('Description', 'dc') ?></label>
						<br>
						<input id="description" name="description" type="text"
						       value="<?php echo esc_attr($item['description']) ?>">
					</p></div>
				<div class="form3bc">
					<p>
						<label for="title"><?php _e('Title', 'dc') ?></label>
						<br>
						<input id="title" name="title" type="text" value="<?php echo esc_attr($item['title']) ?>">
					</p>
				</div>
				<div class="form3bc">
					<p>
						<label for="seo_h1"><?php _e('H1', 'dc') ?></label>
						<br>
						<input id="seo_h1" name="seo_h1" type="text" value="<?php echo esc_attr($item['seo_h1']) ?>">
					</p>
					<p>
						<label for="seo_description"><?php _e('SEO Description', 'dc') ?></label>
						<br>
						<input id="seo_description" name="seo_description" type="text"
						       value="<?php echo esc_attr($item['seo_description']) ?>">
					</p>
					<p>
						<label for="template_id"><?php _e('Template', 'dc') ?></label>
						<br>
						<select id="template_id" name="template_id"><?php
                                foreach ($templates as $template) {
                                    ($template->id == $item['template_id']) ? $selected = ' selected' : $selected = '';
                                    ?>
									<option value="<?php echo esc_attr($template->id); ?>"<?php echo $selected; ?>><?php echo esc_attr($template->template_name); ?></option>
                                    <?php
                                }
                            ?>
						</select>
					</p>
				</div>
				<div class="form1bc">
					<p><h4>Allowed services:</h4><?php
                        
                        /*echo '<pre>';
                        print_r($services);
                        echo '</pre>';*/
                        foreach ($services as $service) {
                            ($service->id == $item['services']) ? $checked = ' checked' : $checked = '';
                            ?>
							<label>
							<input type="checkbox" name="service[]"
							       value="<?php echo $service->id; ?>"<?php echo $checked; ?>><?php echo $service->service_name; ?>
							<br/>
							</label><?php
                        }
                    ?>
					</p>
				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="seo_excerpt"><?php _e('Excerpt:', 'dc') ?></label>
					<br><?php
                        $exc_id  = "seo_excerpt";
                        $excerpt = stripslashes($item['seo_excerpt']);
                        wp_editor($excerpt, strtolower($exc_id));
                    ?>
					</p>
				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="content"><?php _e('Content:', 'dc') ?></label>
					<br><?php
                        $id      = "content";
                        $content = stripslashes($item['content']);
                        wp_editor($content, strtolower($id));
                    ?>
					</p>
				</div>
			</form>
		</div>
		</tbody>
        <?php
    }
    
    function dc_region_validate_region($item)
    {
        $messages = array();
        if (empty($item['region_name'])) {
            $messages[] = __('region Name is required', 'dc');
        }
        if (empty($messages)) {
            return true;
        }
        
        return implode('<br />', $messages);
    }