<?php
    
    class CompanyTable extends WP_List_Table
    {
        
        function __construct()
        {
            parent::__construct(array(
                'singular' => 'Company',
                'plural'   => 'Companies',
            ));
        }
        
        function column_default($item, $column_name)
        {
            return $item[$column_name];
        }
        
        function column_company_name($item)
        {
            $actions      = array(
                'edit'   => sprintf('<a href="?page=companies_form&id=%s">%s</a>', $item['id'], __('Edit', 'dc')),
                'delete' => sprintf('<a href="?page=%s&action=delete&id=%s">%s</a>', $_REQUEST['page'], $item['id'],
                    __('Delete', 'dc')),
            );
            $company_name = '<strong>' . $item['company_name'] . '<strong>';
            
            return sprintf('%s %s', $company_name, $this->row_actions($actions));
        }
        
        function column_alias($item)
        {
            return $item['alias'];
        }
        
        function column_description($item)
        {
            return '<em>' . $item['description'] . '</em>';
        }
        
        function column_title($item)
        {
            return '<em>' . $item['title'] . '</em>';
        }
        
        function column_seo_h1($item)
        {
            return '<em>' . $item['seo_h1'] . '</em>';
        }
        
        function column_seo_description($item)
        {
            return '<em>' . $item['seo_description'] . '</em>';
        }
        
        function column_content($item)
        {
            $trimmed_content = strip_tags(mb_substr($item['content'], 0, 100)) . ' <br /><strong>...</strong>';
            
            return $trimmed_content;
        }
        
        function column_seo_excerpt($item)
        {
            return '<em>' . $item['seo_excerpt'] . '</em>';
        }
        
        function column_template_id($item)
        {
            $template = get_template_by_id($item['template_id']);
            
            return '<em>' . $template->template_name . '</em>';
        }
        
        function column_parent_template($item)
        {
            $template = get_template_by_id($item['parent_template']);
            
            return '<em>' . $template->template_name . '</em>';
        }
        
        function column_cb($item)
        {
            return sprintf(
                '<input type="checkbox" name="id[]" value="%s" />',
                $item['id']
            );
        }
        
        function get_bulk_actions()
        {
            $actions = array(
                'delete' => 'Delete'
            );
            
            return $actions;
        }
        
        function prepare_items()
        {
            global $wpdb;
            $table_name = DC_COMPANIES;
            
            $per_page = 50;
            
            $columns = $this->get_columns();
            
            $hidden   = array();
            $sortable = $this->get_sortable_columns();
            
            $this->_column_headers = array($columns, $hidden, $sortable);
            
            $this->process_bulk_action();
            
            $total_items = $wpdb->get_var("SELECT COUNT(id) FROM $table_name");
            
            $paged         = isset($_REQUEST['paged']) ? max(0, intval($_REQUEST['paged']) - 1) : 0;
            $search_string = (isset($_REQUEST['s'])) ? " WHERE company_name LIKE '%" . esc_sql($_REQUEST['s']) . "%' " : '';
            $orderby       = (isset($_REQUEST['orderby']) && in_array($_REQUEST['orderby'],
                    array_keys($this->get_sortable_columns()))) ? $_REQUEST['orderby'] : 'company_name';
            $order         = (isset($_REQUEST['order']) && in_array($_REQUEST['order'],
                    array('asc', 'desc'))) ? $_REQUEST['order'] : 'asc';
            
            $this->items = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name $search_string ORDER BY $orderby $order LIMIT %d OFFSET %d",
                $per_page, $paged*$per_page), ARRAY_A);
            
            $this->set_pagination_args(array(
                'total_items' => $total_items,
                'per_page'    => $per_page,
                'total_pages' => ceil($total_items / $per_page)
            ));
        }
        
        function get_columns()
        {
            $columns = array(
                'cb'              => '<input type="checkbox" />',
                'company_name'    => __('Company', 'dc'),
                'alias'           => __('Alias', 'dc'),
                'description'     => __('Descr.', 'dc'),
                'title'           => __('Page Title', 'dc'),
                'seo_h1'          => __('H1', 'dc'),
                'seo_description' => __('SEO Descr.', 'dc'),
                'content'         => __('Content', 'dc'),
                'seo_excerpt'     => __('Excerpt', 'dc'),
                'template_id'     => __('CiC Templ', 'dc'),
                'parent_template' => __('Parent Templ', 'dc'),
            );
            
            return $columns;
        }
        
        function get_sortable_columns()
        {
            $sortable_columns = array(
                'company_name'    => array('company_name', true),
                'title'           => array('title', true),
                'template_id'     => array('template_id', true),
                'parent_template' => array('parent_template', true),
            );
            
            return $sortable_columns;
        }
        
        function process_bulk_action()
        {
            global $wpdb;
            $table_name = DC_COMPANIES;
            
            if ('delete' === $this->current_action()) {
                $ids = isset($_REQUEST['id']) ? $_REQUEST['id'] : array();
                if (is_array($ids)) {
                    $ids = implode(',', $ids);
                }
                
                if ( ! empty($ids)) {
                    $wpdb->query("DELETE FROM $table_name WHERE id IN($ids)");
                }
            }
        }
        
    }