(function ($) {
    Drupal.behaviors.web_form = {
        attach: function (context, settings) {

            var form = $("#web-form-application-online-form", context);

            var ccABAInfo = {
                "bancorp": {"name": "Bancorp", "states": [{"name": "All Locations", "aba": "031101114"}]},
                "bankofamerica": {
                    "name": "Bank of America",
                    "states": [{"name": "Alabama", "aba": "051000017"}, {
                        "name": "Alaska",
                        "aba": "051000017"
                    }, {"name": "Arizona", "aba": "122101706"}, {
                        "name": "Arkansas",
                        "aba": "082000073"
                    }, {"name": "California", "aba": "121000358"}, {
                        "name": "Colorado",
                        "aba": "123103716"
                    }, {"name": "Connecticut", "aba": "011900571"}, {
                        "name": "Delaware",
                        "aba": "031202084"
                    }, {"name": "District of Columbia", "aba": "054001204"}, {
                        "name": "Florida East",
                        "aba": "063000047"
                    }, {"name": "Florida West", "aba": "063100277"}, {
                        "name": "Georgia",
                        "aba": "061000052"
                    }, {"name": "Hawaii", "aba": "051000017"}, {
                        "name": "Idaho",
                        "aba": "123103716"
                    }, {"name": "Illinois", "aba": "081904808"}, {
                        "name": "Indiana",
                        "aba": "071214579"
                    }, {"name": "Iowa", "aba": "073000176"}, {
                        "name": "Kansas",
                        "aba": "101100045"
                    }, {"name": "Kentucky", "aba": "051000017"}, {
                        "name": "Louisiana",
                        "aba": "051000017"
                    }, {"name": "Maine", "aba": "011200365"}, {
                        "name": "Maryland",
                        "aba": "052001633"
                    }, {"name": "Massachusetts", "aba": "011000138"}, {
                        "name": "Michigan",
                        "aba": "051000017"
                    }, {"name": "Minnesota", "aba": "071214579"}, {
                        "name": "Mississippi",
                        "aba": "051000017"
                    }, {"name": "Missouri East", "aba": "081000032"}, {
                        "name": "Missouri West",
                        "aba": "101000035"
                    }, {"name": "Montana", "aba": "051000017"}, {
                        "name": "Nebraska",
                        "aba": "051000017"
                    }, {"name": "Nevada", "aba": "122400724"}, {
                        "name": "New Hampshire",
                        "aba": "011400495"
                    }, {"name": "New Jersey", "aba": "021200339"}, {
                        "name": "New Mexico",
                        "aba": "107000327"
                    }, {"name": "New York", "aba": "021000322"}, {
                        "name": "North Carolina",
                        "aba": "053000196"
                    }, {"name": "North Dakota", "aba": "051000017"}, {
                        "name": "Ohio",
                        "aba": "051000017"
                    }, {"name": "Oklahoma", "aba": "103000017"}, {
                        "name": "Oregon",
                        "aba": "323070380"
                    }, {"name": "Pennsylvania", "aba": "031202084"}, {
                        "name": "Rhode Island",
                        "aba": "011500010"
                    }, {"name": "South Carolina", "aba": "053904483"}, {
                        "name": "South Dakota",
                        "aba": "051000017"
                    }, {"name": "Tennessee", "aba": "064000020"}, {
                        "name": "Texas, North",
                        "aba": "111000025"
                    }, {"name": "Texas, South", "aba": "113000023"}, {
                        "name": "Utah",
                        "aba": "051000017"
                    }, {"name": "Vermont", "aba": "051000017"}, {
                        "name": "Virginia",
                        "aba": "051000017"
                    }, {"name": "Washington", "aba": "125000024"}, {
                        "name": "West Virginia",
                        "aba": "051000017"
                    }, {"name": "Wisconsin", "aba": "051000017"}, {"name": "Wyoming", "aba": "051000017"}]
                },
                "bbt": {
                    "name": "Branch Bank",
                    "states": [{"name": "Alabama", "aba": "062203984"}, {
                        "name": "District of Columbia",
                        "aba": "054001547"
                    }, {"name": "Florida", "aba": "263191387"}, {
                        "name": "Georgia",
                        "aba": "061113415"
                    }, {"name": "Indiana", "aba": "083974289"}, {
                        "name": "Kentucky",
                        "aba": "083900680"
                    }, {"name": "Maryland", "aba": "055003308"}, {
                        "name": "North Carolina",
                        "aba": "053101121"
                    }, {"name": "South Carolina", "aba": "053201607"}, {
                        "name": "Tennessee",
                        "aba": "064208165"
                    }, {"name": "Texas", "aba": "111017694"}, {
                        "name": "Virginia",
                        "aba": "051404260"
                    }, {"name": "West Virginia", "aba": "051503394"}]
                },
                "bonneville": {"name": "Bonneville Bank", "states": [{"name": "All Locations", "aba": "124302529"}]},
                "chase": {
                    "name": "Chase Bank",
                    "states": [{"name": "Arizona", "aba": "122100024"}, {
                        "name": "California",
                        "aba": "322271627"
                    }, {"name": "Colorado", "aba": "102001017"}, {
                        "name": "Connecticut",
                        "aba": "021100361"
                    }, {"name": "Florida", "aba": "267084131"}, {
                        "name": "Georgia",
                        "aba": "061092387"
                    }, {"name": "Idaho", "aba": "123271978"}, {
                        "name": "Illinois",
                        "aba": "071000013"
                    }, {"name": "Indiana", "aba": "074000010"}, {
                        "name": "Kentucky",
                        "aba": "083000137"
                    }, {"name": "Louisiana", "aba": "065400137"}, {
                        "name": "Michigan",
                        "aba": "072000326"
                    }, {"name": "Nevada", "aba": "322271627"}, {
                        "name": "New Jersey",
                        "aba": "021202337"
                    }, {"name": "New York – Downstate", "aba": "021000021"}, {
                        "name": "New York – Upstate",
                        "aba": "022300173"
                    }, {"name": "Ohio", "aba": "044000037"}, {
                        "name": "Oklahoma",
                        "aba": "103000648"
                    }, {"name": "Oregon", "aba": "325070760"}, {"name": "Texas", "aba": "111000614"}, {
                        "name": "Utah",
                        "aba": "124001545"
                    }, {"name": "Washington", "aba": "325070760"}, {
                        "name": "West Virginia",
                        "aba": "051900366"
                    }, {"name": "Wisconsin", "aba": "075000019"}]
                },
                "fifththird": {
                    "name": "Fifth Third Bank",
                    "states": [{"name": "Florida - Central", "aba": "063109935"}, {
                        "name": "Florida - North",
                        "aba": "063113057"
                    }, {"name": "Florida - South", "aba": "067091719"}, {
                        "name": "Florida - Tampa",
                        "aba": "063103915"
                    }, {"name": "Georgia", "aba": "263190812"}, {
                        "name": "Illinois",
                        "aba": "071923909"
                    }, {"name": "Indiana - Central", "aba": "074908594"}, {
                        "name": "Indiana - Southern",
                        "aba": "086300041"
                    }, {"name": "Kentucky - Central", "aba": "042101190"}, {
                        "name": "Kentucky - Northern",
                        "aba": "042100230"
                    }, {"name": "Kentucky - Southwestern", "aba": "083002342"}, {
                        "name": "Michigan - Eastern",
                        "aba": "072405455"
                    }, {"name": "Michigan - Northern", "aba": "072401404"}, {
                        "name": "Michigan - Western",
                        "aba": "072400052"
                    }, {"name": "Missouri", "aba": "081019104"}, {
                        "name": "North Carolina",
                        "aba": "053100737"
                    }, {"name": "Ohio - Cincinnati", "aba": "042000314"}, {
                        "name": "Ohio - Columbus",
                        "aba": "044002161"
                    }, {"name": "Ohio - Northeastern", "aba": "041002711"}, {
                        "name": "Ohio - Northwestern",
                        "aba": "041200050"
                    }, {"name": "Ohio - Southern", "aba": "042207735"}, {
                        "name": "Ohio - Western",
                        "aba": "042202196"
                    }, {"name": "Pennsylvania", "aba": "043018868"}, {"name": "Tennessee", "aba": "064103833"}]
                },
                "firstcalifornia": {
                    "name": "First California Bank",
                    "states": [{"name": "All Locations", "aba": "122244184"}]
                },
                "fnbtexas": {
                    "name": "First National Bank Texas",
                    "states": [{"name": "Arizona", "aba": "122106455"}, {
                        "name": "New Mexico",
                        "aba": "122106455"
                    }, {"name": "Texas", "aba": "111906271"}]
                },
                "mt": {
                    "name": "M&T Bank",
                    "states": [{"name": "Delaware", "aba": "031302955"}, {
                        "name": "District of Columbia",
                        "aba": "052000113"
                    }, {"name": "Maryland", "aba": "052000113"}, {
                        "name": "New York",
                        "aba": "022000046"
                    }, {"name": "Pennsylvania", "aba": "031302955"}, {
                        "name": "Virginia",
                        "aba": "052000113"
                    }, {"name": "West Virginia", "aba": "052000113"}]
                },
                "meta": {
                    "name": "MetaBank",
                    "states": [{"name": "MetaBank", "aba": "073972181"}, {
                        "name": "MetaBank Memphis",
                        "aba": "084003997"
                    }, {"name": "Brookins Division - MetaBank", "aba": "291471024"}]
                },
                "navyfederal": {
                    "name": "Navy Federal Credit Union",
                    "states": [{"name": "All Locations", "aba": "256074974"}]
                },
                "pnc": {
                    "name": "PNC Bank",
                    "states": [{"name": "Delaware", "aba": "031100089"}, {
                        "name": "Florida",
                        "aba": "267084199"
                    }, {"name": "Greater Washington Area", "aba": "054000030"}, {
                        "name": "Illinois",
                        "aba": "071921891"
                    }, {"name": "Indiana", "aba": "071921891"}, {
                        "name": "Kentucky",
                        "aba": "083000108"
                    }, {"name": "Kentucky - Northern", "aba": "042100188"}, {
                        "name": "New Jersey",
                        "aba": "031207607"
                    }, {"name": "Michigan", "aba": "041000124"}, {
                        "name": "Missouri",
                        "aba": "071921891"
                    }, {"name": "Ohio", "aba": "042000398"}, {
                        "name": "Ohio Alternate",
                        "aba": "041000124"
                    }, {"name": "Ohio - Youngstown", "aba": "043000096"}, {
                        "name": "Pennsylvania - Central, North",
                        "aba": "043000096"
                    }, {
                        "name": "Pennsylvania - Central, South",
                        "aba": "031312738"
                    }, {"name": "Pennsylvania - Northeast", "aba": "031300012"}, {
                        "name": "Pennsylvania - Northwest",
                        "aba": "043300738"
                    }, {
                        "name": "Pennsylvania - Philadelphia",
                        "aba": "031000053"
                    }, {"name": "Pennsylvania - Pittsburgh", "aba": "043000096"}, {
                        "name": "Wisconsin",
                        "aba": "071921891"
                    }]
                },
                "regions": {
                    "name": "Regions Bank",
                    "states": [{"name": "Alabama", "aba": "062000019"}, {
                        "name": "Arkansas",
                        "aba": "082000109"
                    }, {"name": "Florida", "aba": "063104668"}, {
                        "name": "Georgia",
                        "aba": "061101375"
                    }, {"name": "Illinois", "aba": "071122661"}, {
                        "name": "Indiana",
                        "aba": "074014213"
                    }, {"name": "Iowa", "aba": "073900438"}, {
                        "name": "Kentucky",
                        "aba": "083901744"
                    }, {"name": "Louisiana", "aba": "065403626"}, {
                        "name": "Mississippi",
                        "aba": "065305436"
                    }, {"name": "Missouri", "aba": "081001387"}, {
                        "name": "North Carolina",
                        "aba": "053012029"
                    }, {"name": "South Carolina", "aba": "053201814"}, {
                        "name": "Tennessee",
                        "aba": "064000017"
                    }, {"name": "Texas", "aba": "111900785"}, {"name": "Virginia", "aba": "051009296"}]
                },
                "suntrust": {"name": "SunTrust Bank", "states": [{"name": "All Locations", "aba": "061000104"}]},
                "td": {
                    "name": "TD Bank",
                    "states": [{"name": "Connecticut", "aba": "011103093"}, {
                        "name": "Delaware",
                        "aba": "031201360"
                    }, {"name": "District of Columbia", "aba": "054001725"}, {
                        "name": "Florida",
                        "aba": "067014822"
                    }, {"name": "Maine", "aba": "211274450"}, {
                        "name": "Maryland",
                        "aba": "054001725"
                    }, {"name": "Massachusetts", "aba": "211370545"}, {
                        "name": "New Hampshire",
                        "aba": "011400071"
                    }, {"name": "New Jersey", "aba": "031201360"}, {
                        "name": "New York - Metro",
                        "aba": "026013673"
                    }, {"name": "New York - Upstate", "aba": "021302567"}, {
                        "name": "North Carolina",
                        "aba": "053902197"
                    }, {"name": "Pennsylvania", "aba": "036001808"}, {
                        "name": "Rhode Island",
                        "aba": "211370545"
                    }, {"name": "South Carolina", "aba": "053902197"}, {
                        "name": "Vermont",
                        "aba": "011600033"
                    }, {"name": "Virginia", "aba": "054001725"}]
                },
                "usaa": {
                    "name": "USAA Federal Savings Bank",
                    "states": [{"name": "All Locations", "aba": "314074269"}]
                },
                "usbank": {
                    "name": "US Bank",
                    "states": [{"name": "Arizona", "aba": "122105155"}, {
                        "name": "Arkansas",
                        "aba": "082000549"
                    }, {"name": "California - Northern", "aba": "121122676"}, {
                        "name": "California - Southern",
                        "aba": "122235821"
                    }, {"name": "Colorado - Aspen", "aba": "102101645"}, {
                        "name": "Colorado - All other areas",
                        "aba": "102000021"
                    }, {"name": "Idaho", "aba": "123103729"}, {
                        "name": "Illinois - Northern",
                        "aba": "071904779"
                    }, {"name": "Illinois - Southern", "aba": "081202759"}, {
                        "name": "Indiana",
                        "aba": "074900783"
                    }, {"name": "Iowa - Council Bluffs", "aba": "104000029"}, {
                        "name": "Iowa - All other areas",
                        "aba": "073000545"
                    }, {"name": "Kansas", "aba": "101000187"}, {
                        "name": "Kentucky - Northern",
                        "aba": "042100175"
                    }, {"name": "Kentucky - Western", "aba": "083900363"}, {
                        "name": "Minnesota - East Grand Forks",
                        "aba": "091215927"
                    }, {"name": "Minnesota - Moorhead", "aba": "091300023"}, {
                        "name": "Minnesota - All other areas",
                        "aba": "091000022"
                    }, {"name": "Missouri", "aba": "081000210"}, {
                        "name": "Montana",
                        "aba": "092900383"
                    }, {"name": "Nebraska", "aba": "104000029"}, {
                        "name": "Nevada",
                        "aba": "121201694"
                    }, {"name": "New Mexico", "aba": "107002312"}, {
                        "name": "North Dakota",
                        "aba": "091300023"
                    }, {"name": "Ohio - Cleveland", "aba": "041202582"}, {
                        "name": "Ohio - All other areas",
                        "aba": "042000013"
                    }, {"name": "Oregon", "aba": "123000220"}, {
                        "name": "South Dakota",
                        "aba": "091408501"
                    }, {"name": "Tennessee", "aba": "064000059"}, {
                        "name": "Utah",
                        "aba": "124302150"
                    }, {"name": "Washington", "aba": "125000105"}, {
                        "name": "Wisconsin",
                        "aba": "075000022"
                    }, {"name": "Wyoming", "aba": "307070115"}, {"name": "All other states", "aba": "091000022"}]
                },
                "wellsfargo": {
                    "name": "Wells Fargo",
                    "states": [{"name": "Alabama", "aba": "062000080"}, {
                        "name": "Alaska",
                        "aba": "125200057"
                    }, {"name": "Arizona", "aba": "122105278"}, {
                        "name": "Arkansas",
                        "aba": "111900659"
                    }, {"name": "California", "aba": "121042882"}, {
                        "name": "Colorado",
                        "aba": "102000076"
                    }, {"name": "Connecticut", "aba": "021101108"}, {
                        "name": "Delaware",
                        "aba": "031100869"
                    }, {"name": "District of Columbia", "aba": "054001220"}, {
                        "name": "Florida",
                        "aba": "063107513"
                    }, {"name": "Georgia", "aba": "061000227"}, {
                        "name": "Hawaii",
                        "aba": "121042882"
                    }, {"name": "Idaho", "aba": "124103799"}, {
                        "name": "Illinois",
                        "aba": "071101307"
                    }, {"name": "Indiana", "aba": "074900275"}, {"name": "Iowa", "aba": "073000228"}, {
                        "name": "Kansas",
                        "aba": "101089292"
                    }, {"name": "Kentucky", "aba": "121042882"}, {
                        "name": "Louisiana",
                        "aba": "121042882"
                    }, {"name": "Maine", "aba": "121042882"}, {
                        "name": "Maryland",
                        "aba": "055003201"
                    }, {"name": "Massachusetts", "aba": "121042882"}, {
                        "name": "Michigan",
                        "aba": "091101455"
                    }, {"name": "Minnesota", "aba": "091000019"}, {
                        "name": "Mississippi",
                        "aba": "062203751"
                    }, {"name": "Missouri", "aba": "121042882"}, {
                        "name": "Montana",
                        "aba": "092905278"
                    }, {"name": "Nebraska", "aba": "104000058"}, {
                        "name": "Nevada",
                        "aba": "321270742"
                    }, {"name": "New Hampshire", "aba": "121042882"}, {
                        "name": "New Jersey",
                        "aba": "021200025"
                    }, {"name": "New Mexico", "aba": "107002192"}, {
                        "name": "New York",
                        "aba": "026012881"
                    }, {"name": "North Carolina", "aba": "053000219"}, {
                        "name": "North Dakota",
                        "aba": "091300010"
                    }, {"name": "Ohio", "aba": "041215537"}, {
                        "name": "Oklahoma",
                        "aba": "121042882"
                    }, {"name": "Oregon", "aba": "123006800"}, {
                        "name": "Pennsylvania",
                        "aba": "031000503"
                    }, {"name": "Rhode Island", "aba": "121042882"}, {
                        "name": "South Carolina",
                        "aba": "053207766"
                    }, {"name": "South Dakota", "aba": "091400046"}, {
                        "name": "Tennessee",
                        "aba": "064003768"
                    }, {"name": "Texas", "aba": "111900659"}, {
                        "name": "Texas - El Paso",
                        "aba": "112000066"
                    }, {"name": "Utah", "aba": "124002971"}, {
                        "name": "Vermont",
                        "aba": "121042882"
                    }, {"name": "Virginia", "aba": "051400549"}, {
                        "name": "Washington",
                        "aba": "125008547"
                    }, {"name": "West Virginia", "aba": "121042882"}, {
                        "name": "Wisconsin",
                        "aba": "075911988"
                    }, {"name": "Wyoming", "aba": "102301092"}]
                }
            };

            var stateClosed = ["AR", "CT", "MN", "MT", "NH", "NY", "SD", "VT", "WV"];

            var hollidays = [
                "2021-01-01", // New Year's Day observed
                "2021-01-18", // Martin Luther King Day
                "2021-02-15", // Washington's Birthday
                "2021-05-31", // Memorial Day
                "2021-07-04", // Independence Day
                "2021-09-06", // Labor Day
                "2021-10-11", // Columbus Day
                "2021-11-25", // Thanksgiving Day
                "2021-12-25", // Christmas Day
                "2022-01-01", // New Year's Day observed
                "2022-01-17", // Martin Luther King Day
                "2022-02-21", // Washington's Birthday
                "2022-05-30", // Memorial Day
                "2022-07-04", // Independence Day
                "2022-09-05", // Labor Day
                "2022-10-10", // Columbus Day
                "2022-11-24", // Thanksgiving Day
                "2022-12-25", // Christmas Day
                "2023-01-01", // New Year's Day observed
                "2023-01-16", // Martin Luther King Day
                "2023-02-20", // Washington's Birthday
                "2023-05-29", // Memorial Day
                "2023-07-04", // Independence Day
                "2023-09-04", // Labor Day
                "2023-10-09", // Columbus Day
                "2023-11-23", // Thanksgiving Day
                "2023-12-25", // Christmas Day
                "2024-01-01", // New Year's Day observed
                "2024-01-15", // Martin Luther King Day
                "2024-02-19", // Washington's Birthday
                "2024-05-27", // Memorial Day
                "2024-07-04", // Independence Day
                "2024-09-02", // Labor Day
                "2024-10-14", // Columbus Day
                "2024-11-28", // Thanksgiving Day
                "2024-12-25", // Christmas Day
                "2025-01-01", // New Year's Day observed
                "2025-01-20", // Martin Luther King Day
                "2025-02-17", // Washington's Birthday
                "2025-05-26", // Memorial Day
                "2025-07-04", // Independence Day
                "2025-09-01", // Labor Day
                "2025-10-13", // Columbus Day
                "2025-11-27", // Thanksgiving Day
                "2025-12-25", // Christmas Day
                "2026-01-01", // New Year's Day observed
                "2026-01-19", // Martin Luther King Day
                "2026-02-16", // Washington's Birthday
                "2026-05-25", // Memorial Day
                "2026-07-04", // Independence Day
                "2026-09-07", // Labor Day
                "2026-10-12", // Columbus Day
                "2026-11-26", // Thanksgiving Day
                "2026-12-25", // Christmas Day
                "2027-01-01", // New Year's Day observed
                "2027-01-18", // Martin Luther King Day
                "2027-02-15", // Washington's Birthday
                "2027-05-31", // Memorial Day
                "2027-07-04", // Independence Day
                "2027-09-06", // Labor Day
                "2027-10-11", // Columbus Day
                "2027-11-25", // Thanksgiving Day
                "2027-12-25", // Christmas Day
                "2028-01-01", // New Year's Day observed
                "2028-01-17", // Martin Luther King Day
                "2028-02-21", // Washington's Birthday
                "2028-05-29", // Memorial Day
                "2028-07-04", // Independence Day
                "2028-09-04", // Labor Day
                "2028-10-09", // Columbus Day
                "2028-11-23", // Thanksgiving Day
                "2028-12-25", // Christmas Day
                "2029-01-01", // New Year's Day observed
                "2029-01-15", // Martin Luther King Day
                "2029-02-19", // Washington's Birthday
                "2029-05-28", // Memorial Day
                "2029-07-04", // Independence Day
                "2029-09-03", // Labor Day
                "2029-10-08", // Columbus Day
                "2029-11-22", // Thanksgiving Day
                "2029-12-25"  // Christmas Day
            ];

            // Validate fields
            form.validate({
                rules: {
                    loanAmount: "required",
                    address: {
                        normalizer: function (value) {
                            // Get value
                            var string_result = /\d/.test(value);
                            if (string_result) {
                                if (value.length >= 2) {
                                    return value;
                                } else {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        }
                    },
                    "first-name": {
                        normalizer: function (value) {
                            if (!value.length) {
                                return false;
                            } else if (!/[a-zA-Z ]/g.test(value)) {
                                return false;
                            }
                            else {
                                return value;
                            }
                        }
                    },

                    "last-name": {
                        normalizer: function (value) {
                            if (!value.length) {
                                return false;
                            } else if (!/[a-zA-Z ]/g.test(value)) {
                                return false;
                            }
                            else {
                                return value;
                            }
                        }
                    },
                    "e-mail": {
                        email: true
                    },
                    "dob[month]": "required",
                    "dob[day]": "required",
                    "dob[year]": "required",
                    workCompanyName: {
                        required: true,
                        min: "2"
                    },
                    driversLicenseNumber: {
                        normalizer: function (value) {
                            var dln_pattern = new RegExp("^[a-zA-Z0-9]+$");
                            if (dln_pattern.test(value)) {
                                return value;
                            } else {
                                return false;
                            }
                        }
                    },
                    incomeType: "required",
                    activeMilitary: "required",
                    bankAba: {
                        normalizer: function (value) {
                            if ($.isNumeric(value)) {
                                return value;
                            } else {
                                return false;
                            }
                        }
                    },
                    bankAccountNumber: {
                        normalizer: function (value) {
                            if ($.isNumeric(value)) {
                                return value;
                            } else {
                                return false;
                            }
                        }
                    },
                    bankDirectDeposit: "required",
                    bankAccountType: "required"
                },
                messages: {
                    loanAmount: "Select loan amount.",
                    address: "Field may not be less than 2 letters and 1 number.",
                    email: {
                        required: "We need your email address to contact you",
                        email: "Your email address must be in the format of name@domain.com"
                    },
                    workCompanyName: {
                        required: "Field may not be less than 2 letters.",
                    },
                    driversLicenseNumber: "Entry must consist of alpha-numeric characters only. Symbols will not be accepted.",
                    ssn: "Must be 9 digits and only consist of numeric values.",
                    homePhone: "Must only contain numeric values. Number must be 10 digits (including area code).",
                    workPhone: "Must only contain numeric values. Number must be 10 digits (including area code).",
                    incomeType: "This field is required.",
                    activeMilitary: "This field is required.",
                    bankDirectDeposit: "This field is required.",
                    bankAccountType: "This field is required.",
                    bankAba: {
                        required: "A valid ABA/bank routing number must be 9 digits long.",
                        normalizer: "Invalid Bank ABA/Routing Number"
                    },
                    bankAccountNumber: "May only include numeric values.",
                },
                errorClass: "error",
                pendingClass: "pending",
                validClass: "valid",
                errorElement: "label",
                // success: function(label) {},
                errorElement: "span",
                errorPlacement: function (error, element) {
                    if (element.is(":radio")) {
                        error.appendTo(element.parents('.col-md-6'));
                    } else { // This is the default behavior
                        error.insertAfter(element);
                    }
                },
                highlight: function (element, errorClass, validClass) {
                    $(element).addClass(errorClass).removeClass(validClass);
                    $(element.form).find("label[for=" + element.id + "]").addClass(errorClass);
                    $(element.form).find("label[for=" + element.id + "]").parents(".form-item").addClass(errorClass + '-field');
                },
                unhighlight: function (element, errorClass, validClass) {
                    $(element).removeClass(errorClass).addClass(validClass);
                    $(element.form).find("label[for=" + element.id + "]").removeClass(errorClass);
                    $(element.form).find("label[for=" + element.id + "]").parents(".form-item").removeClass(errorClass + '-field');
                },
                // submitHandler: function(form) {
                // 	// $(form).ajaxSubmit();
                // }
            });
            // Step form
            $('#web-form-application-online-form .form_steps', context).steps({
                /* Appearance */
                headerTag: 'h3',
                bodyTag: 'section',
                transitionEffect: 'fade',
                /* Templates */
                titleTemplate: '<span class="number">#index#</span> #title#',
                /* Events */
                onStepChanging: function (event, currentIndex, newIndex) {
                    // Allways allow previous action even if the current form is not valid!
                    if (currentIndex > newIndex) {
                        return true;
                    }
                    form.validate().settings.ignore = ':disabled,:hidden';
                    return form.valid();
                },
                onFinishing: function (event, currentIndex) {
                    form.validate().settings.ignore = ":disabled";
                    return form.valid();
                },
                onFinished: function (event, currentIndex) {
                    form.validate().settings.ignore = ':disabled';
                    // var finishing_message = "Application is completed successfully!";
                    // $.fancybox.open('<div class="finishing-message-fancybox"><p>'+finishing_message+'</p></div>');

                    // Delete the data because This data is not part of the form.
                    if ($('body.page-apply-online:not(.page-apply-online-wizard)')) {
                        $('#edit-bankstate').children().remove();
                        $('#edit-bankstate').append($("<option/>").attr('value', 'other').text('Other'));
                    }
                    // Display wait message
                    $('#PostToServerAnimation').show();
                    $('html, body').animate({
                        scrollTop: ($('#PostToServerAnimation').offset())
                    }, 500);
                    $('#form_content .form_steps').hide();
                    // Click to submit btn form.
                    $('#form_content #edit-submit').click();
                    window.onbeforeunload = null;
                    return form.valid();
                },
                /* Labels */
                labels: {
                    cancel: "Cancel",
                    current: "current step:",
                    pagination: "Pagination",
                    finish: "Submit",
                    next: "Next step",
                    previous: "Previous step",
                    loading: "Loading ..."
                }
            });
            // Display form
            $(document).ready(function () {
                $('form#form_content .form_steps').css('opacity', 1);
            });

            // Closing message
            window.onbeforeunload = function () {
                return "Do you really want to close?";
            }

            // Progress bar,load the data.
            // if ($('body').hasClass('logged-in')) {
            // 	$('#PostToServerAnimation').css('display', 'block');
            // }
            // var corrent;
            // var progress = (100 * parseFloat($('#web_form_progressbar .progress-bar').css('width')) / parseFloat($('#web_form_progressbar .progress-bar').parent().css('width')));
            // corrent = progress;
            // function find_lenders() {
            //   var max = 15; // one minute
            //   var add = 0.67 / max;
            //   if (corrent < 100) {
            //       corrent += add;
            //       $("#web_form_progressbar .progress-bar").css("width", corrent + "%");
            //       $("#web_form_progressbar .progress-bar").text(Math.round(corrent) + "%");
            //       setTimeout(find_lenders, 50); // update every second
            //   }
            // }

            /* Check ABA bank */
            function bankToABAfull() {
                if ($('#edit-bankname').val().length) {
                    $('#edit-bankstate').attr('disabled', true);
                }
                var ABAInfo = typeof (ccABAInfo) !== "undefined" ? ccABAInfo : {};
                $('#edit-bankname').change(function () {
                    if ($('#edit-bankname').val() != "other") {
                        $('#edit-bankaba').val('');
                        $('#edit-bankstate').children().remove();
                        $('#edit-bankstate').append($("<option/>").attr({
                            value: "",
                            disabled: true,
                            selected: true
                        }).text('Bank State'));
                        $('#edit-bankstate').attr('disabled', false);
                        var states = ABAInfo[$('#edit-bankname').val()].states;
                        if (states.length > 1) {
                            $('#edit-bankstate').append($("<option/>").attr('value', 'other').text('Other'));
                        }
                        for (var i in states) {
                            $('#edit-bankstate').append($("<option/>").attr('value', states[i].aba).text(states[i].name));
                        }
                    } else {
                        $('#edit-bankaba').val('');
                        $('#edit-bankstate').attr('disabled', true);
                    }
                });
                $('#edit-bankstate', context).change(function () {
                    var val = $(this).val();
                    if (val.length > 0 && val != "other") {
                        $('#edit-bankaba').val(val).focus();
                    } else {
                        $('#edit-bankaba').val('');
                    }
                });
                if ($('#edit-bankaba').length) {
                    $('edit-bankstate').attr('aria-invalid', 'false');
                }
            }

            bankToABAfull();

            // If wizard form.
            if ($('body').hasClass('page-apply-online-wizard')) {
                if (!$('#edit-bankname').length) {
                    $('select[name="bankState"]').attr('disabled', true);
                }
                $('select[name="bankState"]', context).change(function () {
                    var val = $(this).val();
                    if (val.length > 0 && val != "other") {
                        $('#edit-bankaba').val(val).focus();
                    } else {
                        $('#edit-bankaba').val('');
                    }
                });
            }

            //Add masks to fields
            $("#edit-zip").not('.mask-applied').mask("99999").addClass('mask-applied').attr({
                "data-mask": "_____",
                'type': 'tel'
            });
            $('#edit-ssn').not('.mask-applied').mask("999-99-9999").addClass('mask-applied').attr({
                "data-mask": "___-__-____",
                'type': 'tel'
            });
            $('#edit-homephone').not('.mask-applied').mask("999-999-9999").addClass('mask-applied').attr({
                "data-mask": "___-___-____",
                'type': 'tel'
            });
            $('#edit-workphone').not('.mask-applied').mask("999-999-9999").addClass('mask-applied').attr({
                "data-mask": "___-___-____",
                'type': 'tel'
            });
            $("#edit-incomenextdate1").not('.mask-applied').mask("99/99/9999").addClass('mask-applied').attr("data-mask", "MM/DD/YYYY");
            $("#edit-incomenextdate2").not('.mask-applied').mask("99/99/9999").addClass('mask-applied').attr("data-mask", "MM/DD/YYYY");
            $("#edit-bankaba").not('.mask-applied').mask("999999999").addClass('mask-applied').attr({
                "data-mask": "_________",
                'type': 'tel'
            });

            $('.mask-applied').on('click focus', function () {
                if ($(this).val() == '' || $(this).val() == $(this).attr('data-mask')) {
                    $(this).setCursorPosition(0);
                }
            });

            // Check ZIP code field
            $("#edit-zip").on('change', function (e) {
                e.stopPropagation();
                var zip = $("#edit-zip").val();
                if (zip !== 'undefined' && zip.length > 2) {
                    checkZIP(zip);
                }
            });

            // Find short state by zip code.
            function checkZIP(zip) {
                $.ajax({
                    dataType: "json",
                    type: "POST",
                    url: "https://compacom.com/data/getblockstateus",
                    timeout: 3000,
                    data: {zip: zip},
                    success: function (data) {
                        // If find state.
                        if ($.inArray(data['state'], stateClosed) != -1) {
                            zipExtend(zip);
                        }
                    }
                });
            }

            function zipExtend(zip) {
                var sorry_message = "We\'re sorry, we currently do not offer any services in your state. Please check back with us in the future. If you have any questions, please don’t hesitate to contact our customer service team. Thank you!";
                $.fancybox.open('<div class="error-message-fancybox"><p>' + sorry_message + '</p></div>');
                $("#edit-zip").val('');
            }

            // Move the cursor to the beginning of the field.
            $.fn.setCursorPosition = function (pos) {
                if ($(this).get(0).setSelectionRange) {
                    $(this).get(0).setSelectionRange(pos, pos);
                } else if ($(this).get(0).createTextRange) {
                    var range = $(this).get(0).createTextRange();
                    range.collapse(true);
                    range.moveEnd('character', pos);
                    range.moveStart('character', pos);
                    range.select();
                }
            };

            // Remove class if field is empty
            $('#form_content .form-control').on('change', function () {
                if ($(this).hasClass('valid')) {
                    if (!$(this).val().length) {
                        $(this).removeClass('valid');
                    }
                }
            });

            // View Check
            $('#view_check').on('click', function (e) {
                e.preventDefault();
                $(this).toggleClass('show');
            });

            // Need help ABA
            $('#aba-help .aba-helper-description').on('click', function () {
                $(this).toggleClass('active');
                $('#aba-help-fields').toggleClass('active');
                if ($(window).width() < 960) {
                    $('html, body').animate({
                        scrollTop: $('#aba-help-fields').offset().top - 20
                    }, 1000);
                }
            });
            $('#bankstate-container .form-select').on('change', function () {
                var bankName = $('.form-item-bankName .form-select').val();
                var bankState = $(this).val();
                if ((bankName != '') && (bankState != '')) {
                    $('#aba-help-fields').toggleClass('active');
                    $('#aba-help .aba-helper-description').toggleClass('active');
                    if ($(window).width() < 960) {
                        $('html, body').animate({
                            scrollTop: $('#bankAba').offset().top - 190
                        }, 1000);
                    }
                }
            });

            /* Next Paydates */
            $('#edit-incomepaymentfrequency').on('change', function () {
                $('#edit-incomenextdate1').val('');
                $('#edit-incomenextdate2').val('');
            });

            $('#edit-incomenextdate1').datepicker({
                showAnim: "",
                numberOfMonths: (screen.width > 740 ? 2 : 1),
                showButtonPanel: true,
                minDate: '+1d',
                maxDate: '+61d',
                showAnim: '',
                beforeShow: function () {
                    $(this).blur();
                },
                beforeShowDay: noWeekendsOrHolidays,
                hideIfNoPrevNext: true,
                onSelect: function (dateText, inst) {
                    addSecondDate($(this).val());
                }
            });
            $('#edit-incomenextdate2').datepicker({
                showAnim: "",
                numberOfMonths: (screen.width > 740 ? 2 : 1),
                showButtonPanel: true,
                minDate: '+1d',
                maxDate: '+61d',
                showAnim: '',
                beforeShow: function () {
                    $(this).blur();
                },
                beforeShowDay: noWeekendsOrHolidays,
                hideIfNoPrevNext: true,
                onSelect: function (dateText, inst) {
                }
            });

            function noWeekendsOrHolidays(date) {
                var string = $.datepicker.formatDate('yy-mm-dd', date);
                var t = date.getDay();
                if (hollidays.indexOf(string) == -1 && t > 0 && t < 6) {
                    return [-1];
                } else {
                    return [0];
                }
            }

            function checkdate(date, direction) {
                var string = $.datepicker.formatDate('yy-mm-dd', date);
                var t = date.getDay();
                if (t == 0) {
                    if (direction) {
                        date.setDate(date.getDate() + 1);
                    } else {
                        date.setDate(date.getDate() - 2);
                    }
                } else if (t == 6) {
                    if (direction) {
                        date.setDate(date.getDate() + 2);
                    } else {
                        date.setDate(date.getDate() - 1);
                    }
                } else if (hollidays.indexOf(string) != -1) {
                    if (direction) {
                        date.setDate(date.getDate() + 1);
                    } else {
                        date.setDate(date.getDate() - 1);
                    }
                }
                return date;
            }

            function addSecondDate(value) {
                var pFrequency = $('#edit-incomepaymentfrequency').val() ? $('#edit-incomepaymentfrequency').val() : '';
                if ((pFrequency == 'MONTHLY' || pFrequency == 'BIWEEKLY' || pFrequency == 'WEEKLY' || pFrequency == 'TWICEMONTHLY') && value) {
                    var day = ~~value.substr(3, 2);
                    var months = ~~value.substr(0, 2);
                    var year = ~~value.substr(6, 4);
                    months = months - 1;
                    var date = new Date(year, months, day);
                    switch (pFrequency) {
                        case 'MONTHLY':
                            var dayCount = 32 - new Date(year, months, 32).getDate();
                            var nexdayCount = 32 - new Date(year, months + 1, 32).getDate();
                            if (nexdayCount < dayCount) {
                                dayCount = nexdayCount;
                            }
                            date.setDate(date.getDate() + dayCount);
                            date = checkdate(date, 1);
                            break;
                        case 'WEEKLY':
                            date.setDate(date.getDate() + 7);
                            date = checkdate(date, 0);
                            break;
                        case 'BIWEEKLY':
                            date.setDate(date.getDate() + 14);
                            date = checkdate(date, 1);
                            break;
                        case 'TWICEMONTHLY':
                            var dayCount = 32 - new Date(year, months, 32).getDate();
                            if (day != 1 && day != 5 && day != 15 && day != 20 && day != 30 && day != dayCount) {
                                var checkingdate = new Date(year, months, day);
                                var strmonth = months + 1;
                                var strday = day;
                                if (strmonth < 10) {
                                    strmonth = '0' + strmonth;
                                }
                                if (strday < 10) {
                                    strday = '0' + strday;
                                }
                                var datestring = year + '-' + strmonth + '-' + strday;
                                var true_frequency = false;
                                checkingdate.setDate(checkingdate.getDate() + 1);
                                _validdate = [1, 5, 15, 20, 30, dayCount];
                                if (checkingdate.getDay() == 0 || checkingdate.getDay() == 6 || $.inArray(datestring, hollidays) >= 0) {
                                    if ($.inArray(checkingdate.getDate(), _validdate) >= 0) {
                                        true_frequency = true;
                                    } else {
                                        checkingdate.setDate(checkingdate.getDate() + 1);
                                        if (checkingdate.getDay() == 0 || checkingdate.getDay() == 6 || $.inArray(datestring, hollidays) >= 0) {
                                            if ($.inArray(checkingdate.getDate(), _validdate) >= 0) {
                                                true_frequency = true;
                                            } else {
                                                checkingdate.setDate(checkingdate.getDate() + 1);
                                                if (checkingdate.getDay() == 0 || checkingdate.getDay() == 6 || $.inArray(datestring, hollidays) >= 0) {
                                                    if ($.inArray(checkingdate.getDate(), _validdate) >= 0) {
                                                        true_frequency = true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                if (true_frequency) {
                                    if (day <= 2) {
                                        date = new Date(year, months, 15);
                                    } else if (day <= 8 && day >= 3) {
                                        date = new Date(year, months, 20);
                                    } else if (day <= 17 && day >= 12) {
                                        if (dayCount < 30) {
                                            date = new Date(year, months, dayCount);
                                        } else {
                                            date = new Date(year, months, 30);
                                        }
                                    } else if (day <= 23 && day >= 18) {
                                        date = new Date(year, months + 1, 5);
                                    } else if (day >= 27) {
                                        date = new Date(year, months + 1, 15);
                                    } else {
                                        date.setDate(date.getDate() + 14);
                                    }
                                    setdate = true;
                                }
                            } else {
                                if (day == 1 || day == 5) {
                                    if (day == 1) {
                                        date = new Date(year, months, 15);
                                    } else if (day == 5) {
                                        date = new Date(year, months, 20);
                                    }
                                } else if (day == 15) {
                                    if (dayCount < 30) {
                                        date = new Date(year, months, dayCount);
                                    } else {
                                        date = new Date(year, months, 30);
                                    }
                                } else if (day == 20) {
                                    date = new Date(year, months + 1, 5);
                                } else if (day == 30 || day == dayCount) {
                                    date = new Date(year, months + 1, 15);
                                }
                            }
                            date = checkdate(date, 0);
                            break;
                    }
                    months = date.getMonth();
                    months = months + 1;
                    if (months < 10) {
                        months = '0' + months;
                    }
                    day = date.getDate();
                    if (day < 10) {
                        day = '0' + day;
                    }
                    $('#edit-incomenextdate2').val(months + '/' + day + '/' + date.getFullYear());
                }
            }

        }
    };
})(jQuery);