import React, {useState} from 'react';
import { Formik, Form, Field } from 'formik';
import {faLock} from "@fortawesome/free-solid-svg-icons/faLock";
import Row from "react-bootstrap/Row";
import Col from "react-bootstrap/Col";
import InputMask from 'react-input-mask';
import Check from "react-bootstrap/FormCheck"
import DatePicker from "react-datepicker";
import {FontAwesomeIcon} from "@fortawesome/react-fontawesome";
import {faMinusCircle} from "@fortawesome/free-solid-svg-icons/faMinusCircle";
import {faPlusCircle} from "@fortawesome/free-solid-svg-icons/faPlusCircle";
import CheckImage from "../public/check.jpg";
import settings from "../utils/settings";
import Spinner from "react-bootstrap/Spinner";
import replaceTokens from "../utils/replaceTokens";
import Modal from "react-bootstrap/Modal";
import fetch from "isomorphic-unfetch";
import Collapse from 'react-bootstrap/Collapse';
import Banner1 from '../public/logo-loansolo-com.png';
import Banner2 from '../public/indylend1.jpg';
import auth from "../utils/auth";

var ccABAInfo = {"bancorp":{"name":"Bancorp","states":[{"name":"All Locations","aba":"031101114"}]},"bankofamerica":{"name":"Bank of America","states":[{"name":"Alabama","aba":"051000017"},{"name":"Alaska","aba":"051000017"},{"name":"Arizona","aba":"122101706"},{"name":"Arkansas","aba":"082000073"},{"name":"California","aba":"121000358"},{"name":"Colorado","aba":"123103716"},{"name":"Connecticut","aba":"011900571"},{"name":"Delaware","aba":"031202084"},{"name":"District of Columbia","aba":"054001204"},{"name":"Florida East","aba":"063000047"},{"name":"Florida West","aba":"063100277"},{"name":"Georgia","aba":"061000052"},{"name":"Hawaii","aba":"051000017"},{"name":"Idaho","aba":"123103716"},{"name":"Illinois","aba":"081904808"},{"name":"Indiana","aba":"071214579"},{"name":"Iowa","aba":"073000176"},{"name":"Kansas","aba":"101100045"},{"name":"Kentucky","aba":"051000017"},{"name":"Louisiana","aba":"051000017"},{"name":"Maine","aba":"011200365"},{"name":"Maryland","aba":"052001633"},{"name":"Massachusetts","aba":"011000138"},{"name":"Michigan","aba":"051000017"},{"name":"Minnesota","aba":"071214579"},{"name":"Mississippi","aba":"051000017"},{"name":"Missouri East","aba":"081000032"},{"name":"Missouri West","aba":"101000035"},{"name":"Montana","aba":"051000017"},{"name":"Nebraska","aba":"051000017"},{"name":"Nevada","aba":"122400724"},{"name":"New Hampshire","aba":"011400495"},{"name":"New Jersey","aba":"021200339"},{"name":"New Mexico","aba":"107000327"},{"name":"New York","aba":"021000322"},{"name":"North Carolina","aba":"053000196"},{"name":"North Dakota","aba":"051000017"},{"name":"Ohio","aba":"051000017"},{"name":"Oklahoma","aba":"103000017"},{"name":"Oregon","aba":"323070380"},{"name":"Pennsylvania","aba":"031202084"},{"name":"Rhode Island","aba":"011500010"},{"name":"South Carolina","aba":"053904483"},{"name":"South Dakota","aba":"051000017"},{"name":"Tennessee","aba":"064000020"},{"name":"Texas, North","aba":"111000025"},{"name":"Texas, South","aba":"113000023"},{"name":"Utah","aba":"051000017"},{"name":"Vermont","aba":"051000017"},{"name":"Virginia","aba":"051000017"},{"name":"Washington","aba":"125000024"},{"name":"West Virginia","aba":"051000017"},{"name":"Wisconsin","aba":"051000017"},{"name":"Wyoming","aba":"051000017"}]},"bbt":{"name":"Branch Bank","states":[{"name":"Alabama","aba":"062203984"},{"name":"District of Columbia","aba":"054001547"},{"name":"Florida","aba":"263191387"},{"name":"Georgia","aba":"061113415"},{"name":"Indiana","aba":"083974289"},{"name":"Kentucky","aba":"083900680"},{"name":"Maryland","aba":"055003308"},{"name":"North Carolina","aba":"053101121"},{"name":"South Carolina","aba":"053201607"},{"name":"Tennessee","aba":"064208165"},{"name":"Texas","aba":"111017694"},{"name":"Virginia","aba":"051404260"},{"name":"West Virginia","aba":"051503394"}]},"bonneville":{"name":"Bonneville Bank","states":[{"name":"All Locations","aba":"124302529"}]},"chase":{"name":"Chase Bank","states":[{"name":"Arizona","aba":"122100024"},{"name":"California","aba":"322271627"},{"name":"Colorado","aba":"102001017"},{"name":"Connecticut","aba":"021100361"},{"name":"Florida","aba":"267084131"},{"name":"Georgia","aba":"061092387"},{"name":"Idaho","aba":"123271978"},{"name":"Illinois","aba":"071000013"},{"name":"Indiana","aba":"074000010"},{"name":"Kentucky","aba":"083000137"},{"name":"Louisiana","aba":"065400137"},{"name":"Michigan","aba":"072000326"},{"name":"Nevada","aba":"322271627"},{"name":"New Jersey","aba":"021202337"},{"name":"New York – Downstate","aba":"021000021"},{"name":"New York – Upstate","aba":"022300173"},{"name":"Ohio","aba":"044000037"},{"name":"Oklahoma","aba":"103000648"},{"name":"Oregon","aba":"325070760"},{"name":"Texas","aba":"111000614"},{"name":"Utah","aba":"124001545"},{"name":"Washington","aba":"325070760"},{"name":"West Virginia","aba":"051900366"},{"name":"Wisconsin","aba":"075000019"}]},"fifththird":{"name":"Fifth Third Bank","states":[{"name":"Florida - Central","aba":"063109935"},{"name":"Florida - North","aba":"063113057"},{"name":"Florida - South","aba":"067091719"},{"name":"Florida - Tampa","aba":"063103915"},{"name":"Georgia","aba":"263190812"},{"name":"Illinois","aba":"071923909"},{"name":"Indiana - Central","aba":"074908594"},{"name":"Indiana - Southern","aba":"086300041"},{"name":"Kentucky - Central","aba":"042101190"},{"name":"Kentucky - Northern","aba":"042100230"},{"name":"Kentucky - Southwestern","aba":"083002342"},{"name":"Michigan - Eastern","aba":"072405455"},{"name":"Michigan - Northern","aba":"072401404"},{"name":"Michigan - Western","aba":"072400052"},{"name":"Missouri","aba":"081019104"},{"name":"North Carolina","aba":"053100737"},{"name":"Ohio - Cincinnati","aba":"042000314"},{"name":"Ohio - Columbus","aba":"044002161"},{"name":"Ohio - Northeastern","aba":"041002711"},{"name":"Ohio - Northwestern","aba":"041200050"},{"name":"Ohio - Southern","aba":"042207735"},{"name":"Ohio - Western","aba":"042202196"},{"name":"Pennsylvania","aba":"043018868"},{"name":"Tennessee","aba":"064103833"}]},"firstcalifornia":{"name":"First California Bank","states":[{"name":"All Locations","aba":"122244184"}]},"fnbtexas":{"name":"First National Bank Texas","states":[{"name":"Arizona","aba":"122106455"},{"name":"New Mexico","aba":"122106455"},{"name":"Texas","aba":"111906271"}]},"mt":{"name":"M&T Bank","states":[{"name":"Delaware","aba":"031302955"},{"name":"District of Columbia","aba":"052000113"},{"name":"Maryland","aba":"052000113"},{"name":"New York","aba":"022000046"},{"name":"Pennsylvania","aba":"031302955"},{"name":"Virginia","aba":"052000113"},{"name":"West Virginia","aba":"052000113"}]},"meta":{"name":"MetaBank","states":[{"name":"MetaBank","aba":"073972181"},{"name":"MetaBank Memphis","aba":"084003997"},{"name":"Brookins Division - MetaBank","aba":"291471024"}]},"navyfederal":{"name":"Navy Federal Credit Union","states":[{"name":"All Locations","aba":"256074974"}]},"pnc":{"name":"PNC Bank","states":[{"name":"Delaware","aba":"031100089"},{"name":"Florida","aba":"267084199"},{"name":"Greater Washington Area","aba":"054000030"},{"name":"Illinois","aba":"071921891"},{"name":"Indiana","aba":"071921891"},{"name":"Kentucky","aba":"083000108"},{"name":"Kentucky - Northern","aba":"042100188"},{"name":"New Jersey","aba":"031207607"},{"name":"Michigan","aba":"041000124"},{"name":"Missouri","aba":"071921891"},{"name":"Ohio","aba":"042000398"},{"name":"Ohio Alternate","aba":"041000124"},{"name":"Ohio - Youngstown","aba":"043000096"},{"name":"Pennsylvania - Central, North","aba":"043000096"},{"name":"Pennsylvania - Central, South","aba":"031312738"},{"name":"Pennsylvania - Northeast","aba":"031300012"},{"name":"Pennsylvania - Northwest","aba":"043300738"},{"name":"Pennsylvania - Philadelphia","aba":"031000053"},{"name":"Pennsylvania - Pittsburgh","aba":"043000096"},{"name":"Wisconsin","aba":"071921891"}]},"regions":{"name":"Regions Bank","states":[{"name":"Alabama","aba":"062000019"},{"name":"Arkansas","aba":"082000109"},{"name":"Florida","aba":"063104668"},{"name":"Georgia","aba":"061101375"},{"name":"Illinois","aba":"071122661"},{"name":"Indiana","aba":"074014213"},{"name":"Iowa","aba":"073900438"},{"name":"Kentucky","aba":"083901744"},{"name":"Louisiana","aba":"065403626"},{"name":"Mississippi","aba":"065305436"},{"name":"Missouri","aba":"081001387"},{"name":"North Carolina","aba":"053012029"},{"name":"South Carolina","aba":"053201814"},{"name":"Tennessee","aba":"064000017"},{"name":"Texas","aba":"111900785"},{"name":"Virginia","aba":"051009296"}]},"suntrust":{"name":"SunTrust Bank","states":[{"name":"All Locations","aba":"061000104"}]},"td":{"name":"TD Bank","states":[{"name":"Connecticut","aba":"011103093"},{"name":"Delaware","aba":"031201360"},{"name":"District of Columbia","aba":"054001725"},{"name":"Florida","aba":"067014822"},{"name":"Maine","aba":"211274450"},{"name":"Maryland","aba":"054001725"},{"name":"Massachusetts","aba":"211370545"},{"name":"New Hampshire","aba":"011400071"},{"name":"New Jersey","aba":"031201360"},{"name":"New York - Metro","aba":"026013673"},{"name":"New York - Upstate","aba":"021302567"},{"name":"North Carolina","aba":"053902197"},{"name":"Pennsylvania","aba":"036001808"},{"name":"Rhode Island","aba":"211370545"},{"name":"South Carolina","aba":"053902197"},{"name":"Vermont","aba":"011600033"},{"name":"Virginia","aba":"054001725"}]},"usaa":{"name":"USAA Federal Savings Bank","states":[{"name":"All Locations","aba":"314074269"}]},"usbank":{"name":"US Bank","states":[{"name":"Arizona","aba":"122105155"},{"name":"Arkansas","aba":"082000549"},{"name":"California - Northern","aba":"121122676"},{"name":"California - Southern","aba":"122235821"},{"name":"Colorado - Aspen","aba":"102101645"},{"name":"Colorado - All other areas","aba":"102000021"},{"name":"Idaho","aba":"123103729"},{"name":"Illinois - Northern","aba":"071904779"},{"name":"Illinois - Southern","aba":"081202759"},{"name":"Indiana","aba":"074900783"},{"name":"Iowa - Council Bluffs","aba":"104000029"},{"name":"Iowa - All other areas","aba":"073000545"},{"name":"Kansas","aba":"101000187"},{"name":"Kentucky - Northern","aba":"042100175"},{"name":"Kentucky - Western","aba":"083900363"},{"name":"Minnesota - East Grand Forks","aba":"091215927"},{"name":"Minnesota - Moorhead","aba":"091300023"},{"name":"Minnesota - All other areas","aba":"091000022"},{"name":"Missouri","aba":"081000210"},{"name":"Montana","aba":"092900383"},{"name":"Nebraska","aba":"104000029"},{"name":"Nevada","aba":"121201694"},{"name":"New Mexico","aba":"107002312"},{"name":"North Dakota","aba":"091300023"},{"name":"Ohio - Cleveland","aba":"041202582"},{"name":"Ohio - All other areas","aba":"042000013"},{"name":"Oregon","aba":"123000220"},{"name":"South Dakota","aba":"091408501"},{"name":"Tennessee","aba":"064000059"},{"name":"Utah","aba":"124302150"},{"name":"Washington","aba":"125000105"},{"name":"Wisconsin","aba":"075000022"},{"name":"Wyoming","aba":"307070115"},{"name":"All other states","aba":"091000022"}]},"wellsfargo":{"name":"Wells Fargo","states":[{"name":"Alabama","aba":"062000080"},{"name":"Alaska","aba":"125200057"},{"name":"Arizona","aba":"122105278"},{"name":"Arkansas","aba":"111900659"},{"name":"California","aba":"121042882"},{"name":"Colorado","aba":"102000076"},{"name":"Connecticut","aba":"021101108"},{"name":"Delaware","aba":"031100869"},{"name":"District of Columbia","aba":"054001220"},{"name":"Florida","aba":"063107513"},{"name":"Georgia","aba":"061000227"},{"name":"Hawaii","aba":"121042882"},{"name":"Idaho","aba":"124103799"},{"name":"Illinois","aba":"071101307"},{"name":"Indiana","aba":"074900275"},{"name":"Iowa","aba":"073000228"},{"name":"Kansas","aba":"101089292"},{"name":"Kentucky","aba":"121042882"},{"name":"Louisiana","aba":"121042882"},{"name":"Maine","aba":"121042882"},{"name":"Maryland","aba":"055003201"},{"name":"Massachusetts","aba":"121042882"},{"name":"Michigan","aba":"091101455"},{"name":"Minnesota","aba":"091000019"},{"name":"Mississippi","aba":"062203751"},{"name":"Missouri","aba":"121042882"},{"name":"Montana","aba":"092905278"},{"name":"Nebraska","aba":"104000058"},{"name":"Nevada","aba":"321270742"},{"name":"New Hampshire","aba":"121042882"},{"name":"New Jersey","aba":"021200025"},{"name":"New Mexico","aba":"107002192"},{"name":"New York","aba":"026012881"},{"name":"North Carolina","aba":"053000219"},{"name":"North Dakota","aba":"091300010"},{"name":"Ohio","aba":"041215537"},{"name":"Oklahoma","aba":"121042882"},{"name":"Oregon","aba":"123006800"},{"name":"Pennsylvania","aba":"031000503"},{"name":"Rhode Island","aba":"121042882"},{"name":"South Carolina","aba":"053207766"},{"name":"South Dakota","aba":"091400046"},{"name":"Tennessee","aba":"064003768"},{"name":"Texas","aba":"111900659"},{"name":"Texas - El Paso","aba":"112000066"},{"name":"Utah","aba":"124002971"},{"name":"Vermont","aba":"121042882"},{"name":"Virginia","aba":"051400549"},{"name":"Washington","aba":"125008547"},{"name":"West Virginia","aba":"121042882"},{"name":"Wisconsin","aba":"075911988"},{"name":"Wyoming","aba":"102301092"}]}};

Date.prototype.yyyymmdd = function() {
    var mm = this.getMonth() + 1; // getMonth() is zero-based
    var dd = this.getDate();

    return [this.getFullYear(),
        (mm>9 ? '' : '0') + mm,
        (dd>9 ? '' : '0') + dd
    ].join('-');
};

function MainForm(props) {
    let [step, setStep] = useState(1);
    let [openHelp, setOpenHelp] = useState(false);
    let [date1, setDate1] = useState();
    let [date2, setDate2] = useState();
    let [sended, setSended] = useState(false);
    let [sending, setSending] = useState(false);
    let [show, setShow] = useState(false);
    let [modalType, setModalType] = useState();
    let [modalLoading, setModalLoading] = useState(false);
    let [modalContent, setModalContent] = useState({});
    let [headerResponse, setHeaderResponse] = useState('');
    let [paymentFreq, setPaymentFreq] = useState('');

    const handleClose = () => {
        setShow(false);
        setModalType('');
        setModalContent({});
    };

    const handleShow = (type) => {
        setModalType(type);
        setShow(true)
    };

    let days = [];
    let years = [];
    let curYear = new Date().getFullYear();

    // let headerResponse = '';
    var hollidays = [
        "2019-01-01",  // New Year's Day observed
        "2019-01-21", // Martin Luther King Day
        "2019-02-18", // Washington's Birthday
        "2019-05-27", // Memorial Day
        "2019-07-04", // Independence Day
        "2019-09-02", // Labor Day
        "2019-10-14", // Columbus Day
        "2019-11-28", // Thanksgiving Day
        "2019-12-25", // Christmas Day

        "2020-01-01",  // New Year's Day observed
        "2020-01-20", // Martin Luther King Day
        "2020-02-17", // Washington's Birthday
        "2020-05-25", // Memorial Day
        "2020-07-04", // Independence Day
        "2020-09-07", // Labor Day
        "2020-10-12", // Columbus Day
        "2020-11-26", // Thanksgiving Day
        "2020-12-25" // Christmas Day
    ];

    let excludedDates = hollidays.map(day => new Date(day));

    for (let i = 1; i<=31; i++) {
        days.push(i);
    }

    for (let i = curYear - 18; i >= 1922; i--) {
        years.push(i);
    }

    function changeStep(n) {
        if (step + n >= 1 && step +n <= 3) {
            setStep(step + n);
        }
    }

    function handleSubmit() {
        let area = document.body.querySelector('.incomeNextDate1-area .error-message');
        let area2 = document.body.querySelector('.incomeNextDate2-area .error-message');
        let area3 = document.body.querySelector('.incomePaymentFrequency-area .error-message');

        if (!date1) {
            area.innerText = 'This field is required';
        } else {
            area.innerText = '';
        }

        if (!date2) {
            area2.innerText = 'This field is required';
        } else {
            area2.innerText = '';
        }

        if (!paymentFreq) {
            area3.innerText = 'This field is required';
        } else {
            area3.innerText = '';
        }
    }


    return <Formik
        initialValues={{
            loanAmount: props.q.loan || '',
            firstName: '',
            lastName: '',
            email:  props.q.email || '',
            month: '',
            day: '',
            year: '',
            address: '',
            zip: '',
            workCompanyName: '',
            driversLicenseNumber: '',
            ssn: '',
            homePhone: '',
            workPhone: '',
            incomeNetMonthly: '',
            incomeType: '',
            activeMilitary: '',
            // incomePaymentFrequency: '',
            incomeNextDate1: '',
            incomeNextDate2: '',
            bankDirectDeposit: '',
            bankAccountType: '',
            bankAba: '',
            bankAccountNumber: '',
            bankName: '',
            confirm: false
        }}
        onSubmit={async (values, errors) => {

            let reqObj = {
                ...settings.formSettings,
                loanAmount: +values.loanAmount,
                workCompanyName: values.workCompanyName,
                activeMilitary: values.activeMilitary,
                ssn: values.ssn,
                driversLicenseNumber: values.driversLicenseNumber,
                incomeType: values.incomeType,
                incomePaymentFrequency: paymentFreq,
                incomeNetMonthly: +values.incomeNetMonthly,
                incomeNextDate1: date1.yyyymmdd(),
                incomeNextDate2: date2.yyyymmdd(),
                bankDirectDeposit: values.bankDirectDeposit,
                bankAba: values.bankAba,
                bankAccountNumber: values.bankAccountNumber,
                bankAccountType: values.bankAccountType,
                firstName: values.firstName,
                lastName: values.lastName,
                dob: `${values.year}-${values.month}-${values.day}`,
                address: values.address,
                zip: values.zip,
                email: values.email,
                homePhone: values.homePhone.replace(/-/g, ''),
                workPhone: values.workPhone.replace(/-/g, ''),
                userIp: props.ip,
                webSiteUrl: settings.siteURL,
                source: `https://${settings.siteURL}`
            };

            setSending(true);

            let res = await fetch('/api/leadForm', {
                method: 'post',
                body: JSON.stringify(reqObj),
            });

            // console.log(res);
            let resJson = await res.json().catch((error) => console.log(error));
            // console.log('apiResponse', resJson);

            reqObj.apiResponse = resJson;
            reqObj.ssn = reqObj.ssn.slice(-4);

            // console.log('objForTracker', JSON.stringify(reqObj));

            fetch(`${settings.tunnelUrl}/api/leads/bigforms/`, {
                method: 'POST',
                body: JSON.stringify(reqObj),
                headers: {
                    'Authorization': `Token 379f877bd00d78d65f261cf18c1f01671d227a8c`,
                    'content-type': 'application/json'
                }
            });

            // let apiTrackerResp = await apiTracker.json();
            // console.log('apiTrackerResponse', apiTrackerResp);

            if (resJson.status === 1) {
                window.open(resJson.redirect_url, '_blank').focus();
                setHeaderResponse(<div className='aftersending-message'>
                    <h2>Thank you for your request!</h2>
                </div>)
                // headerResponse =
            } else {
                setHeaderResponse(<div className='aftersending-message'>
                    <h2>Unfortunately, You Are Not Within Our Coverage Area.</h2>
                    <p><strong>HOWEVER, YOU MAY BE ABLE TO FIND A LOAN PRODUCT SUITABLE FOR YOU FROM ANOTHER COMPANY* BY CLICKING THEIR BANNER BELOW:</strong></p>
                    <div className='banner-wrapper'>
                        <a href="https://indylend.com/?aid=5019#step_1" target="_blank"><img alt="" src={Banner2} /></a>
                        <a href="https://loansolo.com/?aid=5019" target="_blank"><img alt="" src={Banner1} /></a>
                    </div>
                    <p>Please note that by clicking to another company’s Banner, you are navigating away from the {settings.siteName} website to the website of an unaffiliated third party.</p>
                    <p>*{settings.siteName} does not assume any responsibility for promoting the sponsored listings and is not liable for any actions taken on affiliated lenders’ websites.</p>
                </div>)
                // headerResponse =
            }

            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });

            setSending(false);
            setSended(true);


        }}
        enableReinitialize={true}
    >
        {({ values, errors, touched, isValidating, validateField, validateForm }) => (
            <div className='main-form-wrapper'>
                <h2 className='main-form-title'>Fill in this Free Application Form</h2>
                <p className='main-form-description'>{replaceTokens('[site] allows you to compare rates from multiple lenders by filling out one easy form.', {})}</p>
                <p className='main-form-encryption'><FontAwesomeIcon icon={faLock} /> We use 256-bit encryption to keep your information safe!</p>
                <p className='main-form-description'><strong>SUBMIT YOUR REQUEST IN 3 STEPS</strong></p>
                <div className='main-form-steps'>
                    <div className={step >= 1 ? 'step-wrapper active' : 'step-wrapper'}>
                        <div className='step-circle'>
                            <div className='step'>1</div>
                        </div>

                        <p className='step-title'>Personal Information</p>
                    </div>
                    <div className={step >= 2 ? 'step-wrapper active' : 'step-wrapper'}>
                        <div className='step-circle'>
                            <div className='step'>2</div>
                        </div>
                        <p className='step-title'>Additional Information</p>
                    </div>
                    <div className={step >= 3 ? 'step-wrapper active' : 'step-wrapper'}>
                        <div className='step-circle'>
                            <div className='step'>3</div>
                        </div>
                        <p className='step-title'>Your Transfer Details</p>
                    </div>
                </div>
                {sended
                    ? <div className='main-form'>
                        {headerResponse}
                    </div>
                    : <Form className='main-form' >
                        {step === 1
                            ? <div>
                                <div className='form-header'>
                                    <p>Personal information</p>
                                    <hr />
                                </div>
                                <Row>
                                    <Col>
                                        <label htmlFor="loanAmount" className='label'>Request Your Loan Amount <span className='required-field'>*</span></label>
                                        <Field
                                            as="select"
                                            name="loanAmount"
                                            className={"header-form-input"}
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'Select loan amount.';
                                                }
                                                return error;
                                            }}
                                        >
                                            <option value="" label="Select loan amount" />
                                            <option value="100">$100</option>
                                            <option value="200">$200</option>
                                            <option value="300">$300</option>
                                            <option value="400">$400</option>
                                            <option value="500">$500</option>
                                            <option value="600">$600</option>
                                            <option value="700">$700</option>
                                            <option value="800">$800</option>
                                            <option value="900">$900</option>
                                            <option value="1000">$1,000</option>
                                        </Field>
                                        {errors.loanAmount && touched.loanAmount && <div className='error-message'>{errors.loanAmount}</div>}
                                    </Col>
                                </Row>
                                <Row>
                                    <Col md xs={12} >
                                        <label htmlFor="firstName">First Name <span className='required-field'>*</span></label>
                                        <Field
                                            as='input'
                                            id="firstName"
                                            name="firstName"
                                            className={"header-form-input"}
                                            type="text"
                                            placeholder="First Name"
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'This field is required.';
                                                } else if (!/[A-Za-z ]/g.test(value)) {
                                                    error = 'First name should contain only letters';
                                                }
                                                return error;
                                            }}
                                        />
                                        {errors.firstName && touched.firstName && <div className='error-message'>{errors.firstName}</div>}
                                    </Col>
                                    <Col md xs={12} >
                                        <label htmlFor="lastName">Last Name <span className='required-field'>*</span></label>
                                        <Field
                                            as='input'
                                            id="lastName"
                                            name="lastName"
                                            className={"header-form-input"}
                                            type="text"
                                            placeholder="Last Name"
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'This field is required.';
                                                } else if (!/[A-Za-z ]/g.test(value)) {
                                                    error = 'Last name should contain only letters';
                                                }
                                                return error;
                                            }}
                                        />
                                        {errors.lastName && touched.lastName && <div className='error-message'>{errors.lastName}</div>}
                                    </Col>
                                    <Col md xs={12} >
                                        <label htmlFor="email">Email <span className='required-field'>*</span></label>
                                        <Field
                                            as='input'
                                            id="email"
                                            name="email"
                                            className={"header-form-input"}
                                            type="email"
                                            placeholder="Enter Your Email Address"
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'We need your email address to contact you.';
                                                } else if (!/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}$/i.test(value)) {
                                                    error = 'Your email address must be in the format of name@domain.com';
                                                }
                                                return error;
                                            }}
                                        />
                                        {errors.email && touched.email && <div className='error-message'>{errors.email}</div>}
                                    </Col>

                                </Row>
                                <Row>
                                    <Col md xs={12} >
                                        <label className='label'>Date of birth <span className='required-field'>*</span></label>
                                        <Row className='date-of-birth-set'>
                                            <Col>
                                                <Field
                                                    as='select'
                                                    name="month"
                                                    className={"header-form-input"}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                >
                                                    <option value="" label="Month" />
                                                    <option value="01">Jan</option>
                                                    <option value="02">Feb</option>
                                                    <option value="03">Mar</option>
                                                    <option value="04">Apr</option>
                                                    <option value="05">May</option>
                                                    <option value="06">Jun</option>
                                                    <option value="07">Jul</option>
                                                    <option value="08">Aug</option>
                                                    <option value="09">Sep</option>
                                                    <option value="10">Oct</option>
                                                    <option value="11">Nov</option>
                                                    <option value="12">Dec</option>
                                                </Field>
                                                {errors.month && touched.month && <div className='error-message'>{errors.month}</div>}
                                            </Col>

                                            <Col>
                                                <Field
                                                    as='select'
                                                    name="day"
                                                    className={"header-form-input"}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                >
                                                    <option value="" label="Day" />
                                                    {
                                                        days.map(day => {
                                                            return <option key={day} value={day}>{day}</option>
                                                        })
                                                    }
                                                </Field>
                                                {errors.day && touched.day && <div className='error-message'>{errors.day}</div>}
                                            </Col>

                                            <Col>
                                                <Field
                                                    as='select'
                                                    name="year"
                                                    className={"header-form-input"}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                >
                                                    <option value="" label="Year" />
                                                    {
                                                        years.map(year => {
                                                            return <option key={year} value={year}>{year}</option>
                                                        })
                                                    }
                                                </Field>
                                                {errors.year && touched.year && <div className='error-message'>{errors.year}</div>}
                                            </Col>
                                        </Row>
                                    </Col>

                                    <Col md xs={12} >
                                        <label htmlFor="address">Street Address <span className='required-field'>*</span></label>
                                        <Field
                                            as='input'
                                            id="address"
                                            name="address"
                                            className={"header-form-input"}
                                            type="text"
                                            placeholder="Street Address"
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'This field is required.';
                                                } else if (/\d/.test(value)){
                                                    if (value.length >= 4 && /[A-Za-z]/g.test(value)) {
                                                        error = null;
                                                    } else {
                                                        error = 'Field may not be less than 2 letters and 1 number.'
                                                    }
                                                } else {
                                                    error = 'Field may not be less than 2 letters and 1 number.';
                                                }
                                                return error;
                                            }}
                                        />
                                        {errors.address && touched.address && <div className='error-message'>{errors.address}</div>}
                                    </Col>

                                    <Col md xs={12} >
                                        <label htmlFor="zip">Zip Code <span className='required-field'>*</span></label>
                                        <Field
                                            as={InputMask}
                                            mask="99999"
                                            id="zip"
                                            name="zip"
                                            className={"header-form-input"}
                                            type="text"
                                            placeholder="Zip Code"
                                            validate={(value) => {
                                                let error;
                                                if (!value.length) {
                                                    error = 'This field is required.';
                                                } else if (/_/g.test(value)) {
                                                    error = 'A valid ZIP number must be 5 digits long.';
                                                }
                                                return error
                                            }}
                                        />
                                        {errors.zip && touched.zip && <div className='error-message'>{errors.zip}</div>}
                                    </Col>
                                </Row>
                            </div>
                            : step === 2
                                ? <div>
                                    <div className='form-header'>
                                        <p>Additional information</p>
                                        <hr />
                                    </div>
                                    <Row>
                                        <Col md xs={12} >
                                            <label htmlFor="workCompanyName">Employer Name <span className='required-field'>*</span></label>
                                            <Field
                                                as='input'
                                                id="workCompanyName"
                                                name="workCompanyName"
                                                className={"header-form-input"}
                                                type="text"
                                                placeholder="Employer Name"
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'This field is required.';
                                                    } else if (value.length > 0 && value.length < 2) {
                                                        error = 'Field may not be less than 2 letters.';
                                                    }
                                                    return error
                                                }}
                                            />
                                            {errors.workCompanyName && touched.workCompanyName && <div className='error-message'>{errors.workCompanyName}</div>}
                                        </Col>
                                        <Col md xs={12} >
                                            <label htmlFor="driversLicenseNumber">Driver License <span className='required-field'>*</span></label>
                                            <Field
                                                as='input'
                                                id="driversLicenseNumber"
                                                name="driversLicenseNumber"
                                                className={"header-form-input"}
                                                type="text"
                                                placeholder="Driver License"
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'This field is required.';
                                                    } else if (/^[a-zA-Z0-9]+$ /g.test(value)) {
                                                        error = 'Entry must consist of alpha-numeric characters only. Symbols will not be accepted.';
                                                    }
                                                    return error
                                                }}
                                            />
                                            {errors.driversLicenseNumber && touched.driversLicenseNumber && <div className='error-message'>{errors.driversLicenseNumber}</div>}
                                        </Col>
                                        <Col md xs={12} >
                                            <label htmlFor="ssn">Social Security Number <span className='required-field'>*</span></label>
                                            <Field
                                                as={InputMask}
                                                mask="999-99-9999"
                                                id="ssn"
                                                name="ssn"
                                                className={"header-form-input"}
                                                type="text"
                                                placeholder="Social Security Number"
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'This field is required.';
                                                    } else if (/_/g.test(value)) {
                                                        error = 'Must be 9 digits and only consist of numeric values.';
                                                    }
                                                    return error
                                                }}
                                            />
                                            {errors.ssn && touched.ssn && <div className='error-message'>{errors.ssn}</div>}
                                        </Col>

                                    </Row>
                                    <Row>
                                        <Col md xs={12} >
                                            <label htmlFor="homePhone">Primary Phone <span className='required-field'>*</span></label>
                                            <Field
                                                as={InputMask}
                                                mask="999-999-9999"
                                                id="homePhone"
                                                name="homePhone"
                                                className={"header-form-input"}
                                                type="text"
                                                placeholder="Primary Phone"
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'This field is required.';
                                                    } else if (/_/g.test(value)) {
                                                        error = 'Must only contain numeric values. Number must be 10 digits (including area code).';
                                                    }
                                                    return error
                                                }}
                                            />
                                            {errors.homePhone && touched.homePhone && <div className='error-message'>{errors.homePhone}</div>}
                                        </Col>
                                        <Col md xs={12} >
                                            <label htmlFor="workPhone">Employer Phone <span className='required-field'>*</span></label>
                                            <Field
                                                as={InputMask}
                                                mask="999-999-9999"
                                                id="workPhone"
                                                name="workPhone"
                                                className={"header-form-input"}
                                                type="text"
                                                placeholder="Employer Phone"
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'This field is required.';
                                                    } else if (/_/g.test(value)) {
                                                        error = 'Must only contain numeric values. Number must be 10 digits (including area code).';
                                                    }
                                                    return error
                                                }}
                                            />
                                            {errors.workPhone && touched.workPhone && <div className='error-message'>{errors.workPhone}</div>}
                                        </Col>
                                        <Col md xs={12} >
                                            <label className='label'>Request Your Loan Amount <span className='required-field'>*</span></label>
                                            <Field
                                                as="select"
                                                name="incomeNetMonthly"
                                                className={"header-form-input"}
                                                validate={(value) => {
                                                    let error;
                                                    if (!value.length) {
                                                        error = 'Select loan amount.';
                                                    }
                                                    return error;
                                                }}
                                            >
                                                <option value="">Select</option>
                                                <option value="6000">More than $5,000</option>
                                                <option value="5000">$4,501 - $5,000</option>
                                                <option value="4500">$4,001 - $4,500</option>
                                                <option value="4000">$3,501 - $4,000</option>
                                                <option value="3500">$3,001 - $3,500</option>
                                                <option value="3000">$2,501 - $3,000</option>
                                                <option value="2500">$2,001 - $2,500</option>
                                                <option value="2000">$1,501 - $2,000</option>
                                                <option value="1500">$1,000 - $1,500</option>
                                            </Field>
                                            {errors.incomeNetMonthly && touched.incomeNetMonthly && <div className='error-message'>{errors.incomeNetMonthly}</div>}
                                        </Col>

                                    </Row>
                                    <Row>
                                        <Col md xs={12} >
                                            <label>Income Source <span className='required-field'>*</span></label>
                                            <div className='radio-btns-wrapper'>
                                                <Field
                                                    as={Check}
                                                    custom
                                                    type='radio'
                                                    name="incomeType"
                                                    id={`EMPLOYMENT-type`}
                                                    value='EMPLOYMENT'
                                                    // checked={value === 'EMPLOYMENT'}
                                                    label={`Job Income`}
                                                    // onChange={() => setIncomeSource('EMPLOYMENT')}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                />

                                                <Field
                                                    as={Check}
                                                    custom
                                                    name="incomeType"
                                                    type='radio'
                                                    // checked={value === 'BENEFITS'}
                                                    label={`Benefits`}
                                                    value='BENEFITS'
                                                    // onChange={() => setIncomeSource('BENEFITS')}
                                                    id={`benefit-type`}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                />

                                            </div>
                                            {errors.incomeType && touched.incomeType && <div className='error-message'>{errors.incomeType}</div>}

                                        </Col>

                                        <Col md xs={12} >
                                            <label>Active Military <span className='required-field'>*</span></label>
                                            <div className='radio-btns-wrapper'>
                                                <Field
                                                    as={Check}
                                                    custom
                                                    type='radio'
                                                    name='activeMilitary'
                                                    id={`military-yes`}
                                                    value='YES'
                                                    // checked={activeMilitary === 'YES' ? true : false}
                                                    label={`Yes`}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                />

                                                <Field
                                                    as={Check}
                                                    custom
                                                    type='radio'
                                                    name='activeMilitary'
                                                    // checked={activeMilitary === 'NO' ? true : false}
                                                    label={`No`}
                                                    value='NO'
                                                    // onChange={() => setActiveMilitary('NO')}
                                                    id={`military-no`}
                                                    validate={(value) => {
                                                        let error;
                                                        if (!value.length) {
                                                            error = 'This field is required.';
                                                        }
                                                        return error;
                                                    }}
                                                />
                                            </div>
                                            {errors.incomeType && touched.incomeType && <div className='error-message'>{errors.incomeType}</div>}
                                        </Col>
                                    </Row>
                                </div>
                                : step === 3
                                    ? <div>
                                        <div className='form-header'>
                                            <p>Your Transfer Details</p>
                                            <hr />
                                        </div>

                                        <Row>
                                            <Col className='incomePaymentFrequency-area' md xs={12} >
                                                <label className='label'>Pay Frequency <span className='required-field'>*</span></label>
                                                <Field
                                                    as='select'
                                                    name="incomePaymentFrequency"
                                                    className={"header-form-input"}
                                                    value={paymentFreq}
                                                    onChange={(e)=> {
                                                        setPaymentFreq(e.target.value);
                                                        setDate1(null);
                                                        setDate2(null);
                                                    }}
                                                >
                                                    <option value="" label="Select" />
                                                    <option value="WEEKLY">Weekly</option>
                                                    <option value="BIWEEKLY">Biweekly</option>
                                                    <option value="TWICEMONTHLY">Twicemonthly</option>
                                                    <option value="MONTHLY">Monthly</option>
                                                </Field>
                                                <div className='error-message'></div>
                                            </Col>
                                            <Col className='incomeNextDate1-area' md xs={12} >
                                                <label className='label'>Next Paydate 1 <span className='required-field'>*</span></label>
                                                <DatePicker
                                                    autoComplete='off'
                                                    // as={DatePicker}
                                                    excludeDates={excludedDates}
                                                    minDate={new Date()}
                                                    dateFormat="yyyy/MM/dd"
                                                    className='header-form-input'
                                                    name='incomeNextDate1'
                                                    selected={date1}
                                                    onChange={(value) => {
                                                        setDate1(value);
                                                        values.incomeNextDate1 = value;
                                                        // console.log(value);
                                                        switch (paymentFreq) {
                                                            case "WEEKLY":
                                                                let dateWeekly = new Date(value);
                                                                dateWeekly.setDate(value.getDate() + 7);
                                                                setDate2(dateWeekly);
                                                                break;
                                                            case "BIWEEKLY":
                                                                let dateBiweekly = new Date(value);
                                                                dateBiweekly.setDate(value.getDate() + 14);
                                                                setDate2(dateBiweekly);
                                                                break;
                                                            case "TWICEMONTHLY":
                                                                let dateTwicemonthly = new Date(value);
                                                                dateTwicemonthly.setDate(value.getDate() + 17);
                                                                setDate2(dateTwicemonthly);
                                                                break;
                                                            case "MONTHLY":
                                                                let dateMonthly = new Date(value);
                                                                dateMonthly.setDate(value.getDate() + 31);
                                                                setDate2(dateMonthly);
                                                            default:
                                                                break;
                                                        }
                                                        if (value === null) {
                                                            errors.incomeNextDate1 = 'This field is required.';
                                                            touched.incomeNextDate1 = 'This field is required.';
                                                        } else {
                                                            errors.incomeNextDate1 = '';
                                                            touched.incomeNextDate1 = '';
                                                        }
                                                    }}
                                                />
                                                <div className='error-message'></div>
                                            </Col>
                                            <Col className='incomeNextDate2-area' md xs={12} >
                                                <label className='label'>Next Paydate 2 <span className='required-field'>*</span></label>
                                                <DatePicker
                                                    autoComplete='off'
                                                    // as={DatePicker}
                                                    excludeDates={excludedDates}
                                                    minDate={new Date()}
                                                    dateFormat="yyyy/MM/dd"
                                                    className='header-form-input'
                                                    name='incomeNextDate2'
                                                    selected={date2}
                                                    onChange={(value) => {
                                                        setDate2(value);
                                                        values.incomeNextDate2 = value;
                                                        if (value === null) {
                                                            errors.incomeNextDate2 = 'This field is required.';
                                                            touched.incomeNextDate2 = 'This field is required.';
                                                        } else {
                                                            errors.incomeNextDate2 = '';
                                                            touched.incomeNextDate2 = '';
                                                        }
                                                    }}
                                                />
                                                <div className='error-message'></div>
                                            </Col>
                                        </Row>

                                        <div className='aba-help'>
                                            <Row>
                                                <Col md xs={12} >
                                                    <label htmlFor="bankAba">ABA/Routing <span className='required-field'>*</span></label>
                                                    <Field
                                                        as={InputMask}
                                                        mask="999999999"
                                                        id="bankAba"
                                                        name="bankAba"
                                                        className={"header-form-input"}
                                                        type="text"
                                                        placeholder="ABA/Routing"
                                                        // value={location}
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            } else if (/_/g.test(value)) {
                                                                error = 'A valid ABA/bank routing number must be 9 digits long.';
                                                            }
                                                            return error
                                                        }}
                                                    />
                                                    {errors.bankAba && touched.bankAba && <div className='error-message'>{errors.bankAba}</div>}
                                                </Col>
                                                <Col md xs={12} >
                                                    <label htmlFor="bankAccountNumber">Account Number <span className='required-field'>*</span></label>
                                                    <Field
                                                        as='input'
                                                        id="bankAccountNumber"
                                                        name="bankAccountNumber"
                                                        className={"header-form-input"}
                                                        type="text"
                                                        placeholder="Account Number"
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            } else if (!/\d/g.test(value)) {
                                                                error = 'May only include numeric values.';
                                                            }
                                                            return error
                                                        }}
                                                    />
                                                    {errors.bankAccountNumber && touched.bankAccountNumber && <div className='error-message'>{errors.bankAccountNumber}</div>}
                                                </Col>
                                            </Row>
                                            <p className='help-title' onClick={() => {
                                                // let help = document.body.querySelector('.help-bank');
                                                // help.classList.toggle('active');
                                                setOpenHelp(!openHelp);
                                            }} aria-controls="help-bank"
                                               aria-expanded={openHelp}>
                                                Need help? Use our ABA lookup. <FontAwesomeIcon icon={openHelp ? faMinusCircle : faPlusCircle}/>
                                            </p>
                                            <p className='help-description'>Your data is secured using industry standard for the site information security. Your ABA/Routing number can be found on most bank statements as well as on the bottom of your checks.</p>
                                            <img src={CheckImage} className='check-img'/>
                                            <Collapse in={openHelp}>
                                                <Row id='help-bank' className='help-bank'>
                                                    <Col md xs={12} >
                                                        <label className='label'>Please, choose your bank</label>
                                                        <Field
                                                            as='select'
                                                            name="bankName"
                                                            className={"header-form-input"}
                                                            // value={bankName}
                                                        >
                                                            <option value=''>Choose your bank</option>
                                                            { Object.entries(ccABAInfo).map(([key, value]) => {
                                                                return <option key={key} value={key}>{value.name}</option>
                                                            })}
                                                        </Field>
                                                    </Col>
                                                    <Col md xs={12} >
                                                        <label className='label'>What location was this account opened in?</label>
                                                        <Field
                                                            as='select'
                                                            name="bankAba"
                                                            className={"header-form-input"}
                                                        >
                                                            <option value=''>Choose bank location</option>

                                                            {values.bankName !== '' ?
                                                                ccABAInfo[values.bankName].states.map((st) => {
                                                                    return <option key={`${values.bankName}-${st.aba}-${st.name}`} value={st.aba}>{st.name}</option>
                                                                }) : ''}
                                                        </Field>
                                                    </Col>
                                                </Row>
                                            </Collapse>
                                        </div>

                                        <Row>
                                            <Col md xs={12} >
                                                <label>Direct Deposit <span className='required-field'>*</span></label>
                                                <div className='radio-btns-wrapper'>
                                                    <Field
                                                        as={Check}
                                                        custom
                                                        type='radio'
                                                        id={`bankDirectDeposit-yes`}
                                                        value='YES'
                                                        name='bankDirectDeposit'
                                                        // checked={bankDirectDeposit === 'YES' ? true : false}
                                                        label={`Yes`}
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            }
                                                            return error;
                                                        }}
                                                    />

                                                    <Field
                                                        as={Check}
                                                        custom
                                                        type='radio'
                                                        name='bankDirectDeposit'
                                                        // checked={bankDirectDeposit === 'NO' ? true : false}
                                                        label={`No`}
                                                        value='NO'
                                                        // onChange={() => setBankDirectDeposit('NO')}
                                                        id={`bankDirectDeposit-no`}
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            }
                                                            return error;
                                                        }}
                                                    />
                                                </div>
                                                {errors.bankDirectDeposit && touched.bankDirectDeposit && <div className='error-message'>{errors.bankDirectDeposit}</div>}
                                            </Col>


                                            <Col md xs={12} >
                                                <label>Type of Account <span className='required-field'>*</span></label>
                                                <div className='radio-btns-wrapper'>
                                                    <Field
                                                        as={Check}
                                                        custom
                                                        type='radio'
                                                        id={`checking-type`}
                                                        // checked={bankAccountType === 'CHECKING' ? true : false}
                                                        label={`Checking`}
                                                        value='CHECKING'
                                                        name='bankAccountType'
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            }
                                                            return error;
                                                        }}
                                                    />

                                                    <Field
                                                        as={Check}
                                                        custom
                                                        type='radio'
                                                        // checked={bankAccountType === 'SAVING' ? true : false}
                                                        label={`Saving`}
                                                        value='SAVING'
                                                        name='bankAccountType'
                                                        // onChange={() => setBankAccountType('SAVING')}
                                                        id={`saving-type`}
                                                        validate={(value) => {
                                                            let error;
                                                            if (!value.length) {
                                                                error = 'This field is required.';
                                                            }
                                                            return error;
                                                        }}
                                                    />
                                                </div>
                                                {errors.bankAccountType && touched.bankAccountType && <div className='error-message'>{errors.bankAccountType}</div>}
                                            </Col>
                                        </Row>

                                        <div className='disclosure'>
                                            <p>By submitting my request, I acknowledge I have read, understand, and agree to the terms of the <a onClick={() => handleShow('privacy')}>Privacy Policy</a> and the <a onClick={() => handleShow('terms')}>Terms & Conditions of Use Agreement</a>. I also understand I may be contacted by telephone by a lender concerning my loan request.</p>
                                        </div>

                                        <Field
                                            as={Check}
                                            custom
                                            type='checkbox'
                                            id={`custom-checkbox`}
                                            name='confirm'
                                            checked={values.confirm}
                                            // validate={(value) => {
                                            //     let error;
                                            //     if (!value) {
                                            //         error = 'This field is required.';
                                            //     }
                                            //     return error;
                                            // }}
                                            label={<p>I consent to receive telephone calls (including SMS text messages) as explained <a onClick={() => handleShow('confirm')}>here.</a> <b>(This message is not a condition to obtaining a loan or any services)</b></p>}
                                        />
                                        {errors.confirm && touched.confirm && <div className='error-message'>{errors.confirm}</div>}


                                        <div className='main-form-footer'>
                                            <button type="submit" className={"regular-btn"} onClick={() => handleSubmit(values)}>
                                                Apply Now {sending
                                                ? <Spinner animation="border" variant="light" size={'sm'}/>
                                                : ''}
                                            </button>
                                        </div>
                                    </div>
                                    : ''}
                    </Form>
                }

                {sended ? ''
                    : <div className='steps-buttons'>
                        <button
                            className={step > 1 ? 'regular-btn' : 'regular-btn disabled'}
                            onClick={() => {
                                changeStep(-1)
                            }}
                        >
                            Previous Step
                        </button>
                        <button
                            className={step < 3 ? 'regular-btn' : 'regular-btn disabled'}
                            onClick={() => {
                                if (step === 1) {

                                    let fields = ['loanAmount',
                                        'firstName',
                                        'lastName',
                                        'email',
                                        'month',
                                        'day',
                                        'year',
                                        'address',
                                        'zip'];

                                    fields.forEach(field => {
                                        validateField(field);
                                        let f = document.body.querySelector(`[name=${field}]`);
                                        f.focus();
                                        f.blur();
                                    });

                                    if (Object.keys(errors).length === 0 && values.firstName.length) {
                                        changeStep(1)
                                    }

                                } else if (step === 2) {
                                    let fields = ['workCompanyName',
                                        'driversLicenseNumber',
                                        'ssn',
                                        'homePhone',
                                        'workPhone',
                                        'incomeNetMonthly',
                                        'incomeType',
                                        'activeMilitary'];

                                    fields.forEach(field => {
                                        validateField(field);
                                        let f = document.body.querySelector(`[name=${field}]`);
                                        f.focus();
                                        f.blur();
                                    });

                                    if (Object.keys(errors).length === 0 && values.driversLicenseNumber.length) {
                                        changeStep(1)
                                    }

                                } else {
                                    console.log(values);
                                }
                            }}
                        >
                            Next Step
                        </button>
                    </div>
                }

                <Modal show={show}
                       onHide={handleClose}
                       size='xl'
                       scrollable='true'
                    // centered
                       onShow={async () => {
                           if (modalType === 'confirm') {
                               let header = 'Your consent to receive communications';
                               let text = 'You will receive additional loan offers and other communications, including marketing and telemarketing communications, from marketing partners via emails, telephone calls, text messages, and SMS on the landline or mobile telephone number that you provided, even if you are on a Federal or State Do-Not-Call registry. The calls, text messages, and SMS messages may be generated using an auto-dialer or may employ an artificial or prerecorded voice. Standard message and data rates may apply to text or SMS communications.';
                               setModalContent({header, text});
                           } else {
                               setModalLoading(true);
                               const staticPage = await fetch(`${settings.tunnelUrl}/api/articles/staticPages/?website__slug=${settings.website}&tags__name__icontains=${modalType}&category__name__icontains=static`, {
                                   headers: {
                                       'Authorization': `${settings.rootToken}`
                                   }
                               });
                               let staticPageJson = await staticPage.json();

                               let header = replaceTokens(staticPageJson.results[0].header, {});
                               let text = replaceTokens(staticPageJson.results[0].text, {});
                               setModalContent({header, text});
                               setModalLoading(false);
                           }
                       }}
                >
                    <Modal.Header closeButton >
                        {modalContent.header ? <h2>{modalContent.header}</h2> : ''}
                    </Modal.Header>
                    <Modal.Body>{modalLoading
                        ? <div className='spinner-wrapper'><Spinner animation="border" variant="dark" size={'lg'}/></div>
                        : <div dangerouslySetInnerHTML={{
                            __html: modalContent.text
                        }}></div>
                    }</Modal.Body>
                </Modal>

            </div>
        )}

    </Formik>
};

export default MainForm;
