<?php
    
    add_action('wp_trash_post', 'create_custom_sitemap', 10, 1);
    add_action('wp_insert_post', 'create_custom_sitemap', 10, 1);
    
    /*
     * AJAX listener
     */
    function generate_sitemap()
    {
        $sitemap_type = $_POST['sitemap_type'];
        if ( ! isset($sitemap_type)) wp_die();
        switch ($sitemap_type) {
            case 'services':
            case 'regions':
                create_custom_sitemap(false);
                break;
            case 'cities':
                generate_cities_sitemap();
                break;
            case 'companies':
                generate_companies_sitemap();
                break;
            case 'kvg':
                generate_kvg_sitemap();
                break;
            default :
                wp_die();
        }
    }
    
    function generate_services_sitemap($add_link_type = null)
    {
        $home_url = home_url('/');
        $services = get_all_services();
        $output   = array();
        foreach ($services as $service) {
            if ( ! isset($add_link_type)) $output[] = $home_url . $service->alias . '/';
            else {
                $output[] = array(
                    'url'  => $home_url . $service->alias . '/',
                    'type' => 'service'
                );
            }
        }
        
        return $output;
    }
    
    function generate_regions_sitemap($add_link_type = null)
    {
        $home_url = home_url('/');
        $regions  = get_regions();
        $services = get_all_services();
        $output   = array();
        foreach ($services as $service) {
            foreach ($regions as $region) {
                if ($region->services == $service->id) {
                    if ( ! isset($add_link_type)) $output[] = $home_url . $region->alias . '/';
                    else {
                        $output[] = array(
                            'url'  => $home_url . $region->alias . '/',
                            'type' => 'region'
                        );
                    }
                }
            }
        }
        
        return $output;
    }
    
    function generate_cities_sitemap($add_link_type = null, $return_as_array = null)
    {
        global $wpdb;
        $cities_table     = DC_CITIES;
        $services_table   = DC_SERVICES;
        $regions_table    = DC_REGIONS;
        $plugin_options   = get_option('dc_option');
        $population_limit = isset($plugin_options['dc_population_limit']) ? (int)$plugin_options['dc_population_limit'] : 10000;
        $home_url         = home_url('/');
        
        $cities_query = 'SELECT CONCAT(c.region_alias, "/", c.alias, "/") AS alias FROM ' . $cities_table . ' AS c
                        INNER JOIN ' . $regions_table . ' as r
                        ON c.region_id=r.id
                        INNER JOIN ' . $services_table . ' AS s
                        ON s.id=r.services
                        WHERE c.population>=%d
                        ORDER BY c.region_alias, c.alias';
        
        $cities = $wpdb->get_results($wpdb->prepare($cities_query, $population_limit));
        $output = array();
        foreach ($cities as $city) {
            if ( ! (isset($add_link_type))) $output[] = $home_url . $city->alias;
            else {
                $output[] = array(
                    'url'  => $home_url . $city->alias,
                    'type' => 'city'
                );
            }
        }
        if ( ! $return_as_array) create_xml_sitemap($output, 'cities.xml', count($output), false);
        else return $output;
        
        return false;
    }
    
    function generate_companies_sitemap($add_link_type = null, $return_as_array = null)
    {
        $home_url  = home_url('/');
        $companies = get_companies();
        $output    = array();
        foreach ($companies as $company) {
            if ( ! (isset($add_link_type))) $output[] = $home_url . $company->alias . "/";
            else {
                $output[] = array(
                    'url'  => $home_url . $company->alias . "/",
                    'type' => 'company'
                );
            }
        }
        if ( ! $return_as_array) create_xml_sitemap($output, 'companies.xml', count($output), false);
        else return $output;
        
        
        return false;
    }
    
    function generate_kvg_sitemap($add_link_type = null, $return_as_array = null)
    {
        global $wpdb;
        $services_table   = DC_SERVICES;
        $regions_table    = DC_REGIONS;
        $companies_table  = DC_COMPANIES;
        $addresses_table  = DC_ADDRESSES;
        $cities_table     = DC_CITIES;
        $plugin_options   = get_option('dc_option');
        $population_limit = isset($plugin_options['dc_population_limit']) ? (int)$plugin_options['dc_population_limit'] : 10000;
        
        $home_url = home_url('/');
        
        $kvg_query = 'SELECT DISTINCT res.alias FROM
                            (SELECT CONCAT(r.alias, "/", c.alias, "/", comp.alias, "/") AS alias FROM ' . $addresses_table . ' AS addr
                            INNER JOIN ' . $regions_table . ' AS r ON r.id=addr.region_id
                            INNER JOIN ' . $services_table . '  AS s ON s.id=r.services
                            INNER JOIN ' . $cities_table . ' AS c ON c.id=addr.city_id
                            INNER JOIN ' . $companies_table . ' AS comp ON comp.id=addr.company_id
                            WHERE c.population >= %d
                            ORDER BY r.alias, c.alias, comp.alias)
                            AS res ORDER BY res.alias ASC';
        
        $get_res = $wpdb->prepare($kvg_query, $population_limit);
        $kvgs    = $wpdb->get_results($get_res);
        $output  = array();
        foreach ($kvgs as $kvg) {
            if ( ! (isset($add_link_type))) $output[] = $home_url . $kvg->alias;
            else {
                $output[] = array(
                    'url'  => $home_url . $kvg->alias,
                    'type' => 'kvg'
                );
            }
        }
        
        if ( ! $return_as_array) create_xml_sitemap($output, 'cic.xml', count($output), false);
        else return $output;
        
        
        return false;
    }
    
    function create_txt_sitemap($text, $filename, $total = 0)
    {
        $path = ABSPATH . $filename;
        if (($h = fopen($path, "a")) !== false) {
            file_put_contents($path, '');
            fwrite($h, $text);
            fclose($h);
        } else die;
        echo 'Сгенерировано ссылок: <strong>' . $total . '</strong>';
        
        die;
    }
    
    function create_xml_sitemap($urls, $filename, $total = 0, $silently = true)
    {
        if ($total == 0) {
            echo 'Ссылок не найдено';
            
            return false;
        }
        $sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
        $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">';
        
        foreach ($urls as $url) $sitemap .= '<url><loc>' . $url . '</loc></url>';
        
        $sitemap .= '</urlset>';
        
        $fp = fopen(ABSPATH . $filename, 'w');
        fwrite($fp, $sitemap);
        fclose($fp);
        if ( ! $silently == true) echo 'Сгенерировано ссылок: <strong>' . $total . '</strong>';
    }
    
    function reject_content_page(): stdClass
    {
        
        $terms_page = array(
            'post_type'  => 'page',
            'meta_query' => array(
                array('key'     => 'reject_content',
                      'value'   => '1',
                      'compare' => '='
                ),)
        );
        $myposts    = get_posts($terms_page);
        $data       = new stdClass();
        foreach ($myposts as $post) {
            setup_postdata($post);
            $data->id      = $post->ID;
            $data->content = $post->post_content;
        }
        wp_reset_postdata();
        
        return $data;
    }
    
    function apply_online_page(): stdClass
    {
        $terms_page = array(
            'post_type'  => 'page',
            'meta_query' => array(
                array('key'     => 'apply_online',
                      'value'   => '1',
                      'compare' => '='
                ),)
        );
        $myposts    = get_posts($terms_page);
        $data       = new stdClass();
        
        foreach ($myposts as $post) {
            setup_postdata($post);
            $data->id  = $post->ID;
            $data->url = $post->post_name . '/';
        }
        wp_reset_postdata();
        
        return $data;
    }
    
    function wp_sitemap_items($add_link_type = null)
    {
        $apply_form_page_id     = apply_online_page();
        $reject_content_page_id = reject_content_page();
        $postsForSitemap        = get_posts(array(
            'numberposts' => -1,
            'orderby'     => 'modified',
            'post_type'   => array('post', 'page'),
            'order'       => 'DESC',
            'exclude'     => array($apply_form_page_id->id, $reject_content_page_id->id)
        ));
        $sitemap                = array();
        foreach ($postsForSitemap as $post) {
            setup_postdata($post);
            if ( ! isset($add_link_type)) $sitemap[] = get_permalink($post->ID);
            else {
                $sitemap[] = array(
                    'url'  => get_permalink($post->ID),
                    'type' => 'wp'
                );
            }
        }
        
        return $sitemap;
    }
    
    function create_custom_sitemap($silently = true)
    {
        $wp_items = wp_sitemap_items();
        $services = generate_services_sitemap();
        $regions  = generate_regions_sitemap();
        $links    = array_merge($wp_items, $services, $regions);
        
        create_xml_sitemap($links, 'sitemap.xml', count($links), $silently);
    }