<?php
    defined('ABSPATH') or die('');
    
    /*
     * Place shortcode in the Title tag
     */
    
    add_filter('pre_get_document_title', 'processing_shortcodes_in_title_tag', 20); // очередь после Yoast SEO
    
    function processing_shortcodes_in_title_tag($title)
    {
        global $post;
        if ( ! isset($post->is_virtual)) return $title; // возвращаем родной тайтл
        
        return do_shortcode($post->post_title);
    }
    
    /*
     * hook menu and title replace by H1
     */
    
    function replace_the_title_with_seo_h1($title, $id = null)
    {
        global $post;
        $post = get_post($id);
        if ($post instanceof WP_Post && isset($post->is_virtual)) {
            $new_title = $post->seo_h1;
            if ( ! empty($new_title)) {
                return $new_title;
            }
        }
        
        return $title;
    }
    
    add_filter('the_title', 'do_shortcode', 15);
    add_filter('single_post_title', 'do_shortcode', 15);
    add_filter('wp_title', 'processing_shortcodes_in_title_tag', 15);
    add_filter('the_title', 'replace_the_title_with_seo_h1', 10, 2);
    
    /*
     * Add shortcode in description meta tags
     */
    
    function add_description_tags($content)
    {
        global $post;
        if (isset($post->seo_description)) { ?>
			<meta name="description" content="<?php echo do_shortcode($post->seo_description); ?>"/>
			<meta property="og:description" content="<?php echo do_shortcode($post->seo_description); ?>"/>
        <?php }
        
        return $content;
    }
    
    add_filter('wp_head', 'add_description_tags', 10);
    
    /*
     * Add canonical tag
     */
    
    function add_canonical_tag($content)
    {
        global $post;
        $is_virtual = (isset($post->is_virtual)) ? true : null;
        if ( ! $is_virtual) return $content;
        $home_url = home_url('/');
        switch ($post->post_format) {
            case 'service':
                $canonical = $home_url . $post->service->alias;
                break;
            case 'region':
                $canonical = $home_url . $post->region->alias;
                break;
            case 'city':
                $canonical = $home_url . $post->city->region->alias . '/' . $post->city->alias;
                break;
            case 'company':
                $canonical = $home_url . $post->region_alias . '/' . $post->city->alias . '/' . $post->company->alias;
                break;
            case 'parent-company':
                $canonical = $home_url . $post->region_alias . $post->company->alias;
                break;
            default:
                break;
        }
        $canonical = $canonical . '/';
        ?>
		<link rel="canonical" href="<?php echo $canonical; ?>"/>
        <?php
        return $content;
    }
    
    add_filter('wp_head', 'add_canonical_tag', 10);
    
    function remove_title_filter_nav_menu($nav_menu)
    {
        remove_filter('the_title', 'replace_the_title_with_seo_h1', 10);
        
        return $nav_menu;
    }
    
    add_filter('pre_wp_nav_menu', 'remove_title_filter_nav_menu', 10, 2);
    function add_title_filter_non_menu($items)
    {
        add_filter('the_title', 'replace_the_title_with_seo_h1', 10, 2);
        
        return $items;
    }
    
    add_filter('wp_nav_menu_items', 'add_title_filter_non_menu', 10, 2);
    
    /*
     * [service] shortcode
     */
    
    add_shortcode('service', 'service_shortcode');
    function service_shortcode($atts)
    {
        global $wp_query;
        global $post;
        
        $plugin_options    = get_option('dc_option');
        $installation_type = isset($plugin_options['dc_installation_type']) ? $plugin_options['dc_installation_type'] : null;
        
        if ( ! isset($wp_query->query['category_name']) && $installation_type == 2) {
            return false;
        }
        
        if (isset($post->service) && is_object($post->service)) {
            $service = $post->service;
        } // страница сервиса
		elseif (isset($post->region->service) && is_object($post->region)) {
            $service = $post->region->service['service'];
        } // страница региона
		elseif (isset($post->city) && is_object($post->city)) {
            $service = $post->city->service['service'];
        } // страница города
        else {
            return false;
        }
        
        (is_array($atts)) ? $last_at = end($atts) : $last_at = null;
        
        (isset($atts[0])) ? $qry_att = $atts[0] : $qry_att = 'service_name';
        $atts = shortcode_atts([
            'service_name'    => $service->service_name,
            'plural'          => $service->plural,
            'syn_1'           => $service->syn_1,
            'syn_2'           => $service->syn_2,
            'syn_3'           => $service->syn_3,
            'content'         => $service->content,
            'alias'           => $service->alias,
            'description'     => $service->description,
            'title'           => $service->title,
            'seo_h1'          => $service->seo_h1,
            'seo_description' => $service->seo_description,
            'seo_excerpt'     => $service->seo_excerpt
        ], $atts);
        
        foreach ($atts as $key => $val) {
            if ($key == $qry_att) {
                return case_shortcode($last_at, $val);
            }
        }
        
        return false;
    }
    
    /*
     * [button] APPLY NOW Blue Button render
     */
    add_shortcode('button', 'apply_now_button');
    function apply_now_button()
    {
        return '<a class="btn btn-lg apply_now green shadowed w100 via_shortcode" href="/apply_online/" title="Apply now">Apply now</a>';
    }
    
    /*
     * [menu] shortcode
     */
    
    function print_menu_shortcode($atts)
    {
        extract(
            shortcode_atts(
                array(
                    'name'  => '',
                    'class' => ''
                ), $atts));
        ( ! isset($name)) ? $name = 'mainmenu' : $name;
        ( ! isset($class)) ? $class = 'custom_menu' : $class;
        
        wp_nav_menu(array(
            //'theme_location' => 'menu-1',
            'menu_id' => 'services_menu',
        ));
        
        return wp_nav_menu(array('menu' => $name, 'menu_class' => $class, 'echo' => false));
    }
    
    add_shortcode('menu', 'print_menu_shortcode');
    
    /*
     * Region
     */
    
    add_shortcode('region', 'region_shortcode');
    function region_shortcode($atts)
    {
        global $post;
        if ( ! isset($post->region)) {
            return false;
        } // не страница региона
        
        $region = $post->region;
        
        if ( ! is_object($region) && isset($post->city)) { // страница города
            $region = $post->city->region;
        } else {
            $region = $post->region;
        } // страница региона
        
        $str_function = (is_array($atts)) ? end($atts) : null;
        $qry_att      = (isset($atts[0])) ? $atts[0] : 'region_name';
        
        $atts = shortcode_atts([
            'region_name'     => $region->region_name,
            'region_code'     => $region->region_code,
            'content'         => $region->content,
            'alias'           => $region->alias,
            'description'     => $region->description,
            'title'           => $region->title,
            'seo_h1'          => $region->seo_h1,
            'seo_description' => $region->seo_description,
            'seo_excerpt'     => $region->seo_excerpt
        ], $atts);
        
        $str_functions = array('uppercase', 'lowercase', 'ucwords');
        
        foreach ($atts as $key => $val) {
            if ($key == $qry_att || in_array($str_function, $str_functions)) {
                return case_shortcode($str_function, $val);
            }
        }
        
        return false;
    }
    
    /*
     * City
     */
    
    add_shortcode('city', 'city_shortcode');
    function city_shortcode($atts)
    {
        global $post;
        if ( ! isset($post->city)) {
            return false;
        } // не страница города
        $city         = $post->city;
        $str_function = (is_array($atts)) ? end($atts) : null;
        $qry_att      = (isset($atts[0])) ? $atts[0] : 'city_name';
        if ( ! isset($city->description)) {
            $city->description = '';
        }
        
        $atts = shortcode_atts([
            'city_name'       => $city->city_name,
            'content'         => $city->content,
            'alias'           => $city->alias,
            'description'     => $city->description,
            'title'           => $city->title,
            'seo_h1'          => $city->seo_h1,
            'seo_description' => $city->seo_description,
            'seo_excerpt'     => $city->seo_excerpt,
            'region'          => $city->region->region_name
        
        ], $atts);
        
        $str_functions = array('uppercase', 'lowercase', 'ucwords');
        
        foreach ($atts as $key => $val) {
            if ($key == $qry_att || in_array($str_function, $str_functions)) {
                return case_shortcode($str_function, $val);
            }
        }
        
        return false;
    }
    
    /*
     * Service City Link
     *
     * Выводит ссылку на страницу города со страницы КВГ
     *  [service_city_link title="Compare our services from other companies in %city%, %region_code%"]
     * %city%, %region%, %region_code%, %service%
     *
     */
    
    add_shortcode('service_city_link', 'service_city_link_shortcode');
    
    function service_city_link_shortcode($atts, $content = null)
    {
        global $post;
        if ($post->post_format <> 'company') {
            return false;
        } // не страница КВГ
        
        $home_url       = home_url("/");
        $region_obj     = $post->city->region;
        $region         = $region_obj->region_name; // %region%
        $region_code    = $region_obj->region_code; // %region_code%
        $region_alias   = $region_obj->alias;
        $city_obj       = $post->city;
        $city           = $city_obj->city_name; // %city%
        $city_alias     = $city_obj->alias;
        $service_obj    = $post->city->service['service'];
        $service        = $service_obj->service_name; // %service%
        $service_plural = $service_obj->plural; // %service_plural%
        $content        = (isset($content)) ? $content : '';
        $type           = (isset($atts['type'])) ? 1 : 0;
        $link_title     = (isset($atts['link_title'])) ? ' title="' . $atts['link_title'] . '"' : '';
        $target         = (isset($atts['target'])) ? ' target="' . $atts['target'] . '"' : '';
        switch ($type) {
            case 0:
            default:
                $link = '<h2>' . $content . '</h2><p><a class="service_city_link" href="' . $home_url . $region_alias . '/' . $city_alias . '/" ' . $target . $link_title . '>' . $service_plural . '</a></p>';
                break;
            
            case 1:
                $link = '<a class="service_city_link" href="' . $home_url . $region_alias . '/' . $city_alias . '/" ' . $target . $link_title . '>' . $content . '</a>';
                break;
        }
        
        $rules = array(
            '%service%'        => $service,
            '%service_plural%' => $service_plural,
            '%region%'         => $region,
            '%region_code%'    => $region_code,
            '%city%'           => $city
        );
        
        return strtr($link, $rules);
    }
    
    /*
     * Company
     */
    
    add_shortcode('company', 'company_shortcode');
    function company_shortcode($atts)
    {
        global $post;
        if ( ! isset($post->company)) return false; // не страница КВГ или родителя
        $company      = $post->company;
        $str_function = (is_array($atts)) ? end($atts) : null;
        $qry_att      = (isset($atts[0])) ? $atts[0] : 'company_name';
        
        if ( ! isset($company->description)) {
            $company->description = '';
        }
        $atts = shortcode_atts([
            'company_name'    => $company->company_name,
            'content'         => $company->content,
            'alias'           => $company->alias,
            'description'     => $company->description,
            'title'           => $company->title,
            'seo_h1'          => $company->seo_h1,
            'seo_description' => $company->seo_description,
            'seo_excerpt'     => $company->seo_excerpt,
        ], $atts);
        
        
        switch ($post->post_format) {
            case 'company':// КВГ
                $atts['city']   = $post->city->city_name;
                $atts['region'] = $post->city->region->region_name;
                break;
            case 'parent-company': // родитель
            default:
                $atts['city']   = null;
                $atts['region'] = null;
                break;
        }
        
        $str_functions = array('uppercase', 'lowercase', 'ucwords');
        foreach ($atts as $key => $val) {
            if ($key == $qry_att || in_array($str_function, $str_functions)) {
                return case_shortcode($str_function, $val);
            }
        }
        
        
        return false;
    }
    
    /*
     * Sitename
     */
    
    add_shortcode('sitename', 'sitename_shortcode');
    function sitename_shortcode($atts)
    {
        $sitename    = get_bloginfo('name', 'display');
        $description = get_bloginfo('description', 'display');
        
        $str_function = (is_array($atts)) ? end($atts) : null;
        
        $atts = shortcode_atts([
            'sitename'    => $sitename,
            'description' => $description,
        ], $atts);
        
        $str_functions = array('uppercase', 'lowercase', 'ucwords');
        
        $qry_att = (isset($atts[0])) ? $atts[0] : 'sitename';
        foreach ($atts as $key => $val) {
            if ($key == $qry_att || in_array($str_function, $str_functions)) {
                return case_shortcode($str_function, $val);
            }
        }
        
        return false;
    }
    
    /*
     * Cases
     */
    
    function case_shortcode($str_function, $string)
    {
        if ($str_function) {
            switch ($str_function) {
                case 'lowercase':
                    return strtolower($string);
                
                case 'uppercase':
                    return strtoupper($string);
                
                case 'uswords':
                    return ucwords($string);
                
                default:
                    return $string;
            }
        } else {
            return $string;
        }
    }
    
    /*
     * Regions menu
     */
    
    add_shortcode('regions_menu', 'regions_menu_shortcode');
    // [regions_menu class=states_list limit=25 showmore=1 showcode showcities=5]
    
    function regions_menu_shortcode($atts)
    {
        global $wpdb;
        global $post;
        
        $plugin_options = get_option('dc_option');
        
        $installation_type = isset($plugin_options['dc_installation_type']) ? $plugin_options['dc_installation_type'] : 2;
        
        $home_url      = home_url('/');
        $regions_table = DC_REGIONS;
        
        if (isset($post->service) && is_object($post->service)) { // service page
            $service_alias = $post->service->alias;
            $service_name  = $post->service->service_name;
            $service_id    = $post->service->id;
        } elseif (isset($post->region) && is_object($post->region)) { // region page
            $service_alias = $post->region->service['service']->alias;
            $service_name  = $post->region->service['service']->service_name;
            $service_id    = $post->region->service['service']->id;
        } elseif (isset($post->city) && is_object($post->city)) { // city page
            $service_alias = $post->city->service['service']->alias;
            $service_name  = $post->city->service['service']->service_name;
            $service_id    = $post->city->service['service']->id;
        }
        
        $atts = shortcode_atts(array(
            'id'            => 'regions_menu',
            'class'         => 'states_list',
            'container'     => 'ul',
            'items_wrap'    => 'li',
            'limit'         => null,
            'orderby'       => 'region_name',
            'service_id'    => null,
            'service_check' => null,
            'target'        => null,
            'showmore'      => null,
            'showcodes'     => null,
            'showcities'    => null,
            'title'         => null,
        
        ), $atts);
        
        if (isset($atts['service_id'])) {
            if ($installation_type == 1) {
                $service       = get_single_service();
                $service_name  = $service->plural;
                $service_alias = $service->alias;
                $service_id    = $service->id;
            } elseif ($installation_type == 2) {
                $service       = get_service_by_id((int)$atts['service_id']);
                $service_alias = $service->alias;
                $service_name  = $service->plural;
            }
        }
        if ( ! isset($service_id)) {
            $service      = get_single_service();
            $service_id   = $service->id;
            $service_name = $service->plural;
        }
        
        $service_alias .= ($installation_type == 2) ? '/' : '';
        
        //(isset($atts['limit'])) ? $limit = ' LIMIT '.(string) trim(esc_sql($atts['limit'])) : $limit = '';
        (isset($atts['orderby'])) ? $orderby = ' ORDER BY ' . (string)trim(esc_sql($atts['orderby'])) : $orderby = '';
        (isset($atts['target'])) ? $target = 'target="' . (string)trim(esc_sql($atts['target'])) . '"' : $target = '';
        
        if (isset($atts['showmore'])) {
            $showmore = '<a href="#" id="showmore_' . $service_id . '">' . $atts['showmore'] . '</a>';
        } else {
            $showmore = '';
        }
        
        $query   = $wpdb->prepare("SELECT * FROM $regions_table WHERE `services` IN (%s) $orderby", $service_id);
        $regions = $wpdb->get_results($query);
        
        $menu = '<div id="regions_menu_container" class="' . $atts['class'] . '">';
        if (isset($atts['title'])) $menu .= '<div class="regions_menu_title"><h2>' . str_replace('%service%', $service_name, $atts['title']) . '</h2></div>';
        $menu   .= '<' . $atts['container'] . ' id="' . $atts['id'] . '" class="' . $atts['class'] . '">';
        $cities = (isset($atts['showcities'])) ? top_cities($atts['showcities']) : null;
        
        foreach ($regions as $region) {
            $menu .= '<' . $atts['items_wrap'] . ' id="region_' . $region->id . '"><div class="cont">';
            $menu .= ($installation_type == 1) ? '<a ' . $target . ' href="' . $home_url . $region->alias . '/" title="' . $service_name . ' in ' . $region->region_name . '">' : '<a ' . $target . ' href="' . $home_url . $service_alias . $region->alias . '/" title="' . $service_name . ' in ' . $region->region_name . '">';
            $menu .= $region->region_name;
            if (isset($atts['showcodes'])) {
                $menu .= '<span class="reg_code">(' . $region->region_code . ')</span>';
            }
            $menu .= '</a>';
            if (isset($cities)) {
                foreach ($cities as $city) {
                    if ($city['region_alias'] == $region->alias) {
                        $menu .= '<span class="top_city"><a ' . $target . ' href="' . $home_url . $region->alias . '/' . $city['alias'] . '" title="' . $service_name . ' in ' . $city['city_name'] . ', ' . $region->region_name . '">' . $city['city_name'] . '</a></span>';
                    }
                }
            }
            $menu .= '</div></' . $atts['items_wrap'] . '>';
        }
        
        $menu .= '</' . $atts['container'] . '></div>';
        $menu .= $showmore;
        
        return $menu;
    }
    
    /*
     * Cities menu
     */
    
    add_shortcode('cities_menu', 'cities_menu_shortcode');
    
    function cities_menu_shortcode($atts)
    {
        global $wpdb;
        global $post;
        $plugin_options    = get_option('dc_option');
        $population_limit  = isset($plugin_options['dc_population_limit']) ? (int)$plugin_options['dc_population_limit'] : 40000;
        $installation_type = isset($plugin_options['dc_installation_type']) ? $plugin_options['dc_installation_type'] : null;
        
        $home_url     = home_url('/');
        $cities_table = DC_CITIES;
        
        if (isset($post->service) && is_object($post->service)) { // service page
            $page_type     = 'service';
            $service_alias = $post->service->alias;
            $service_name  = $post->service->service_name;
        } elseif (isset($post->region) && is_object($post->region)) { // region page
            $page_type     = 'region';
            $service_alias = $post->region->service['service']->alias;
            $service_name  = $post->region->service['service']->service_name;
        } elseif (isset($post->city) && is_object($post->city)) { // city page
            $page_type     = 'city';
            $service_alias = $post->city->service['service']->alias;
            $service_name  = $post->city->service['service']->service_name;
        } else {
            return false;
        }
        
        $region = (isset($atts['region'])) ? strtolower(trim(esc_sql($atts['region']))) : null;
        
        switch ($page_type) {
            case 'service':
                if ( ! isset($region)) {
                    return false;
                } // забыли указать регион для страницы сервиса
                $region_alias = $region;
                break;
            
            case 'region':
                $region_alias = ( ! isset($region)) ? strtolower($post->region->alias) : $region;
                break;
            
            case 'city':
                $region_alias = ( ! isset($region)) ? strtolower($post->city->region_alias) : $region;
                break;
            
            default:
                return false;
        }
        
        $atts = shortcode_atts(array(
            'id'         => 'cities_menu',
            'class'      => 'cities_list',
            'container'  => 'ul',
            'items_wrap' => 'li',
            'limit'      => null,
            'region'     => null,
            'orderby'    => 'city_name',
            'showsearch' => null,
            'target'     => null,
            'showmore'   => null
        ), $atts);
        
        if ($installation_type == 1) {
            $service       = get_single_service();
            $service_name  = $service->service_name;
            $service_alias = '';
        }
        
        $service_alias .= ($installation_type == 2) ? '/' : '';
        
        (isset($atts['limit'])) ? $limit = ' LIMIT ' . (string)trim(esc_sql($atts['limit'])) : $limit = ' ';
        (isset($atts['orderby'])) ? $orderby = ' ORDER BY ' . (string)trim(esc_sql($atts['orderby'])) : $orderby = '';
        (isset($atts['target'])) ? $target = 'target="' . (string)trim(esc_sql($atts['target'])) . '"' : $target = '';
        if (isset($atts['showmore'])) {
            $showmore = '<div class="list_control">';
            $showmore .= '<a href="#" class="expand_list">' . $atts['showmore'] . ' <i class="fa fa-chevron-down"></i></a>';
            $showmore .= '<a href="#" class="collapse_list hidden"><i class="fa fa-chevron-up"></i> collapse</a>';
            $showmore .= '</div>';
        } else {
            $showmore = '';
        }
        
        $query  = "SELECT * FROM $cities_table WHERE region_alias='$region_alias' $orderby $limit";
        $cities = $wpdb->get_results($query);
        
        $menu = '<div class="cities_container_' . $atts['class'] . '">';
        if (isset($atts['showsearch'])) {
            $menu .= '<input pattern="[0-9]" maxlength="5" class="form-control-lg zipcode" type="text" placeholder="Search by ZIP">';
            $menu .= '<input type="hidden" name="service_id" value="2" class="service_id">';
            $menu .= '<div id="search_results" class="ajax_zip_results"></div>';
        }
        $menu .= '<' . $atts['container'] . ' id="' . $atts['id'] . '" class="' . $atts['class'] . '">';
        foreach ($cities as $city) {
            $large = ($city->population > $population_limit) ? ' class="large"' : '';
            $menu  .= '<' . $atts['items_wrap'] . ' id="city_' . $city->id . '"' . $large . '>';
            $menu  .= ($installation_type == 1) ? '<a ' . $target . ' href="' . $home_url . $region_alias . '/' . $city->alias . '/" title="' . $service_name . ' in ' . $city->city_name . '">' : '<a ' . $target . ' href="' . $home_url . $service_alias . $region_alias . '/' . $city->alias . '/" title="' . $service_name . ' in ' . $city->city_name . '">';
            $menu  .= $city->city_name;
            $menu  .= '</a></' . $atts['items_wrap'] . '>';
        }
        $menu .= '</' . $atts['container'] . '>';
        $menu .= $showmore;
        $menu .= '</div>';
        
        return $menu;
    }
    
    function draw_zip_search_results($cities = null)
    {
        if ( ! isset($cities) || ! is_array($cities)) {
            wp_die();
        }
        
        $plugin_options   = get_option('dc_option');
        $population_limit = ($plugin_options['dc_population_limit'] > 0) ? $plugin_options['dc_population_limit'] : 0;
        $home_url         = home_url('/');
        $not_serviced_msg = ( ! isset($not_serviced_msg)) ? '<li class="disabled_msg"><span>Not serviced: </span></li>' : '';
        $output           = '<ul class="ajax_search_result">';
        
        foreach ($cities as $city) {
            
            if ($city['population'] >= $population_limit) $output .= '<li>';
            else {
                $output           .= $not_serviced_msg . '<li class="disabled">';
                $not_serviced_msg = '';
            }
            
            $output .= ($city['population'] >= $population_limit) ? '<a href="' . $home_url . $city['region_alias'] . '/' . $city['alias'] . '/" title="' . $city->city_name . '">' . $city['city_name'] . '</a>' : $city['city_name']; // TODO: ссылки при мультисервисе
            $output .= '</li>';
        }
        $output .= '</ul>';
        echo $output;
    }
    
    /**
     * @param int $population
     * @param int $limit
     *
     * @return array
     */
    function top_cities($limit = 5)
    {
        global $wpdb;
        
        $val              = get_option('dc_option');
        $population_limit = isset($val['dc_population_limit']) ? (int)$val['dc_population_limit'] : 40000;
        
        $cities_table = DC_CITIES;
        $host         = DB_HOST;
        $db           = DB_NAME;
        $user         = DB_USER;
        $pass         = DB_PASSWORD;
        $charset      = DB_CHARSET;
        
        $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
        $opt = [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ];
        
        $pdo = new PDO($dsn, $user, $pass, $opt);
        
        $cities_qry = "SELECT id, city_name, alias, region_alias FROM (SELECT id, city_name, alias, region_id, region_alias, population, @city_rank := IF(@current_state = region_id,@city_rank+1,1) AS city_rank, @current_state := region_id FROM $cities_table WHERE population > :population ORDER BY region_id, population DESC) AS top WHERE city_rank <= :limit";
        
        $stmt = $pdo->prepare($cities_qry);
        $stmt->execute(array(
            ':population' => $population_limit,
            ':limit'      => $limit
        ));
        
        return $stmt->fetchAll();
    }
    
    /* КВГ */
    
    add_shortcode('companies', 'companies_shortcode');
    add_shortcode('addresses', 'companies_shortcode');
    function companies_shortcode()
    {
        global $post, $wpdb;
        if ( ! isset($post->city)) return false; // не страница города
	    
        if (isset($post->company)) {
            $filter = 'AND c.id=%d ';
            $kvg    = (int)$post->company->id;
        } else {
            $filter = '';
            $kvg    = null;
        }
        
        $city    = $post->city;
        $city_id = (int)$city->id;
        
        $companies_table = DC_COMPANIES;
        $addresses_table = DC_ADDRESSES;
        $cities_table    = DC_CITIES;
        $regions_table   = DC_REGIONS;
        
        $current_service_id = (isset($post->city->service['service']->id)) ? (int)$post->city->service['service']->id : 0;
        
        $addresses = "SELECT
       a.id, a.company_id, a.region_id, a.address, a.phone, a.website, a.opened, a.days, a.alias, a.general_info,
       c.company_name, c.alias AS company_alias, ct.city_name, ct.alias AS city_alias, ct.region AS region, ct.region_alias AS region_alias
                    FROM $addresses_table AS a INNER JOIN $companies_table AS c
                    ON a.company_id = c.id
                    INNER JOIN $cities_table AS ct
                    ON a.city_id = ct.id
					INNER JOIN $regions_table AS r
					ON r.id=a.region_id
                    WHERE a.city_id=%d $filter
                   	AND r.services IN (%d)
                    ORDER BY c.company_name";
        
        $get_res = (isset($kvg)) ? $wpdb->prepare($addresses, $city_id, $kvg, $current_service_id) : $wpdb->prepare($addresses, $city_id, $current_service_id);
        
        $addresses = $wpdb->get_results($get_res, ARRAY_A);
        
        if (count($addresses) > 0) return ($post->post_format === 'company') ? draw_kvg_addresses_w_googlemap($addresses) : draw_city_kvgs_w_addresses_spoiler($addresses);
        
        return false;
    }
    
    function draw_city_kvgs_w_addresses_spoiler($addresses)
    {
        $home_url                     = home_url('/');
        $print_header                 = 1;
        $this_address_has_unique_desc = null;
        $company_general_info         = null;
        
        $output = '<div class="companies_list">';
        $output .= '<ul class="list-style-none">';
        
        for ($k = 0; $k < count($addresses); $k++) {
           /* if (strlen(esc_attr($addresses[$k]['general_info'])) > 10) {
                if ( ! isset($general_info)) {
                    $general_info[$addresses[$k]['company_id']][strlen($addresses[$k]['general_info'])] = esc_attr($addresses[$k]['general_info']);
                    $company_general_info                                                               = esc_attr($addresses[$k]['general_info']);
                    $this_address_has_unique_desc                                                       = true;
                } else {
                    if ( ! isset($general_info[$addresses[$k]['company_id']][strlen($addresses[$k]['general_info'])])) {
                        $general_info[$addresses[$k]['company_id']][strlen($addresses[$k]['general_info'])] = esc_attr($addresses[$k]['general_info']);
                        $company_general_info                                                               = esc_attr($addresses[$k]['general_info']);
                        $this_address_has_unique_desc                                                       = true;
                    } else {
                        $company_general_info         = null;
                        $this_address_has_unique_desc = false;
                    }
                }
            } else {
                $this_address_has_unique_desc = false;
            }
            */
            if ($print_header == 1) {
                $output       .= '<li class="header"><h3>' . $addresses[$k]['company_name'] . '</h3></li>'; // Название компании со ссылкой на страницу КВГ
                $print_header = 0;
            }
            if ($k==0 || isset($addresses[$k-1]['address']) && $addresses[$k-1]['address'] <> $addresses[$k]['address']) {
                $output .= '<li class="city">' . $addresses[$k]['address'] . ', Tel.: ' . $addresses[$k]['phone'];
            }
            /*if ($this_address_has_unique_desc) {
                $output .= '<span class="general_info_toggler" data-address="' . $addresses[$k]['id'] . '"></span>';
                $output .= '<div class="general_info hidden" data-address="' . $addresses[$k]['id'] . '">' . $company_general_info . '</div>';
            }*/
            
            $output .= '</li>';
            
            if (isset($addresses[$k + 1])) {
                if ($addresses[$k + 1]['company_id'] != $addresses[$k]['company_id']) {
                    $print_header = 1;
                }
            }
        }
        
        
        $output .= '</ul></div>';
        
        return $output;
        
    }
    
    function draw_kvg_addresses_w_googlemap($addresses)
    {
        $home_url             = home_url('/');
        $iter                 = 0;
        $company_general_info = null;
        
        $output = '<div class="companies_list">';
        $output .= '<ul class="addresses_list list-style-none">';
        
        foreach ($addresses as $addr) {
            if (strlen(esc_attr($addr['general_info'])) > 10) {
                if ( ! isset($general_info)) {
                    $general_info[$addr['company_id']][strlen($addr['general_info'])] = esc_attr($addr['general_info']);
                    $company_general_info                                             = esc_attr($addr['general_info']);
                } else {
                    if ( ! isset($general_info[$addr['company_id']][strlen($addr['general_info'])])) {
                        $general_info[$addr['company_id']][strlen($addr['general_info'])] = esc_attr($addr['general_info']);
                        $company_general_info                                             = esc_attr($addr['general_info']);
                    } else {
                        $company_general_info = null;
                    }
                }
            }
            
            $company_header = ($iter > 0 && $addresses[$iter]['company_id'] == $addresses[$iter - 1]['company_id']) ? 0 : 1;
            
            if ($company_header == 1) { // рисуем заголовок КВГ
                $output .= '<li class="header">';
                $output .= '<a class="company_page" href="' . $home_url . $addr["company_alias"] . '/">';
                $output .= $addr['company_name'];
                $output .= ' <i class="fa fa-info-circle"></i></a>';
                $output .= '</li>';
            }
            
            $output .= '<li class="company_address">';
            
            $output .= '<div class="mapouter"><div class="gmap_canvas"><iframe width="100%" height="100%" id="gmap_canvas" src="https://maps.google.com/maps?q=' . $addr['address'] . ', ' . $addr['city_name'] . ', ' . $addr['region'] . '&t=&z=15&ie=UTF8&iwloc=&output=embed" frameborder="0" scrolling="0" marginheight="0" marginwidth="0"></iframe></div></div>';
            
            $output .= '<div class="info"><p class="addr"><span><i class="fa fa-building"></i> Address:</span> ' . $addr['address'] . '</p>';
            $output .= '<p class="phone"><span><i class="fa fa-phone"></i> Phone:</span> ' . $addr['phone'] . '</p>';
            
            if ($addr['opened'] && $addr['days']) {
                $work_time = explode(',', $addr['opened']);
                $days_open = explode(',', $addr['days']);
                
                unset($work_time[(count($work_time) - 1)]);
                unset($days_open[(count($days_open) - 1)]);
                
                if (count($work_time) > 0) {
                    $output .= '<p class="opened"><span><i class="fa fa-clock-o"></i> Work Time:</span>';
                    $output .= '<ul class="work_time">';
                    $i      = 0;
                    foreach ($work_time as $time) {
                        $output .= '<li><span>' . $days_open[$i] . '</span> ' . $work_time[$i] . '</li>';
                        $i++;
                    }
                    $output .= "</ul></p>\r\n";
                }
                
                $work_time = null;
                $days_open = null;
            }
            $output .= '</div></li>';
            $iter++;
        }
        $output .= '</ul></div>';
        
        return $output;
    }
    
    add_shortcode('parent_regions', 'parent_regions');
    
    function parent_regions($atts)
    {
        global $post, $wpdb;
        if ($post->post_format !== 'parent-company') {
            return false;
        }
        $addresses_table = DC_ADDRESSES;
        $regions_table   = DC_REGIONS;
        $cities_table    = DC_CITIES;
        if ( ! isset($post->company->id)) {
            return false;
        }
        $company_id = (int)$post->company->id;
        
        $plugin_options    = get_option('dc_option');
        $population_limit  = isset($plugin_options['dc_population_limit']) ? (int)$plugin_options['dc_population_limit'] : 10000;
        $installation_type = ($plugin_options['dc_installation_type'] == 1) ? 1 : 2;
        $service           = ($installation_type == 1) ? get_single_service() : get_all_services(); // TODO: чек для мультисервиса
        
        
        $addresses = "SELECT reg.id AS region_id, ct.id AS city_id, reg.region_name, reg.alias AS region_alias, ct.city_name, ct.alias AS city_alias
						FROM $addresses_table AS a
						INNER JOIN $regions_table AS reg
						ON a.region_id=reg.id
						INNER JOIN $cities_table AS ct
						ON a.city_id=ct.id
						WHERE a.company_id=%d
						AND reg.services IN ($service->id)
						AND ct.population >= %d
						ORDER BY a.region_id, ct.city_name";
        $result    = $wpdb->get_results($wpdb->prepare($addresses, $company_id, $population_limit), ARRAY_A);
        
        if (count($result) > 0) {
            
            return draw_parent_addresses($result, $post->company->alias);
        }
        
        return false;
    }
    
    function draw_parent_addresses($addresses, $company_alias)
    {
        $home_url     = home_url('/');
        $print_header = 1;
        $cities_arr   = array();
        
        foreach ($addresses as $addr) {
            $cities_arr[$addr["city_id"]] = $addr;
        }
        
        $addresses   = array_values($cities_arr);
        $total_items = count($addresses);
        $output = '<div class="companies_list">';
        $output .= '<input pattern="[0-9]" maxlength="5" class="form-control-lg zipcode" type="text" placeholder="Search by ZIP">';
        $output .= '<input type="hidden" name="service_id" value="2" class="service_id">';
        $output .= '<div id="search_results" class="ajax_zip_results"></div>';
        $output .= '<ul class="addresses_list list-style-none parent_company">';
        for ($k = 0; $k < $total_items; $k++) {
            if ($print_header == 1) {
                $output       .= '<li class="header" data-region="' . $addresses[$k]['region_id'] . '"><h4>' . $addresses[$k]['region_name'] . '</h4><i class="fa fa-angle-down"></i></li>'; // рисуем ШТАТ
                $print_header = 0;
            }
            $output .= '<li class="city"  data-region="' . $addresses[$k]['region_id'] . '"><a href="' . $home_url . $addresses[$k]["region_alias"] . '/' . $addresses[$k]["city_alias"] . '/' . $company_alias . '/">' . $addresses[$k]['city_name'] . '</a></li>';
            
            if (isset($addresses[$k + 1])) {
                if ($addresses[$k + 1]['region_id'] != $addresses[$k]['region_id']) {
                    $print_header = 1;
                }
            }
            
        }
        $output .= '</ul></div>';
        
        return $output;
        
    }
    
    /*
     * Top N US Cities divided by 2 chunks
     * [top_cities showcodes=1 class=top_cities_list showsearch="Find Payday Loan company places nearby to get instant cash" title="Top cities in “Payday Loans Near Me” search query"]
     */
    
    add_shortcode('top_cities', 'draw_top_cities_list');
    
    function draw_top_cities_list($atts)
    {
        global $wpdb, $post;
        $cities_table  = DC_CITIES;
        $regions_table = DC_REGIONS;
        
        $plugin_options    = get_option('dc_option');
        $installation_type = ($plugin_options['dc_installation_type'] == 1) ? 1 : 2;
        $population_limit  = isset($plugin_options['dc_population_limit']) ? (int)$plugin_options['dc_population_limit'] : 10000;
        $home_url          = home_url('/');
        $service           = ($installation_type == 1) ? get_single_service() : get_all_services();
        
        $atts = shortcode_atts(array(
            'class'      => 'top_cities_list',
            'container'  => 'ul',
            'items_wrap' => 'li',
            'service_id' => null,
            'showcodes'  => null,
            'showsearch' => null,
            'title'      => null,
            'total'      => null,
            'target'     => null
        ), $atts);
        
        $limit = (isset($atts['total'])) ? (int)$atts['total'] : 80;
        
        if (isset($post->post_format)) {
            $format = $post->post_format;
            switch ($format) {
                case 'region':
                    $region_id          = $post->region->id;
                    $atts['title']      = str_replace('%service%', $post->region->service['service']->service_name, $atts['title']);
                    $atts['showsearch'] = str_replace('%service%', $post->region->service['service']->service_name, $atts['showsearch']);
                    $atts['title']      = str_replace('%region%', $post->region->region_name, $atts['title']);
                    $atts['showsearch'] = str_replace('%region%', $post->region->region_name, $atts['showsearch']);
                    $city_where         = null;
                    break;
                
                case 'city':
                    $region_id          = $post->city->region_id;
                    $city_id            = $post->city->id;
                    $atts['title']      = str_replace('%service%', $post->city->service['service']->service_name, $atts['title']);
                    $atts['showsearch'] = str_replace('%service%', $post->city->service['service']->service_name, $atts['showsearch']);
                    $atts['title']      = str_replace('%region%', $post->region, $atts['title']);
                    $atts['showsearch'] = str_replace('%region%', $post->region, $atts['showsearch']);
                    $city_where         = " AND c.id <>" . $city_id;
                    $shortversion       = true;
                    $limit              = $limit / 2;
                    break;
                
                default:
                    $region_id = '';
                    break;
            }
            
            $where             = " WHERE c.region_id=$region_id";
            $where             .= " AND c.population >= $population_limit";
            $where             .= $city_where;
            $atts['showcodes'] = null;
        } else $where = '';
        
        $target     = (isset($atts['target'])) ? $atts['target'] : "";
        $cities_qry = "SELECT c.id AS id, c.alias AS alias, c.city_name, c.region, c.region_alias, c.region_code FROM $cities_table AS c INNER JOIN $regions_table AS r ON c.region_id=r.id $where AND r.services IN ($service->id) ORDER BY c.population DESC LIMIT %d";
        $cities     = $wpdb->prepare($cities_qry, $limit);
        $cities     = $wpdb->get_results($cities);
        
        // OUTPUT
        $menu = '<div class="top_cities_container_' . $atts['class'] . '">';
        $menu .= (isset($atts['title'])) ? '<div class="top_cities_title">' . $atts['title'] . '</div>' : '';
        
        if (isset($atts['showsearch'])) {
            $menu .= '<div class="search_zip"><label for="zipcode">' . $atts["showsearch"] . '</label>';
            $menu .= '<input id="zipcode" pattern="[0-9]" maxlength="5" class="zipcode form-control form-control-lg" type="text" placeholder="Search by ZIP" name="zipcode">';
            $menu .= '<input type="hidden" name="service_id" value="2" class="service_id">';
            $menu .= '<div id="search_results" class="ajax_zip_results"></div></div>';
        }
        
        $menu .= '<' . $atts['container'] . ' class="' . $atts['class'] . '">';
        $i    = 0;
        foreach ($cities as $city) {
            if (($i == $limit / 2) && ! isset($shortversion)) {
                //$menu .= '</' . $atts['container'] . '><div id="top_cities_showmore"><span>Show more</span><i class="fa fa-angle-down"></i></div><' . $atts['container'] . ' class="top50plus hidden">';
            }
            $menu .= '<' . $atts['items_wrap'] . ' id="city_' . $city->id . '">';
            $menu .= ($installation_type == 1) ? '<a ' . $target . ' href="' . $home_url . $city->region_alias . '/' . $city->alias . '/" title="' . $service->service_name . ' in ' . $city->city_name . ', '.$city->region.'">' : '<a ' . $target . ' href="' . $home_url . $service->alias . $city->region_alias . '/' . $city->alias . '/" title="' . $service->service_name . ' in ' . $city->city_name . '">';
            $menu .= $city->city_name;
            $menu .= (isset($atts['showcodes'])) ? ', ' . $city->region_code : '';
            $menu .= '</a></' . $atts['items_wrap'] . '>';
            $i++;
        }
        
        $menu .= '</' . $atts['container'] . '>';
        //$menu .= ( ! isset($shortversion)) ? '<div id="top_cities_showless" class="hidden"><span>Show less</span><i class="fa fa-angle-up"></i></div>' : '';
        $menu .= '</div>';
        
        return $menu;
    }
    
    add_shortcode('related_kvg', 'related_kvg');
    function related_kvg($atts): string
    {
        global $post, $wpdb;
        if ($post->post_format !== 'company') return false; // не страница КВГ
        
        $atts = shortcode_atts(array(
            'class'  => 'related_cic',
            'title'  => 'Related Payday Loan Companies in %city% %region%',
            'total'  => 5,
            'target' => null,
        ), $atts);
        
        $kvg                = (int)$post->company->id;
        $city               = $post->city;
        $city_id            = (int)$city->id;
        $companies_table    = DC_COMPANIES;
        $addresses_table    = DC_ADDRESSES;
        $cities_table       = DC_CITIES;
        $regions_table      = DC_REGIONS;
        $current_service_id = (isset($post->city->service['service']->id)) ? (int)$post->city->service['service']->id : 0;
        $limit              = $atts['total'];
        $related_companies  = "SELECT DISTINCT z.company_id, z.company_name, z.company_alias FROM (SELECT
       a.id, a.company_id, a.region_id, a.address, a.phone, a.website, a.opened, a.days, a.alias, a.general_info,
       c.company_name, c.alias AS company_alias, ct.city_name, ct.alias AS city_alias, ct.region AS region, ct.region_alias AS region_alias
                    FROM $addresses_table AS a INNER JOIN $companies_table AS c
                    ON a.company_id = c.id
                    INNER JOIN $cities_table AS ct
                    ON a.city_id = ct.id
					INNER JOIN $regions_table AS r
					ON r.id=a.region_id
                    WHERE a.city_id=%d AND c.id<>%d
                   	AND r.services IN (%d) ) AS z
					WHERE z.company_id <> %d ORDER BY RAND() LIMIT 0, $limit";
        $get_res            = $wpdb->prepare($related_companies, $city_id, $kvg, $current_service_id, $kvg);
        $related_companies  = $wpdb->get_results($get_res, ARRAY_A);
        
        if (count($related_companies) == 0) return false;
        
        $home_url       = home_url("/");
        $region_obj     = $post->city->region;
        $region         = $region_obj->region_name; // %region%
        $region_code    = $region_obj->region_code; // %region_code%
        $region_alias   = $region_obj->alias;
        $city_obj       = $post->city;
        $city           = $city_obj->city_name; // %city%
        $city_alias     = $city_obj->alias;
        $service_obj    = $post->city->service['service'];
        $service        = $service_obj->service_name; // %service%
        $service_plural = $service_obj->plural; // %service_plural%
        $target         = (isset($atts['target'])) ? ' target="' . $atts['target'] . '"' : '';
        
        $related = '<div class="related-post ' . $atts['class'] . '">';
        $related .= '<h3 class="post-title"><span class="title-wrap">' . $atts['title'] . '</span></h3><ul class="article-wrap">';
        
        foreach ($related_companies as $kvg) {
            $company_name  = $kvg['company_name'];
            $company_alias = $kvg['company_alias'];
            $related       .= '<li><a title="' . $company_name . ' locations in %city%, %region_code%" href="' . $home_url . $region_alias . '/' . $city_alias . '/' . $company_alias . '/"' . $target . '>' . $company_name . ' <i class="fa fa-info-circle"></i></a></li>';
        }
        $related .= '</ul></div>';
        
        $rules = array(
            '%service%'        => $service,
            '%service_plural%' => $service_plural,
            '%region%'         => $region,
            '%region_code%'    => $region_code,
            '%city%'           => $city
        );
        
        return strtr($related, $rules);
    }
    
    add_shortcode('frontpage_cta', 'frontpage_cta');
    function frontpage_cta($atts)
    {
        global $post;
        
        $atts = shortcode_atts([
            'title'       => 'Default H1 title',
            'description' => 'Default description',
        ], $atts);
        
        $h1          = $atts['title'];
        $description = $atts['description'];
        include_once "includes/frontpage_cta.tpl.php";
    }