<?php
    defined('ABSPATH') or die('');
    
    add_action('admin_init', 'plugin_settings');
    
    function plugin_settings()
    {
        register_setting('dc_options_group', 'dc_option', 'sanitize_callback');
        /* Секция основных настроек*/
        add_settings_section('section_id', 'Основные настройки', '', 'main_section');
        
        add_settings_field('dc_installation_type', 'Тип установки', 'installation_type', 'main_section', 'section_id');
        add_settings_field('dc_population_limit', __('Численность населения', 'dc'), 'fill_dc_population_limit',
            'main_section', 'section_id');
        
        /* Секция настройки меню  */
        add_settings_section('strings', 'Настройки меню', '', 'strings_section');
        
        add_settings_field('menu_level', 'Одноуровневое меню', 'services_menu_level', 'strings_section', 'strings');
        add_settings_field('show_service_name_on_subitems', 'Показывать название сервиса в подпунктах',
            'fill_service_name_on_subitems', 'strings_section', 'strings');
        add_settings_field('services_menu_separator', __('Разделитель', 'dc'), 'fill_mainmenu_separator',
            'strings_section', 'strings');
        add_settings_field('menu_item_name', __('Название пункта меню', 'dc'), 'menu_item_name', 'strings_section',
            'strings');
    }
    
    ## Заполняем опцию 1
    function installation_type()
    {
        $val             = get_option('dc_option');
        $install_type    = isset($val['dc_installation_type']) ? $val['dc_installation_type'] : null;
        $mysql_installed = isset($val['mysql_installed']) ? $val['mysql_installed'] : null;
        
        if (isset($install_type)) {
            echo '<input class="hidden" name="dc_option[dc_installation_type]" value="' . $install_type . '">';
            echo '<input class="hidden" name="dc_option[mysql_installed]" value="' . $mysql_installed . '">';
            $type = ($install_type == 1) ? __('Один сервис', 'dc') : __('Мультисервис', 'dc');
            echo $type;
        } else {
            ?>
			<select class="input" name="dc_option[dc_installation_type]">
				<option value="1">Один сервис</option>
				<option value="2">Более одного сервиса</option>
			</select>
            <?php
        }
    }
    
    ## Заполняем опцию 2
    function services_menu_level()
    {
        $val = get_option('dc_option');
        $val = (array_key_exists('menu_level', $val)) ? $val['menu_level'] : null;
        ?>
		<input type="checkbox" name="dc_option[menu_level]" value="1" <?php checked(1, $val) ?> />
        <?php
    }
    
    ## Заполняем опцию fill_service_name_on_subitems
    function fill_service_name_on_subitems()
    {
        $val = get_option('dc_option');
        $val = (array_key_exists('show_service_name_on_subitems', $val)) ? $val['show_service_name_on_subitems'] : null;
        ?>
		<input type="checkbox" name="dc_option[show_service_name_on_subitems]" value="1" <?php checked(1, $val) ?> />
        <?php
    }
    
    ## Заполняем опцию services_menu_separator
    function fill_mainmenu_separator()
    {
        $val = get_option('dc_option');
        $val = isset($val['services_menu_separator']) ? $val['services_menu_separator'] : null;
        ?>
		<input type="text" name="dc_option[services_menu_separator]" value="<?php echo esc_attr($val) ?>"/>
        <?php
    }
    
    ## Заполняем опцию
    function menu_item_name()
    {
        $val            = get_option('dc_option');
        $menu_item_name = isset($val['menu_item_name']) ? $val['menu_item_name'] : null;
        ?>
		<input type="text" name="dc_option[menu_item_name]" value="<?php echo esc_attr($menu_item_name) ?>"/>
        <?php
    }
    
    ## Заполняем опцию численности населения
    function fill_dc_population_limit()
    {
        $val              = get_option('dc_option');
        $population_limit = isset($val['dc_population_limit']) ? $val['dc_population_limit'] : 40000;
        ?>
		<input type="text" name="dc_option[dc_population_limit]" value="<?php echo esc_attr($population_limit) ?>"/>
        <?php
    }
    
    ## Очистка данных
    function sanitize_callback($options)
    {
        foreach ($options as $name => & $val) {
            if ($name == 'test_option' || $name == 'services_menu_separator') {
                $val = strip_tags($val);
            }
            
            if ($name == 'menu_level') {
                $val = intval($val);
            }
        }
        
        return $options;
    }
    
    function main_settings_page()
    {
        $plugin_options = get_option('dc_option');
        
        $mysql_installed   = isset($plugin_options['mysql_installed']) ? $plugin_options['mysql_installed'] : null;
        $installation_type = isset($plugin_options['dc_installation_type']) ? $plugin_options['dc_installation_type'] : null;
        
        /*echo '<pre>';
        print_r($plugin_options);
        echo '</pre>';*/
        
        ?>
		<div class="wrap">
			<form action="options.php" method="POST">
                <?php
                    if ( ! isset($installation_type) && ! isset($mysql_installed)) { // 1 step
                        settings_fields('dc_options_group');
                        do_settings_sections('main_section');
                        submit_button(__('Далее', 'dc'));
                    } elseif (isset($installation_type) && ! isset($mysql_installed)) { // step 2
                        insert_mysql_data();
                    } else {
                        settings_fields('dc_options_group');
                        do_settings_sections('main_section');
                        echo "<hr />";
                        do_settings_sections('strings_section');
                        submit_button(__('Сохранить настройки', 'dc'));
                        echo "<hr />";
                        shortcodes_hints();
                    }
                
                ?>
			</form>
		</div>
        <?php
    }
    
    function shortcodes_hints()
    {
        $home = home_url();
        ?>
		<h2>Сгенерировать карты сайта</h2>
		<div class="sitemaps_links">
			<div class="generate_new">
				<h4>Сгенерировать</h4>
				<ul>
					<li><a class="generate_sitemap" data-value="services" href="#">Сервисы</a></li>
					<li><a class="generate_sitemap" data-value="regions" href="#">Штаты</a></li>
					<li><a class="generate_sitemap" data-value="cities" href="#">Города</a></li>
					<li><a class="generate_sitemap" data-value="companies" href="#">Компании</a></li>
					<li><a class="generate_sitemap" data-value="kvg" href="#">КВГ</a></li>
				</ul>
				<div id="generate_sitemap__results"></div>
			</div>
			<div class="download">
				<h4>Скачать</h4>
				<ul>
					<li><a href="<?php echo $home; ?>/sitemap.xml" target="_blank">WP + Сервисы + Штаты</a></li>
					<li><a href="<?php echo $home; ?>/cities.xml" target="_blank">Города</a></li>
					<li><a href="<?php echo $home; ?>/companies.xml" target="_blank">Компании</a></li>
					<li><a href="<?php echo $home; ?>/cic.xml" target="_blank">КВГ</a></li>
				</ul>
			</div>
		</div>
		<hr/>
		<h2>Шорткоды</h2>
		<div class="shortcodes">
			<div class="shortcodes_uls">
				<ul class="shortcode_ul">
					<li><h3>Сервисы</h3></li>
					<li class="shortcode">[service] == [service service_name]</li>
					<li class="shortcode">[service plural]</li>
					<li class="shortcode">[service syn_1]</li>
					<li class="shortcode">[service syn_2]</li>
					<li class="shortcode">[service syn_3]</li>
					<li class="shortcode">[service alias]</li>
					<li class="shortcode">[service description]</li>
					<li class="shortcode">[service title]</li>
					<li class="shortcode">[service seo_h1]</li>
					<li class="shortcode">[service seo_description]</li>
					<li class="shortcode">[service seo_excerpt]</li>
				</ul>
				<ul class="shortcode_ul">
					<li><h3>Регионы</h3></li>
					<li class="shortcode">[region] == [region region_name]</li>
					<li class="shortcode">[region region_code]</li>
					<li class="shortcode">[region alias]</li>
					<li class="shortcode">[region description]</li>
					<li class="shortcode">[region title]</li>
					<li class="shortcode">[region seo_h1]</li>
					<li class="shortcode">[region seo_description]</li>
					<li class="shortcode">[region seo_excerpt]</li>
				</ul>
				<ul class="shortcode_ul">
					<li><h3>Города</h3></li>
					<li class="shortcode">[city] == [city city_name]</li>
					<li class="shortcode">[city alias]</li>
					<li class="shortcode">[city description]</li>
					<li class="shortcode">[city title]</li>
					<li class="shortcode">[city seo_h1]</li>
					<li class="shortcode">[city seo_description]</li>
					<li class="shortcode">[city seo_excerpt]</li>
					<li class="shortcode">[city region]</li>
				</ul>
				<ul class="shortcode_ul">
					<li><h3>Меню штатов</h3></li>
					<li class="shortcode">[regions_menu]</li>
					<li>
						<hr/>
					</li>
					<li><span>Список опций:</span></li>
					<li>[... <strong>id</strong>="custom_id_value" ...]</li>
					<li>[... <strong>class</strong>="custom_class" ...]</li>
					<li>[... <strong>container</strong>="div" ...]</li>
					<li>[... <strong>items_wrap</strong>="p" ...]</li>
					<li>[... <strong>limit</strong>="20" ...]</li>
					<li>[... <strong>orderby</strong>="database_field" ...]</li>
					<li>[... <strong>service_id</strong>="2" ...]</li>
					<li>[... <strong>service_check</strong>="1" ...]</li>
					<li>[... <strong>target</strong>="_blank" ...]</li>
					<li>[... <strong>showmore</strong>="1" ...]</li>
					<li>[... <strong>showcities</strong>]</li>
				</ul>
				<ul class="shortcode_ul">
					<li><h3>Регистры</h3></li>
					<li><span>Должны передаваться последним параметром</span></li>
					<li><span>Для [service], [region] и [city]:</span></li>
					<li>[... <strong>lowercase</strong>]</li>
					<li>[... <strong>uppercase</strong>]</li>
					<li>[... <strong>ucwords</strong>]</li>
					<li></li>
				</ul>
			</div>
			<div class="clipboard"></div>
		</div>
		<hr/>
		<h2>Примеры</h2>
		<div class="examples">
			<div class="example">
				<h4>Сервисы</h4>
				<ul class="example">
					<li><span>Service</span>Web Development</li>
					<li><span>Plural</span>Web Developments</li>
					<li><span>Synonym 1</span>Web Dev</li>
					<li><span>Synonym 2</span>Development for Web</li>
					<li><span>alias</span>web-development</li>
					<li><span>description</span>Описание сервиса веб-дев</li>
					<li><span>H1</span>Exellent Web Development</li>
				</ul>
				<ul class="return">
					<li><span>[service]</span>Web Development</li>
					<li><span>[service service_name]</span>Web Development</li>
					<li><span>[service plural]</span>Web Developmens</li>
					<li><span>[service syn_1]</span>Web Dev</li>
					<li><span>[service syn_2]</span>Development for Web</li>
					<li><span>[service alias]</span>web-development</li>
					<li><span>[service description]</span>Описание сервиса веб-дев</li>
					<li><span>[service seo_h1]</span>Exellent Web Development</li>
				</ul>
			</div>
			<div class="example">
				<h4>Регионы</h4>
				<div>
					<div class="rotated">Примеры будут позже</div>
				</div>
			</div>
			<div class="example">
				<h4>Города</h4>
				<div>
					<div class="rotated">Примеры будут позже</div>
				</div>
			</div>
			<div class="example">
				<h4>Регистры</h4>
				<ul class="example">
					<li><span>Service</span>Web design</li>
					<li><span>Service Synonym 1</span>webdesign</li>
					<li><span>Region</span>Alabama</li>
				</ul>
				<ul class="return">
					<li><span>[service ucwords]</span>Web Design</li>
					<li><span>[service syn_1 lowercase]</span>webdesign</li>
					<li><span>[region uppercase]</span>ALABAMA</li>
					<li><span>[service syn_1]</span>Web Dev</li>
				</ul>
			</div>
		</div>
        <?php
    }
    
    function installation_step_2()
    {
    }
    
    function dc_admin_db_manage()
    {
        $services = get_all_services();
        ?>
		<section class="database_management">
			<h2>База данных</h2>
			<section class="templates">
				<h3>Шаблоны</h3>
				<form method="post" action="optins.php">
					<table class="templates_management">
						<thead>
						<tr>
							<th>Сервис</th>
							<th>Штат</th>
							<th>Город</th>
						</tr>
						</thead>
						<tbody>
						<tr>
							<td><input name="service_name" type="text" placeholder="Сервис"></td>
							<td><input name="region_name" type="text" placeholder="Штат"></td>
							<td><input name="city_name" type="text" placeholder="Город"></td>
						</tr>
                        <?php
                            $html = '';
                            foreach ($services as $service) {
                                $html .= '<tr>';
                                $html .= '<td data-service-id="' . $service->id . '">';
                                $html .= $service->service_name;
                                $html .= '</td>';
                                $html .= '<td></td>';
                                $html .= '<td></td>';
                                $html .= '</tr>';
                            }
                            echo $html;
                        
                        ?>

						</tbody>
					</table>
                    <?php submit_button(__('Сохранить настройки', 'dc')); ?>
				</form>
			</section>
			<section class="services">
				<h3>Сервисы</h3>
			</section>
			<section class="regions">
				<h3>Штаты</h3>
			</section>
			<section class="cities">
				<h3>Города</h3>
			</section>
		</section>
        
        
        <?php
        
    }
    
    function import_cities_csv()
    {
        echo 'import CSV';
    }