(function ($) {
    $(document).ready(function () {
        $('li.shortcode').click(function () {
            var shortcode = $(this)[0].innerText;
            copyToClipboard(shortcode);
        });

        function copyToClipboard(shortcode) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(shortcode).select();
            document.execCommand("copy");
            $temp.remove();
            $('.clipboard').html(shortcode + " скопирован");
            $('.clipboard').addClass("flex");
            $('.clipboard').fadeIn('slow', function () {
                $('.clipboard').fadeOut('slow');
            });
        }

        $('a.generate_sitemap').on('click', function (event) {
            let sitemap_type = $(this).attr('data-value');
            event.preventDefault();
            if (sitemap_type.length >= 2) {
                let data = {
                    action: 'generate_sitemap',
                    sitemap_type: sitemap_type,
                };
                $('div#generate_sitemap__results').html('ща ...');
                $("div#generate_sitemap__results").addClass("is-active");
                jQuery.ajax({
                    url: ajaxout.url,
                    data: data,
                    method: 'POST',
                    success: function (response) {
                        $("div#generate_sitemap__results").removeClass("is-active");
                        $('div#generate_sitemap__results').html(response);
                    },
                    error: function (error) {
                        $("div#generate_sitemap__results").removeClass("is-active");
                        console.log(error)
                    }
                })
            }
        })
        if ($('form#indexing-links-table').length) {
            if ($('form#indexing-links-table input#search-search-input').val() !== '') {
                let new_href = "&s=" + $('form#indexing-links-table input#search-search-input').val()

                $('span.pagination-links a').each(function () {
                    $(this).attr('href', $(this).attr('href') + new_href)
                })
            }
        }
        if ($('form#indexing-links-table select#bulk-action-selector-top').length) {
            $('form#indexing-links-table select#bulk-action-selector-top option').each(function () {
                if ($(this).text() === 'Delete') {
                    $(this).attr('style', 'background: #cc2424; color: white; font-weight: 600;')
                }
            })
        }
        if ($('table.links tbody#the-list').length) {
            $('table.links tbody#the-list tr').on('click', function (e) {
                let chkbx = $(this).find('input[type="checkbox"]')
                chkbx.prop("checked", !chkbx.prop("checked"))
                $(this).toggleClass('tr-checked')
            })
            $('table.links tbody#the-list tr').each(function () {
                let row = $(this)
                let link_type = $(this).find('td.type').text()
                switch (link_type) {
                    case 'wp':
                        row.addClass('tr-wp')
                        break

                    case 'service':
                        row.addClass('tr-service')
                        break

                    case 'region':
                        row.addClass('tr-region')
                        break

                    case 'city':
                        row.addClass('tr-city')
                        break

                    case 'company':
                        row.addClass('tr-company')
                        break

                    case 'kvg':
                        row.addClass('tr-kvg')
                        break
                }
            })
        }

        /* GSC Links filtering */

        if ($('form#links-filtering-form').length) {
            let filter_form = $('form#links-filtering-form')
            let task = $('input#task')
            let services_confirm_links = $('input#services_confirm')
            let regions_confirm_links = $('input#regions_confirm')
            let cities_confirm_links = $('input#cities_confirm')
            let parents_confirm_links = $('input#parents_confirm')
            let queue_table = $('table#queue_links tbody')
            let home_url = $('input#home_url').val()
            let city_search_input = $(this).find('input#city_search')
            let population_input = $('input#population_limit')
            let addresses_limit = $('input#addresses_limit')
            let services_select = $('select.services')
            let regions_select = $('select.regions')
            let cities_select = $('select.cities')
            let parents_select = $('select.parents')


            // City Search
            city_search_input.on('change', function (val) {
                let search_phrase = $(this).val();
                cities_select.empty()
                $('input#task').val('get_cities')
                send_filtering_data(filter_form)
            })

            // City Population limit
            population_input.on('change', function () {
                let population = $(this).val();
                if (population.length > 2) {
                    $('input#task').val('get_cities')
                    cities_select.empty()
                    send_filtering_data(filter_form)
                }
            })

            // Parents Addresses limit
            addresses_limit.on('change', function () {
                let addresses = $(this).val();
                if (addresses.length > 0) {
                    $('input#task').val('get_parents')
                    parents_select.empty()
                    send_filtering_data(filter_form)
                }
            })

            // Service Select
            services_select.children('option').on('select click', function (e) {
                e.preventDefault()
                $('input#task').val('get_regions')
                regions_select.empty()
                send_filtering_data(filter_form)
            })


            // Add to Queue checkboxes processing
            services_confirm_links.on('click', function () {
                queue_table.children('tr[data-type="service"]').remove()
                services_select.children('option').each(function () {
                    if ($(this).prop('selected') === true) {
                        let service_alias = $(this).attr('data-alias')
                        let service_id = $(this).attr('value')
                        let url = home_url + service_alias + '/';
                        queue_table.append('<tr class="tr-service" data-type="service" data-id="' + service_id + '"><td class="url""><a target="_blank" href="' + url + '">' + url + '</a></td></tr>');
                        update_total_links_counter()
                    }
                })
            })

            regions_confirm_links.on('click', function () {
                queue_table.children('tr[data-type="region"]').remove()
                regions_select.children('option').each(function () {
                    if ($(this).prop('selected') === true) {
                        let region_alias = $(this).attr('data-alias')
                        let region_id = $(this).attr('value')
                        let url = home_url + region_alias + '/';
                        queue_table.append('<tr data-type="region" class="tr-region" data-id="' + region_id + '"><td class="url"><a target="_blank" href="' + url + '">' + url + '</a></td></tr>');
                        update_total_links_counter()
                    }
                })
            })

            cities_confirm_links.on('click', function () {
                queue_table.children('tr[data-type="city"]').remove()
                cities_select.children('option').each(function () {
                    if ($(this).prop('selected') === true) {
                        let city_alias = $(this).attr('data-alias')
                        let city_id = $(this).attr('value')
                        let region_alias = $(this).attr('data-region-alias')
                        let url = home_url + region_alias + '/' + city_alias + '/';
                        queue_table.append('<tr data-type="city" class="tr-city" data-id="' + city_id + '"><td class="url"><a target="_blank" href="' + url + '">' + url + '</a></td></tr>');
                        update_total_links_counter()
                    }
                })
            })

            parents_confirm_links.on('click', function () {
                queue_table.children('tr[data-type="company"]').remove()
                parents_select.children('option').each(function () {
                    if ($(this).prop('selected') === true) {
                        let company_alias = $(this).attr('data-alias')
                        let company_id = $(this).attr('value')
                        let url = home_url + company_alias + '/';
                        queue_table.append('<tr data-type="company" class="tr-company" data-id="' + company_id + '"><td class="url"><a target="_blank" href="' + url + '">' + url + '</a></td></tr>');
                        update_total_links_counter()
                    }
                })
            })

            // Select All
            $('span.select_all').on('click', function () {
                $(this).next().children('option').prop('selected', true);
                if ($(this).attr('data-task') === 'get_cities') {
                    task.val('get_cities')
                    send_filtering_data(filter_form)
                }
            })

            //Deselect All
            $('span.deselect_all').on('click', function () {
                $(this).next().next().next().children('option').prop('selected', false);
                if ($(this).attr('data-task') === 'get_cities') {
                    cities_select.empty()
                    $("span.total_links.cities").empty()
                }
            })

            // [PARENTS] Get Data button
            $("input#parents_get").on("click", function (e) {
                e.preventDefault()
                $('input#task').val('get_parents')
                parents_select.empty()
                send_filtering_data(filter_form)
            })
        } // if filter form exists


        if ($('form#indexing-links-table input#doaction').length && $('form#indexing-links-table input#all_elements').length) $('form#indexing-links-table input#doaction').after('<label for="all_elements_select"><input id="all_elements_select" type="checkbox" name="all_items"> Select all elements</label>')


    }) // document ready end

    $(document).on('click', 'form#indexing-links-table input#all_elements_select', function () {
        let all_elements_input = $('input#all_elements')
        let all_ids = JSON.stringify(all_elements_input.val())
        all_elements_input.attr('name', 'all_elements')
    })

    // error message fade out
    $(document).on('click', "span.error_message", function () {
        $("span.error_message").fadeOut()
    })
    $(document).on('click', "span.success_message", function () {
        $("span.success_message").fadeOut()
    })

    $(document).on('click', 'input#erase_pre_data', function () {
        if (confirm("Are you sure you want to erase all pre-queued links?")) {
            $('table#queue_links tbody').empty()
            update_total_links_counter()
        }
    })
    $(document).on('click', 'input#truncate_queue', function () {
        if (confirm("Are you sure you want to delete all queued data from DB?")) {
            $('input#task').val('truncate_queue')
            let all_data = getFormData($('form#links-filtering-form'))
            jQuery.ajax({
                url: ajaxout.url,
                data: all_data,
                method: 'POST',
                action: 'truncate_queue',
                success: function (response) {
                    $('h2.filtering_form_header').removeClass('is-active')
                    $('div#result').html(response)
                },
                error: function (response) {
                    $('h2.filtering_form_header').removeClass('is-active')
                    console.log('ERROR' + response)
                },
            })
        }
    })

    // Add to the end
    $(document).on('change', 'input#add_to_end', function () {
        let inp = $('input#to_end')
        let val = inp.val();
        if (val === "0") {
            inp.val("1");
        }
        else {
            inp.val("0");
        }
    })


    $(document).on('click', 'input#complete', function () {
        let links = $('table#queue_links tbody')
        $('input#task').val('add_to_queue')
        let sending_data = []
        let queue_input = $('input#queue_data')

        links.children('tr').each(function (index) {
            let link_type = $(this).attr('data-type')
            let entity_id = $(this).attr('data-id')
            sending_data.push({
                't': link_type,
                'id': entity_id
            })
        })
        queue_input.val(JSON.stringify(sending_data))

        $('h2.filtering_form_header').addClass('is-active')
        $('form#links-filtering-form select#regions_select').empty()
        $('form#links-filtering-form select#cities_select').empty()
        let all_data = getFormData($('form#links-filtering-form'))
        jQuery.ajax({
            //dataType: 'json',
            url: ajaxout.url,
            data: all_data,
            method: 'POST',
            action: 'add_to_queue',
            success: function (response) {
                $('h2.filtering_form_header').removeClass('is-active')
                $('div#result').html(response)
            },
            error: function (response) {
                $('h2.filtering_form_header').removeClass('is-active')
                console.log('ERROR' + response)
            },
        })
    })

    // regions select select
    $(document).on('click select', 'select#regions_select option', function (e) {
        e.preventDefault()
        $('select.cities').empty()
        $('input#task').val('get_cities')
        send_filtering_data($('form#links-filtering-form'))
    })

    function update_total_links_counter() {
        let counter = $('div.total_links')
        counter.empty()
        let links_table = $('table#queue_links tbody tr')
        let total_links = links_table.length
        counter.html("Всего ссылок: " + total_links)
    }

    function send_filtering_data(filter_form) {
        $('h2.filtering_form_header').addClass('is-active')
        let sending_data = getFormData(filter_form)
        jQuery.ajax({
            dataType: 'json',
            url: ajaxout.url,
            data: sending_data,
            method: 'POST',
            action: 'filter_gsc_links',
            success: function (response) {
                $('h2.filtering_form_header').removeClass('is-active')
                analyze_response(response)
            },
            error: function (response) {
                $('h2.filtering_form_header').removeClass('is-active')
                //console.log('ERROR' + response)
            },
        })
    }

    function getFormData($form) {
        return $form.serialize();
    }

    function analyze_response(response) {
        let output = ''
        if (response.message.length > 0) {
            $('div#result').html('<span class="error_message">' + response.message + '</span>')
        }
        if (response.status === 0) {
            console.log('RESPONSE ERROR' + response.error)
        }
        else if (response.status === 1) { // ok
            if (response.regions.length) {
                let regions_select = $('select.regions')
                $('span.total_links.regions').html(response.regions.length)
                for (let i = 0; i < response.regions.length; i++) {
                    let region = response.regions[i]
                    let region_name = region.region_name
                    let region_id = region.id
                    let region_alias = region.alias
                    regions_select.append('<option data-alias="' + region_alias + '" value="' + region_id + '">' + region_name + '</option>')
                }
            }
            if (response.cities.length) {
                let cities_select = $('select.cities')
                $('span.total_links.cities').html(response.cities.length)
                for (let i = 0; i < response.cities.length; i++) {
                    let cities = response.cities[i]
                    let city_name = cities.city_name
                    let city_id = cities.id
                    let city_alias = cities.alias
                    let region_alias = cities.region_alias
                    let population = cities.population
                    cities_select.append('<option data-alias="' + city_alias + '" data-region-alias="' + region_alias + '" value="' + city_id + '">' + city_name + '</option>')
                }
            }
            if (response.parents.length) {
                let parents_select = $('select.parents')
                $('span.total_links.parents').html(response.parents.length)
                for (let i = 0; i < response.parents.length; i++) {
                    let parents = response.parents[i]
                    let parent_name = parents.company
                    let parent_id = parents.company_id
                    let parent_alias = parents.alias
                    parents_select.append('<option data-alias="' + parent_alias + '" value="' + parent_id + '">' + parent_name + '</option>')
                }
            }
        }
        else {
            $('div#result').html(response)
        }
    }
})
(jQuery);