<?php
    function dc_templates_page_handler()
    {
        $table = new TemplateTable();
        $table->prepare_items();
        
        $message = '';
        if ('delete' === $table->current_action()) {
            $message = '<div class="updated below-h2" id="message"><p>' . sprintf(__('Items deleted: %d', 'dc'),
                    count($_REQUEST['id'])) . '</p></div>';
        }
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br/></div>
			<h2><?php _e('Templates', 'dc') ?> <a class="add-new-h2"
			                                      href="<?php echo get_admin_url(get_current_blog_id(),
                                                      'admin.php?page=templates_form'); ?>"><?php _e('Add new',
                        'dc') ?></a>
			</h2><?php echo $message; ?>
			<form id="templates-table" method="POST">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>"/>
                <?php $table->search_box(__('Search', 'dc'), 'search'); ?>
                <?php $table->display() ?>
			</form>
		</div>
        <?php
    }
    
    function dc_templates_form_page_handler()
    {
        global $wpdb;
        $table_name = DC_TEMPLATES;
        $message    = '';
        $notice     = '';
        
        $default = array(
            'id'              => 0,
            'template_name'   => 'New template',
            'description'     => '',
            'title'           => '',
            'seo_h1'          => '',
            'seo_description' => '',
            'content'         => '',
            'seo_excerpt'     => '',
            'markup_file'     => 'default-v-template.php',
        );
        
        if (isset($_REQUEST['nonce']) && wp_verify_nonce($_REQUEST['nonce'], basename(__FILE__))) {
            $item       = shortcode_atts($default, $_REQUEST);
            $item_valid = dc_template_validate_template($item);
            if ($item_valid === true) {
                if ($item['id'] == 0) { // new template
                    $item['content']     = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt'] = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $result              = $wpdb->insert($table_name, $item);
                    $item['id']          = $wpdb->insert_id;
                    if ($result) {
                        $message = __('Template was successfully saved', 'dc');
                    } else {
                        $notice = __('There was an error while saving template', 'dc');
                    }
                } else {
                    $item['content']     = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt'] = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $result              = $wpdb->update($table_name, $item, array('id' => $item['id']));
                    if ($result) {
                        $message = __('Template was successfully updated', 'dc');
                    } else {
                        $notice = __('There was an error while updating item', 'dc');
                    }
                }
            } else {
                $notice = $item_valid;
            }
        } else {
            $item = $default;
            if (isset($_REQUEST['id'])) {
                $item = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $_REQUEST['id']),
                    ARRAY_A);
                if ( ! $item) {
                    $item   = $default;
                    $notice = __('Template not found', 'dc');
                }
            }
        }
        
        add_meta_box('dc_templates_form_meta_box', __('templates data', 'dc'), 'dc_templates_form_meta_box_handler',
            'template', 'normal', 'default');
        
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
			<h2><?php _e('Template', 'dc') ?> <a class="add-new-h2"
			                                     href="<?php echo get_admin_url(get_current_blog_id(),
                                                     'admin.php?page=dc-catalog-templates'); ?>"><?php _e('← Back to templates list',
                        'dc') ?></a>
			</h2><?php if ( ! empty($notice)): ?>
				<div id="notice" class="error"><p><?php echo $notice ?></p></div><?php endif; ?>
            <?php if ( ! empty($message)): ?>
				<div id="message" class="updated"><p><?php echo $message ?></p></div><?php endif; ?>

			<form id="form" method="POST">
				<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__)) ?>"/>
				<input type="hidden" name="id" value="<?php echo $item['id'] ?>"/>
				<div class="metabox-holder" id="poststuff">
					<div id="post-body">
						<div id="post-body-content"><?php do_meta_boxes('template', 'normal', $item); ?>
							<input type="submit" value="<?php _e('Save', 'dc') ?>" id="submit" class="button-primary"
							       name="submit">
						</div>
					</div>
				</div>
			</form>
		</div>
        <?php
    }
    
    function dc_templates_form_meta_box_handler($item)
    {
        ?>
		<tbody>
		<div class="formdatabc">
			<form>
				<div class="form2bc">
					<p>
						<label for="template_name"><?php _e('Template Name', 'dc') ?></label>
						<br>
						<input id="template_name" name="template_name" type="text"
						       value="<?php echo esc_attr($item['template_name']) ?>" required>
					</p>
					<p>
						<label for="description"><?php _e('Description', 'dc') ?></label>
						<br>
						<input id="description" name="description" type="text"
						       value="<?php echo esc_attr($item['description']) ?>">
					</p>
				</div>
				<hr/>
				<div class="form2bc">
					<p>
						<label for="title"><?php _e('Title', 'dc') ?></label>
						<br>
						<input id="title" name="title" type="text" value="<?php echo esc_attr($item['title']) ?>">
					</p>
					<p>
						<label for="seo_h1"><?php _e('H1', 'dc') ?></label>
						<br>
						<input id="seo_h1" name="seo_h1" type="text" value="<?php echo esc_attr($item['seo_h1']) ?>">
					</p>
				</div>
				<div class="form2bc">

					<p>
						<label for="seo_description"><?php _e('SEO Description', 'dc') ?></label>
						<br>
						<input id="seo_description" name="seo_description" type="text"
						       value="<?php echo esc_attr($item['seo_description']) ?>">
					</p>
					<p>
						<label for="markup_file"><?php _e('Markup file', 'dc') ?></label>
						<br>
						<input id="markup_file" name="markup_file" type="text"
						       value="<?php echo esc_attr($item['markup_file']) ?>">
					</p>

				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="seo_excerpt"><?php _e('Excerpt:', 'dc') ?></label>
					<br><?php
                        $exc_id  = "seo_excerpt";
                        $excerpt = stripslashes($item['seo_excerpt']);
                        wp_editor($excerpt, strtolower($exc_id));
                    ?>
					</p>
				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="content"><?php _e('Content:', 'dc') ?></label>
					<br><?php
                        $id      = "content";
                        $content = stripslashes($item['content']);
                        wp_editor($content, strtolower($id));
                    ?>
					</p>
				</div>
			</form>
		</div>
		</tbody>
        <?php
    }
    
    function dc_template_validate_template($item)
    {
        $messages = array();
        
        if (empty($item['template_name'])) {
            $messages[] = __('template Name is required', 'dc');
        }/*
            if (empty($item['content'])) $messages[] = __('Last Name is required', 'wpbc');
            if (!empty($item['email']) && !is_email($item['email'])) $messages[] = __('E-Mail is in wrong format', 'wpbc');
            if(!empty($item['phone']) && !absint(intval($item['phone'])))  $messages[] = __('Phone can not be less than zero');
            if(!empty($item['phone']) && !preg_match('/[0-9]+/', $item['phone'])) $messages[] = __('Phone must be number');*/
        
        if (empty($messages)) {
            return true;
        }
        
        return implode('<br />', $messages);
    }