<?php
    function dc_companies_page_handler()
    {
        $table = new CompanyTable();
        $table->prepare_items();
        
        $message = '';
        if ('delete' === $table->current_action()) {
            $message = '<div class="updated below-h2" id="message"><p>' . sprintf(__('Items deleted: %d', 'dc'),
                    count($_REQUEST['id'])) . '</p></div>';
        }
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br/></div>
			<h2><?php _e('Companies', 'dc') ?> <a class="add-new-h2"
			                                      href="<?php echo get_admin_url(get_current_blog_id(),
                                                      'admin.php?page=companies_form'); ?>"><?php _e('Add new',
                        'dc') ?></a>
			</h2><?php echo $message; ?>
			<form id="companies-table" method="POST">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>"/>
                <?php $table->search_box(__('Search', 'dc'), 'search'); ?>
                <?php $table->display() ?>
			</form>
		</div>
        <?php
    }
    
    function dc_companies_form_page_handler()
    {
        global $wpdb;
        $table_name = DC_COMPANIES;
        $message    = '';
        $notice     = '';
        
        $default = array(
            'id'              => 0,
            'company_name'    => 'New Company',
            'alias'           => '',
            'description'     => '',
            'title'           => '',
            'seo_h1'          => '',
            'seo_description' => '',
            'seo_excerpt'     => '',
            'content'         => '',
            'template_id'     => '5',
            'parent_template' => '6',
        );
        
        if (isset($_REQUEST['nonce']) && wp_verify_nonce($_REQUEST['nonce'], basename(__FILE__))) {
            $item       = shortcode_atts($default, $_REQUEST);
            $item_valid = dc_company_validate_company($item);
            if ($item_valid === true) {
                if ($item['id'] == 0) { // new company
                    $new_company_id = $wpdb->get_var("SELECT MAX(id) FROM $table_name;");
                    
                    if (empty($item['alias'])) {
                        $item['alias'] = sanitize_title($item['company_name']);
                    } else {
                        $item['alias'] = sanitize_title($item['alias']);
                    }
                    
                    $item['content']     = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt'] = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $item['id']          = $new_company_id + 1;
                    $result              = $wpdb->insert($table_name, $item);
                    
                    if ($result) {
                        $message = __('Company was successfully created', 'dc');
                    } else {
                        $notice = __('There was an error while creating company', 'dc');
                    }
                } else {
                    
                    $item['content']         = wp_kses_post(stripslashes($item['content']));
                    $item['seo_excerpt']     = wp_kses_post(stripslashes($item['seo_excerpt']));
                    $item['company_name']    = wp_kses_post(stripslashes($item['company_name']));
                    $item['title']           = wp_kses_post(stripslashes($item['title']));
                    $item['description']     = wp_kses_post(stripslashes($item['description']));
                    $item['seo_description'] = wp_kses_post(stripslashes($item['seo_description']));
                    $item['seo_h1']          = wp_kses_post(stripslashes($item['seo_h1']));
                    
                    $result = $wpdb->update($table_name, $item, array('id' => $item['id']));
                    
                    if ($result) {
                        $message = __('Item was successfully updated', 'dc');
                    } else {
                        $notice = __('There was an error while updating item', 'dc');
                    }
                }
            } else {
                $notice = $item_valid;
            }
        } else {
            
            $item = $default;
            if (isset($_REQUEST['id'])) {
                $item = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $_REQUEST['id']),
                    ARRAY_A);
                if ( ! $item) {
                    $item   = $default;
                    $notice = __('Item not found', 'dc');
                }
            }
        }
        
        add_meta_box('dc_companies_form_meta_box', __('companies data', 'dc'), 'dc_companies_form_meta_box_handler',
            'company',
            'normal', 'default');
        
        ?>
		<div class="wrap">
			<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
			<h2><?php _e('company', 'dc') ?> <a class="add-new-h2" href="<?php echo get_admin_url(get_current_blog_id(),
                    'admin.php?page=dc-catalog-companies'); ?>"><?php _e('Back to Companies list', 'dc') ?></a>
			</h2><?php if ( ! empty($notice)): ?>
				<div id="notice" class="error"><p><?php echo $notice ?></p></div><?php endif; ?>
            <?php if ( ! empty($message)): ?>
				<div id="message" class="updated"><p><?php echo $message ?></p></div><?php endif; ?>

			<form id="form" method="POST">
				<input type="hidden" name="nonce" value="<?php echo wp_create_nonce(basename(__FILE__)) ?>"/>
				<input type="hidden" name="id" value="<?php echo $item['id'] ?>"/>
				<div class="metabox-holder" id="poststuff">
					<div id="post-body">
						<div id="post-body-content"><?php do_meta_boxes('company', 'normal', $item); ?>
							<input type="submit" value="<?php _e('Save', 'dc') ?>" id="submit" class="button-primary"
							       name="submit">
						</div>
					</div>
				</div>
			</form>
		</div>
        <?php
    }
    
    function dc_companies_form_meta_box_handler($item)
    {
        $templates = get_templates();
        ?>
		<tbody>
		<div class="formdatabc">
			<form>
				<input id="alias" name="alias" type="hidden" value="<?php echo esc_attr($item['alias']) ?>">
				<div class="form3bc">
					<p>
						<label for="company_name"><?php _e('company', 'dc') ?></label>
						<br>
						<input id="company_name" name="company_name" type="text"
						       value="<?php echo esc_attr($item['company_name']) ?>" required>
					</p>
					<p>
						<label for="title"><?php _e('Title', 'dc') ?></label>
						<br>
						<input id="title" name="title" type="text" value="<?php echo esc_attr($item['title']) ?>">
					</p>
					<p>
						<label for="seo_h1"><?php _e('H1', 'dc') ?></label>
						<br>
						<input id="seo_h1" name="seo_h1" type="text" value="<?php echo esc_attr($item['seo_h1']) ?>">
					</p>
				</div>
				<div class="form3bc">
					<p>
						<label for="description"><?php _e('Description', 'dc') ?></label>
						<br>
						<input id="description" name="description" type="text"
						       value="<?php echo esc_attr($item['description']) ?>">
					</p>
					<p>
						<label for="seo_description"><?php _e('SEO Description', 'dc') ?></label>
						<br>
						<input id="seo_description" name="seo_description" type="text"
						       value="<?php echo esc_attr($item['seo_description']) ?>">
					</p>
					<p>
						<label for="template_id"><?php _e('CiC Template', 'dc') ?></label>
						<br>
						<select id="template_id" name="template_id"><?php
                                foreach ($templates as $template) {
                                    ($template->id == $item['template_id']) ? $selected = ' selected' : $selected = '';
                                    ?>
									<option value="<?php echo esc_attr($template->id); ?>"<?php echo $selected; ?>><?php echo esc_attr($template->template_name); ?></option>
                                    <?php
                                }
                            ?>
						</select></p>
					<p>
						<label for="parent_template"><?php _e('Parent Template', 'dc') ?></label>
						<br/>
						<select id="parent_template" name="parent_template"><?php
                                foreach ($templates as $template) {
                                    ($template->id == $item['parent_template']) ? $selected = ' selected' : $selected = '';
                                    ?>
									<option value="<?php echo esc_attr($template->id); ?>"<?php echo $selected; ?>><?php echo esc_attr($template->template_name); ?></option>
                                    <?php
                                }
                            ?>
						</select>
					</p>
				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="seo_excerpt"><?php _e('Excerpt:', 'dc') ?></label>
					<br><?php
                        $exc_id  = "seo_excerpt";
                        $excerpt = stripslashes($item['seo_excerpt']);
                        wp_editor($excerpt, strtolower($exc_id));
                    ?>
					</p>
				</div>
				<div class="form1bc">
					<p>
					<hr/>
					<label for="content"><?php _e('Content:', 'dc') ?></label>
					<br><?php
                        $id      = "content";
                        $content = stripslashes($item['content']);
                        wp_editor($content, strtolower($id));
                    ?>
					</p>
				</div>
			</form>
		</div>
		</tbody>
        <?php
    }
    
    function dc_company_validate_company($item)
    {
        $messages = array();
        
        if (empty($item['company_name'])) {
            $messages[] = __('Company Name is required', 'dc');
        }/*
            if (empty($item['content'])) $messages[] = __('Last Name is required', 'wpbc');
            if (!empty($item['email']) && !is_email($item['email'])) $messages[] = __('E-Mail is in wrong format', 'wpbc');
            if(!empty($item['phone']) && !absint(intval($item['phone'])))  $messages[] = __('Phone can not be less than zero');
            if(!empty($item['phone']) && !preg_match('/[0-9]+/', $item['phone'])) $messages[] = __('Phone must be number');*/
        
        if (empty($messages)) {
            return true;
        }
        
        return implode('<br />', $messages);
    }