<?php
    /**
     * Plugin Name: Loan Forms
     * Plugin URI:
     * Description: Формы для LOANs
     * Version:     0.0.0
     * Author:      Dr.Yurets
     */
    
    defined('ABSPATH') or die('');
    define('PLUGIN_URL', plugin_dir_url(__FILE__));
    //define('PREFILL_FORM', true); // раскомментить для предзаполнения формы
    //define('SENDING_DATA_SIMULATE', true); // раскомментить для эмуляции отсылки запросов
    
    // TODO: ABA Lookup coach overlay hints from http://heelhook.github.io/chardin.js/ or http://blog.tommoor.com/crumble/
    
    if (wp_doing_ajax()) {
        add_action('wp_ajax_nopriv_get_ajax_data', 'get_ajax_data');
        add_action('wp_ajax_get_ajax_data', 'get_ajax_data');
        add_action('wp_ajax_apply_now_form', 'apply_now_form');
        add_action('wp_ajax_nopriv_apply_now_form', 'apply_now_form');
    }
    add_action('wp_enqueue_scripts', 'dc_custom_styles_scripts');
    add_action('wp_enqueue_scripts', 'loanforms_custom_styles_scripts');
    
    function get_ajax_data()
    {
        $type = $_POST['data_type'];
        if ( ! isset($type)) wp_die();
        $output = '';
        
        switch ($type) {
            case 'privacy_policy':
                $privacy_policy_page_id = (int)get_option('wp_page_for_privacy_policy');
                $output                 .= ($privacy_policy_page_id) ? get_post($privacy_policy_page_id)->post_content : '';
                break;
            case 'terms_conditions':
            default:
                $post   = get_post(get_terms_page_link()->id);
                $output .= ($post) ? $post->post_content : '';
                break;
        }
        echo wpautop($output);
        wp_die();
    }
    
    function apply_now_form()
    {
        $lead_data     = array();
        $ajax_response = array();
        
        $lead_data['apiId']       = '28388B4FD02411EB811742010A5C502D';
        $lead_data['apiPassword'] = 'd4a9425f3d';
        //$lead_data['testMode']               = 1;
        $lead_data['productId']              = 1;
        $lead_data['price']                  = 0;
        $lead_data['loanAmount']             = (int)$_POST['tr']['loanamount'];
        $lead_data['workCompanyName']        = (string)$_POST['workCompanyName'];
        $lead_data['activeMilitary']         = (string)$_POST['tr']['activemilitary'];
        $lead_data['ssn']                    = (string)$_POST['ssn'];
        $lead_data['driversLicenseNumber']   = (string)$_POST['driversLicenseNumber'];
        $lead_data['incomeType']             = (string)$_POST['tr']['incometype'];
        $lead_data['incomePaymentFrequency'] = (string)$_POST['tr']['incomepaymentfrequency'];
        $lead_data['incomeNetMonthly']       = (int)$_POST['tr']['incomenetmonthly'];
        $lead_data['incomeNextDate1']        = date("Y-m-d", strtotime((string)$_POST['tr']['incomenextdate1']));
        $lead_data['incomeNextDate2']        = date("Y-m-d", strtotime((string)$_POST['tr']['incomenextdate2']));
        $lead_data['bankDirectDeposit']      = (string)$_POST['tr']['bankdirectdeposit'];
        $lead_data['bankAba']                = (string)$_POST['aba'];
        $lead_data['bankAccountNumber']      = (string)$_POST['tr']['bankaccountnumber'];
        $lead_data['bankAccountType']        = (string)$_POST['tr']['bankaccounttype'];
        $lead_data['firstName']              = (string)$_POST['first-name']; // 1-64
        $lead_data['lastName']               = (string)$_POST['last-name']; // 1-64
        $lead_data['dob']                    = $_POST['tr']['year'] . "-" . $_POST['tr']['month'] . "-" . $_POST['tr']['day'];
        $lead_data['address']                = (string)$_POST['address']; // 1-256
        $lead_data['zip']                    = (int)$_POST['zipcode']; // 5
        $lead_data['email']                  = (string)$_POST['e-mail']; // 5-100
        $lead_data['homePhone']              = (string)$_POST['homePhone'];
        $lead_data['workPhone']              = (string)$_POST['workPhone'];
        $lead_data['userIp']                 = (string)$_SERVER['REMOTE_ADDR'];
        
        if (defined('SENDING_DATA_SIMULATE')) { // local testing mode
            $lead_sold = 2;
            sleep(5);
            if ($lead_sold == 1) { // SOLD
                $ajax_response['status']       = 1;
                $ajax_response['redirect_url'] = "https:\/\/leads.zeroparallel.com\/redirect?id=a5bf
c9e07964f8dddeb95fc584cd965d";
            } else { // REJECT or ERROR
                $ajax_response['status']  = 2;
                $ajax_response['message'] = show_reject_message();
            }
        } else { // sending to remote API
            $url = 'https://leads.zeroparallel.com/lead/';
            $ch  = curl_init($url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $lead_data);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array("Expect:"));
            curl_setopt($ch, CURLOPT_FAILONERROR, false);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 120);
            curl_setopt($ch, CURLINFO_HEADER_OUT, true);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            
            if ( ! curl_errno($ch)) {
                $ajax_response = json_decode(curl_exec($ch)); // Object
                curl_close($ch);
                if ($ajax_response->status > 1) $ajax_response->message = show_reject_message();
            }
        }
        echo json_encode($ajax_response);
        wp_die();
    }
    
    function show_reject_message(): string
    {
        $html = '<div class="aftersending-message">';
        $html .= reject_content()->content;
        $html .= '</div>';
        
        return $html;
    }
    
    function loanforms_custom_styles_scripts()
    {
        if ( ! wp_script_is('jquery')) wp_enqueue_script('jquery');
        if ( ! wp_script_is('jquery-ui-datepicker')) wp_enqueue_script('jquery-ui-datepicker');
        if ( ! wp_script_is('validation')) wp_enqueue_script('jq_validation', plugins_url('/js/jquery-validation-1.19.3/dist/jquery.validate.min.js', __FILE__), null);
        if ( ! wp_script_is('steps')) wp_enqueue_script('jq_steps', plugins_url('/js/jquery.steps-1.1.0/jquery.steps.min.js', __FILE__), null);
        if ( ! wp_script_is('masking')) wp_enqueue_script('jq_mask', plugins_url('/js/jquery.maskedinput.min.js', __FILE__), array(), false, true);
        if ( ! wp_script_is('fancybox')) wp_enqueue_script('fancybox', plugins_url('/js/fancybox-master/dist/jquery.fancybox.min.js', __FILE__), null);
        wp_enqueue_script('actions', plugins_url('/js/lf-actions.min.js', __FILE__), array(), false, true);
        
        wp_enqueue_style('apply_styles', plugins_url('/css/style.css', __FILE__), array(), null);
        wp_enqueue_style('fancybox', plugins_url('/js/fancybox-master/dist/jquery.fancybox.min.css', __FILE__), array(), null);
        wp_enqueue_style('fas', plugins_url('../../themes/Semantic-UI-WordPress-release-1.0.0-beta2/src/assets/styles/font-awesome.min.css', __FILE__), array(), null);
    }
    
    
    add_shortcode('largeform', 'largeform');
    
    function loan_amount_select($loan_select_label = "Select Loan amount", $select_class = null, $show_label = true, $default_option = "Select loan amount"): object
    {
        $form         = tr_form('post');
        $loan_amounts = [
            $default_option => null,
            '$100'          => 100,
            '$200'          => 200,
            '$300'          => 300,
            '$400'          => 400,
            '$500'          => 500,
            '$600'          => 600,
            '$700'          => 700,
            '$800'          => 800,
            '$900'          => 900,
            '$1,000'        => 1000,
            '$2,000'        => 2000,
            '$3,000'        => 3000,
            '$4,000'        => 4000,
            '$5,000'        => 5000,
            '$6,000'        => 6000,
            '$7,000'        => 7000,
            '$8,000'        => 8000,
            '$9,000'        => 9000,
            '$10,000'       => 10000,
            '$15,000'       => 15000,
            '$20,000'       => 20000,
            '$25,000'       => 25000,
            '$30,000'       => 30000,
            '$35,000'       => 35000
        ];
        if ( ! $select_class) $select_class = 'form-control form-control-lg';
        $loan_amount = $form->select("loanamount", [
            'class'    => $select_class,
            'required' => true,
        ])
            ->setOptions($loan_amounts);
        ($show_label) ? $loan_amount->label($loan_select_label) : $loan_amount->label(false);
        $get_loanamount = (isset($_GET['tr']['loanamount'])) ? (string)$_GET['tr']['loanamount'] : false;
        if ($get_loanamount) $loan_amount->setDefault($get_loanamount);
        
        return $loan_amount;
    }
    
    function largeform(): string
    {
        
        $form = tr_form();
        
        $month_income_label         = "Select";
        $y_label                    = "Select year";
        $m_label                    = "Select month";
        $d_label                    = "Select day";
        $pay_frequency_label        = "Pay Frequency";
        $start_date_label           = "Next Paydate 1";
        $finish_date_label          = "Next Paydate 2";
        $aba_label                  = "ABA / Routing Number";
        $account_number_label       = "Account Number";
        $aba_help_choose_bank_label = "Please, choose your bank";
        $aba_help_location_label    = "What location was this account opened in?";
        $direct_deposit_label       = "Direct Deposit";
        $account_type_label         = "Type of Account";
        $email_sms_label            = 'I consent to receive telephone calls (including SMS text messages) as explained <a data-fancybox data-src="#smsrules" href="javascript:;">here</a>. <strong>(This message is not a condition to obtaining a loan or any services)</strong>';
        
        $monthly_incomes = [
            $month_income_label => null,
            'More than $5,000'  => 6000,
            '$4,501 - $5,000'   => 5000,
            '$4,001 - $4,500'   => 4500,
            '$3,501 - $4,000'   => 4000,
            '$3,001 - $3,500'   => 3500,
            '$2,501 - $3,000'   => 3000,
            '$2,001 - $2,500'   => 4500,
            '$1,501 - $2,000'   => 2000,
            '$1,000 - $1,500'   => 1500,
        ];
        
        
        $email = $form->input('E-mail', [
            'name'     => 'e-mail',
            'class'    => 'form-control form-control-sm',
            'type'     => 'email',
            'required' => true
        ]);
        
        $monthly_incomes = $form->select("incomeNetMonthly")
            ->setLabel("Monthly Net Income")
            ->setOptions($monthly_incomes)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $months         = [
            $m_label => null,
            'Jan'    => '01',
            'Feb'    => '02',
            'Mar'    => '03',
            'Apr'    => '04',
            'May'    => '05',
            'Jun'    => '06',
            'Jul'    => '07',
            'Aug'    => '08',
            'Sep'    => '09',
            'Oct'    => '10',
            'Nov'    => '11',
            'Dec'    => '12'
        ];
        $days           = array();
        $days[$d_label] = null;
        for ($i = 1; $i < 32; $i++) {
            $day_num  = ($i < 10) ? "0" . $i : $i;
            $days[$i] = $day_num;
        }
        
        $years           = array();
        $years[$y_label] = null;
        for ($i = date('Y') - 18; $i > date('Y') - 98; $i--) {
            $years[$i] = $i;
        }
        
        $dob_day = $form->select("Day")
            ->setOptions($days)
            ->setAttribute('class', 'form-control form-control-sm');
        
        $dob_mon = $form->select("Month")
            ->setOptions($months)
            ->setAttribute('class', 'form-control form-control-sm');
        
        $dob_year = $form->select("Year")
            ->setOptions($years)
            ->setAttribute('class', 'form-control form-control-sm');
        
        
        $income_source_label = "Income Source";
        $income_type_options = [
            'Job Income' => 'EMPLOYMENT',
            'Benefits'   => 'BENEFITS'
        ];
        $income_source       = $form->radio("incomeType")
            ->label($income_source_label)
            ->setOptions($income_type_options)
            ->attr('required', true);
        
        
        $military_label   = "Active Military";
        $military_options = ['Yes' => 'YES', 'No' => 'NO'];
        
        $active_military = $form->radio("activeMilitary")
            ->label($military_label)
            ->setOptions($military_options)
            ->attr('required', true);
        
        $pay_frq_options = [
            "Select"      => null,
            'Weekly'      => "WEEKLY",
            'Biweekly'    => "BIWEEKLY",
            'Semimonthly' => "TWICEMONTHLY",
            'Monthly'     => "MONTHLY"
        ];
        
        $banks_select_options = [
            "Select" => null
        ];
        $banks_state_options  = [
            "Bank State" => null
        ];
        
        $banks_select = $form->select("bankName")
            ->setOptions($banks_select_options)
            ->label($aba_help_choose_bank_label)
            ->setAttribute('class', 'form-control form-control-sm');
        
        $banks_states = $form->select("bankState")
            ->setOptions($banks_state_options)
            ->label($aba_help_location_label)
            ->setAttribute('class', 'form-control form-control-sm');
        
        $pay_frequency = $form->select("incomePaymentFrequency")
            ->setLabel($pay_frequency_label)
            ->setOptions($pay_frq_options)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $start_paydate = $form->input("incomeNextDate1")
            ->label($start_date_label)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $finish_paydate = $form->input("incomeNextDate2")
            ->label($finish_date_label)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $aba = $form->input('ABA / Routing Number', ['name' => 'aba'])
            ->label($aba_label)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $account_number = $form->input("bankAccountNumber")
            ->label($account_number_label)
            ->setAttribute('class', 'form-control form-control-sm')
            ->attr('required', true);
        
        $direct_deposit_options = ['Yes' => 'YES', 'No' => 'NO'];
        $direct_deposit         = $form->radio("bankDirectDeposit")
            ->label($direct_deposit_label)
            ->setOptions($direct_deposit_options)
            ->attr('required', true);
        
        $account_type_options = ['Checking' => 'CHECKING', 'Saving' => 'SAVING'];
        $account_type         = $form->radio("bankAccountType")
            ->label($account_type_label)
            ->setOptions($account_type_options)
            ->attr('required', true);
        
        
        $email_sms      = $form->checkbox("consentEmailSms")->label($email_sms_label);
        $first_name     = $form->text('First Name', ['name' => 'first-name', 'class' => 'form-control form-control-sm'])->attr('required', true);
        $last_name      = $form->text('Last Name', ['name' => 'last-name', 'class' => 'form-control form-control-sm'])->attr('required', true);
        $street         = $form->text('Street Address', ['name' => 'address'])->setAttribute('class', 'form-control form-control-sm')->attr('required', true);
        $zip            = $form->input('Zip Code', ["name" => "zipcode"])->setType('number')->setAttribute('class', 'form-control form-control-sm')->attr('required', true);
        $employer       = $form->text('Employer Name', ['name' => 'workCompanyName', 'class' => 'form-control form-control-sm'])->attr('required', true);
        $driver_license = $form->text('Driver License', ['name' => 'driversLicenseNumber', 'class' => 'form-control form-control-sm'])->attr('required', true);
        $ssn            = $form->text('Social Security Number', ['name' => 'ssn', 'class' => 'form-control form-control-sm'])->setType('tel')->attr('required', true)->attr('placeholder', '___-__-____');
        $primary_phone  = $form->text('Primary Phone', ['name' => 'homePhone', 'class' => 'form-control form-control-sm'])->setType('tel')->attr('required', true)->attr('placeholder', '(___) ___-____');
        $employer_phone = $form->text('Employer Phone', ['name' => 'workPhone', 'class' => 'form-control form-control-sm'])->setType('tel')->attr('required', true)->attr('placeholder', '(___) ___-____');
        
        $loan_amount = loan_amount_select();
        if (defined('PREFILL_FORM')) {
            $loan_amount->setDefault(500);
            $email->setDefault('dr.yurets@gmail.com');
            $first_name->setDefault('Yury');
            $last_name->setDefault('Andreikin');
            $dob_mon->setDefault(07);
            $dob_year->setDefault(1982);
            $dob_day->setDefault(15);
            $street->setDefault('A.Kuleshova str., 28/56');
            $zip->setDefault(78945);
            $employer->setDefault('Ivan Ivanovich Ivanov');
            $driver_license->setDefault('112233445566');
            $ssn->setDefault('987654321');
            $primary_phone->setDefault('5557778899');
            $employer_phone->setDefault('9998887766');
            $monthly_incomes->setDefault(4000);
            $income_source->setDefault('EMPLOYMENT');
            $active_military->setDefault('NO');
            $pay_frequency->setDefault('WEEKLY');
            $start_paydate->setDefault('03/23/2021');
            $finish_paydate->setDefault('04/02/2021');
            //$aba->setDefault('222558866');
            $account_number->setDefault('4455667788');
            $direct_deposit->setDefault('YES');
            $account_type->setDefault('SAVING');
        } elseif (isset($_GET['tr']['loanamount'])) { // переход из короткой формы
            (isset($_GET['e-mail'])) ? $email->setDefault($_GET['e-mail']) : false;
            (isset($_GET['first-name'])) ? $first_name->setDefault($_GET['first-name']) : false;
            (isset($_GET['last-name'])) ? $last_name->setDefault($_GET['last-name']) : false;
        }
        
        /* Fields definition End */
        ob_start();
        echo $form->open([
            'id' => 'large_form'
        ]);
        
        ?>
		<div id="form_content">
			<div class="row">
				<div class="col-sm-12">
					<div class="form_header">
						<p>Our service allows you to compare rates from multiple lenders by filling out one easy
							form.</p>
						<p class="security"><i class="fa fa-shield"></i> We use 256-bit encryption
							to keep your information safe!</p>
						<h1 id="form-title">Submit Your Request In 3 Steps:</h1>
					</div>
				</div>
			</div>
			<div class="form_steps">
				<h3>Personal Information</h3>
				<section class="form_page_0">
					<div class="row">
						<div class="col-sm-12 form_page_title"><p><span>1</span> Personal Information</p></div>
					</div>
					<div class="row">
						<div class="col-sm-6"><?php echo $loan_amount; ?></div>
						<div class="col-sm-6"><?php echo $email; ?></div>
					</div>
					<div class="row">
						<div class="col-sm-6"><?php echo $first_name; ?></div>
						<div class="col-sm-6"><?php echo $last_name; ?></div>
					</div>
					<div class="row">
						<div class="col-sm-6 dob">
							<div class="row">
								<div class="col-sm-4"><?php echo $dob_mon; ?></div>
								<div class="col-sm-4"><?php echo $dob_day; ?></div>
								<div class="col-sm-4"><?php echo $dob_year; ?></div>
							</div>
						</div>
						<div class="col-sm-4"><?php echo $street; ?></div>
						<div class="col-sm-2"><?php echo $zip; ?>
							<span id="errmsg"></span></div>
					</div>
				</section>
				<h3>Additional Information</h3>
				<section class="form_page_1">
					<div class="form_page_title"><p><span>2</span> Additional Information</p></div>
					<div class="row">
						<div class="col-sm-4"><?php
                                echo $employer; ?>
						</div>
						<div class="col-sm-4"><?php
                                echo $driver_license;
                            ?></div>
						<div class="col-sm-4"><?php
                                echo $ssn;
                            ?></div>
					</div>
					<div class="row">
						<div class="col-sm-4"><?php echo $primary_phone; ?></div>
						<div class="col-sm-4"><?php echo $employer_phone; ?></div>
						<div class="col-sm-4"><?php echo $monthly_incomes; ?></div>
					</div>
					<div class="row">
						<div class="col-sm-6 income"><?php echo $income_source; ?></div>
						<div class="col-sm-6 income"><?php echo $active_military; ?></div>
					</div>
				</section>
				<h3>Your Transfer Details</h3>
				<section class="form_page_2">
					<div class="form_page_title"><p><span>3</span> Your Transfer Details</p></div>
					<div class="row">
						<div class="col-sm-4"><?php echo $pay_frequency; ?></div>
						<div class="col-sm-4"><?php echo $start_paydate; ?></div>
						<div class="col-sm-4"><?php echo $finish_paydate; ?></div>
					</div>

					<div id="aba-help">
						<div class="aba-lookup-container row">
							<div id="bankAba" class="col-sm-6"><?php echo $aba; ?></div>
							<div class="col-sm-6"><?php echo $account_number; ?></div>
							<div class="col-sm-12 secured_data">
								<p>Your data is secured using industry standard for the site information security.<br/>
									Your <strong>ABA / Routing Number</strong> can be found on most bank statements as
									well as on the
									bottom of your checks. </p>
							</div>
							<div class="col-sm-12 aba-help">
								<a data-fancybox="aba_help" href="<?php echo PLUGIN_URL; ?>images/check_ex.png">
									<img alt="ABA Help" class="aba_help lightbox"
									     src="<?php echo PLUGIN_URL; ?>images/check_ex.png"/>
								</a>
								<a class="btn btn-small toggle-aba-help" href="#">Need help? Use our ABA lookup</a>
								<div id="aba-help-fields" class="hidden col-sm-12 row">
									<div class="col-sm-6"><?php echo $banks_select; ?></div>
									<div class="col-sm-6"><?php echo $banks_states; ?></div>
								</div>
							</div>
						</div>
					</div>

					<div class="row">
						<div class="col-sm-6"><?php echo $direct_deposit; ?></div>
						<div class="col-sm-6"><?php echo $account_type; ?></div>
					</div>
					<div class="row terms">
						<div class="col-sm-12">
							<p class="terms">By submitting my request, I acknowledge I have read, understand, and agree
								to the terms of the <a data-fancybox data-type="" data-src="" data-filter="" href="#"
								                       class="doc_link privacy_link">Privacy Policy</a> and the <a
										data-fancybox data-type="" data-src="" data-filter="" href="#"
										class="doc_link terms_link">Terms &amp; Conditions of Use Agreement</a>. I also
								understand I may be contacted by telephone by a lender concerning my loan request.</p>
						</div>
						<div class="col-sm-12 email-sms"><?php echo $email_sms; ?></div>
					</div>
					<div id="smsrules" class="sms-rules" style="display: none;">
						<h3>Your consent to receive communications</h3>
						<p>You will receive additional loan offers and other communications, including
							marketing and telemarketing communications, from marketing partners via
							emails, telephone calls, text messages, and SMS on the landline or mobile
							telephone number that you provided, even if you are on a Federal or State
							Do-Not-Call registry. The calls, text messages, and SMS messages may be
							generated using an auto-dialer or may employ an artificial or prerecorded
							voice. Standard message and data rates may apply to text or SMS
							communications.</p>
					</div>
				</section>
				<h3>Result</h3>
				<section class="results">
					<div class="row">
						<div id="sending_text" class="preloader_text col-sm-12">
							<h4>We are currently searching our network to match you with a lender</h4>
							<div class="ajaxloader">
								<div class="cssload-loader"></div>
							</div>
							<p class="note">Please keep in mind that different terms may apply to your loan, including
								Annual Percentage Rates (APRs) which may greatly exceed 36%. You should carefully review
								any and all terms, conditions, and policies provided to you by a lender, if offered a
								loan. APRs, terms &amp; conditions and policies may vary from lender to lender. You are
								under no obligation to accept any loan offered to you.
							</p>
							<span>PLEASE DO NOT CLOSE THIS
									WINDOW – IF MATCHED, YOU WILL BE REDIRECTED TO A LENDER’S WEBSITE IN A FEW
									MOMENTS.</span>
							<div class="interstitial_disclaimer">
								<p>
									<strong>Legal Disclaimer:</strong> The operator of this website is not a lender,
									loan broker or agent for any lender or loan broker and does not make credit
									decisions. We are a referral service that may be able to match you with a
									participating lender in our network. There is no guarantee we will be able to match
									you with a lender and not all lenders can provide loans of up to a $1,000. Each
									lender in our network may have different terms, conditions and/or policies that may
									apply to your loan, including Annual Percentage Rates (APRs) greatly exceeding 36%.
									Residents of some states may not be eligible for some or all short-term, small
									dollar loans. Loans from states having no limiting laws and/or loans from lenders
									that are not governed by limiting laws may have even higher APRs than loans governed
									by limiting laws. You should review any such terms the lender provides you carefully
									before making a decision. You are not obligated to accept any loan offered to you.
									For details and questions regarding any loan offer, loan terms, repayment, APRs, and
									other policies, please contact the lender directly. Lenders in our network may
									perform credit checks with credit reporting bureaus or obtain consumer reports,
									typically from alternative providers to determine credit worthiness, and to verify
									your identity and the information you provide. Short-term loans are not intended to
									be a solution to debt and credit difficulties. Consider seeking professional
									financial and/or legal advice regarding your financial needs, risk and alternatives
									to short-term loans.
								</p>
							</div>
						</div>
						<div id="ajax_response" class="col-sm-12 hidden"></div>
					</div>
				</section>
			</div>
		</div>
		<input type="hidden" name="action" value="apply_now_form"/>
        <?php
        echo $form->close();
        ?>
		<div class="row ajax_response"></div><?php
        return ob_get_clean();
    }
    
    function get_terms_page_link()
    {
        
        $terms_page = array(
            'post_type'  => 'page',
            'meta_query' => array(
                array('key'     => 'terms_page',
                      'value'   => '1',
                      'compare' => '='
                ),)
        );
        $myposts    = get_posts($terms_page);
        $data       = new stdClass();
        
        foreach ($myposts as $post) {
            setup_postdata($post);
            $data->id         = $post->ID;
            $data->post_title = $post->post_title;
            $data->link       = get_permalink($post->ID);
        }
        wp_reset_postdata();
        
        return $data;
    }
    
    function reject_content()
    {
        
        $terms_page = array(
            'post_type'  => 'page',
            'meta_query' => array(
                array('key'     => 'reject_content',
                      'value'   => '1',
                      'compare' => '='
                ),)
        );
        $myposts    = get_posts($terms_page);
        $data = new stdClass();
        foreach ($myposts as $post) {
            setup_postdata($post);
            $data->id = $post->ID;
            $data->content = $post->post_content;
        }
        wp_reset_postdata();
        
        return $data;
    }
    
    function get_apply_online_page()
    {
        $terms_page = array(
            'post_type'  => 'page',
            'meta_query' => array(
                array('key'     => 'apply_online',
                      'value'   => '1',
                      'compare' => '='
                ),)
        );
        $myposts    = get_posts($terms_page);
        $data       = new stdClass();
        
        foreach ($myposts as $post) {
            setup_postdata($post);
            $data->id = $post->ID;
            $data->url = $post->post_name . '/';
        }
        wp_reset_postdata();
        
        return $data;
    }
    
    add_shortcode('frontpage_loanform', 'frontpage_loanform');
    function frontpage_loanform($atts)
    {
        $atts = shortcode_atts(array(
            'class' => null,
            'h1'    => null,
        
        ), $atts);
        
        $custom_class = (isset($atts['class'])) ? (string)$atts['class'] : '';
        if (isset($atts['h1'])) {
            $open_sm_div  = '<div class="lf_sm">';
            $close_sm_div = '</div>';
        } else {
            $open_sm_div  = '';
            $close_sm_div = '';
            
        }
        $form = tr_form();
        $form->toUrl(get_apply_online_page()->url);
        
        $loan_amount = loan_amount_select(false, false);
        
        $email = $form->input('E-mail', [
            'name'        => 'e-mail',
            'class'       => 'form-control form-control-lg',
            'type'        => 'email',
            'id'          => 'inputEmail',
            'required'    => true,
            'placeholder' => 'E-mail'
        ])->label(false);
        
        $first_name = $form->text('First Name', ['name' => 'first-name', 'class' => 'form-control', 'placeholder' => 'First name'])->attr('required', true)->label(false);
        $last_name  = $form->text('Last Name', ['name' => 'last-name', 'class' => 'form-control', 'placeholder' => 'Last name'])->attr('required', true)->label(false);
        
        
        ob_start();
        
        echo $open_sm_div;
        ?>
		<!-- frontpage_loanform begin -->
		<div class="quickform_container <?php echo $custom_class; ?>">
			<div class="quickform"><?php
                    
                    echo $form->open([
                        'id'     => 'frontpage_form' . $custom_class,
                        'method' => 'GET',
                    ]);
                ?>

				<div class="form_header">
					<h2>Free <span>application</span> form</h2>
					<ul class="form_ribbons">
						<li>$100 - $1000 Payday Loans</li>
						<li>$1000 - $35000 Installments Loans</li>
					</ul>
					<ul class="checkboxes">
						<li>✔️ Bad credit history doesn't matter</li>
						<li>✔️ Applying does NOT affect your credit score!</li>
						<li>✔️ Competitive rates and fees from 300+ US Direct Lenders</li>
					</ul>
				</div>
				<div class="form_body">
					<div class="form-group"><?php echo $loan_amount; ?></div>
					<div class="form-group relative"><?php echo $email; ?>
					</div>
					<div class="form-group names">
						<div class="row">
							<div class="col-sm-6"><?php echo $first_name; ?></div>
							<div class="col-sm-6"><?php echo $last_name; ?></div>

						</div>
					</div>
					<div class="submit">
						<input type="submit" value="Apply now"
						       class="btn btn-lg quickform text-light"><?php echo $form->close(); ?>
					</div>
				</div>
				<div class="form_footer">
					<p class="secured"><i class="fas fa-shield"></i> We keep your personal information secured!</p>
					<p class="pr_po">By submitting your information you agree to <a
								href="<?php echo get_privacy_policy_url(); ?>">Privacy Policy</a>, <a
								href="https://usapaydayloansdl.com/terms-conditions/">Terms of Use</a> and
						Responsible Lending Practices</p>
				</div>

			</div>
		</div>
		<!-- frontpage_loanform end -->
        <?php
        echo $close_sm_div;
        
        return ob_get_clean();
    }
    
    add_shortcode('banner', 'banner_shortcode');
    
    function banner_shortcode($atts): string
    {
        $atts = shortcode_atts(array(
            'design'  => 1,
            'class'   => 'lfb',
            'title'   => "Free application form",
            'content' => "$100 - $1000 Payday Loans",
            'email'   => null,
            'button'  => 'Apply now',
        ), $atts);
        
        $banner_img = get_image_by_desc('bn' . $atts['design']);
        if ($banner_img) {
            //add_action('wp_head', 'generate_inline_css', 10);
        }
        
        $form = tr_form();
        $form->toUrl(get_apply_online_page()->url);
        $loan_amount = loan_amount_select(false, false);
        $output      = '<div class="' . $atts['class'] . '_' . $atts['design'] . '"><div class="lfb_container">';
        $output      .= $form->open([
            'method' => 'GET',
            'class'  => 'bnr_form_' . $atts['design']
        ]);
        $output      .= '<div class="form_header"><h3>' . $atts['title'] . '</h3></div>';
        $output      .= '<div class="form_content"><p>' . $atts['content'] . '</p></div>';
        $output      .= '<div class="form_body"><div class="form-group">' . $loan_amount . '</div>';
        
        if (isset($atts['email'])) {
            $email = $form->input('E-mail', [
                'name'        => 'e-mail',
                'class'       => 'form-control form-control-lg',
                'type'        => 'email',
                'id'          => 'inputEmail',
                'placeholder' => 'E-mail',
                'required'    => true
            ])->label(false);
            
            $output .= '<div class="form-group relative">' . $email . '</div>';
            //$output .= '<label for="inputEmail" class="related_label_for_email">Email</label>';
        }
        
        $output .= '</div><div class="form_footer"><input type="submit" value="' . $atts['button'] . '" class="btn btn-lg quickform"></div>';
        $output .= $form->close();
        $output .= '</div></div>';
        
        
        return $output;
    }
    
    function generate_inline_css($path): string
    {
        $css = '<style>';
        $css .= 'div.lfb_1{border: 2px red solid}';
        $css .= '</style>';
        
        echo $css;
    }
    
    add_shortcode('sidebar_loanform', 'sidebar_loanform');
    
    function sidebar_loanform($atts)
    {
        ob_start();
        
        $atts = shortcode_atts(
            array(
                'class'  => 'lf_sm',
                'h1'     => 'Free application form',
                'button' => 'Apply now',
                'email'  => null,
                'names'  => null
            ), $atts);
        
        $form = tr_form();
        $form->toUrl(get_apply_online_page()->url);
        
        $loan_amount = loan_amount_select(false, false);
        
        if (isset($atts['email'])) {
            $email = $form->input('E-mail', [
                'name'        => 'e-mail',
                'class'       => 'form-control form-control-lg',
                'type'        => 'email',
                'id'          => 'inputEmail',
                'button'      => 'Apply now',
                'placeholder' => 'Email',
                'required'    => true
            ])->label(false);
        }
        if (isset($atts['names'])) {
            $first_name = $form->text('First Name', ['name' => 'first-name', 'class' => 'form-control form-control-lg', 'placeholder' => 'First name'])->attr('required', true)->label(false);
            $last_name  = $form->text('Last Name', ['name' => 'last-name', 'class' => 'form-control form-control-lg', 'placeholder' => 'Last name'])->attr('required', true)->label(false);
        }
        $terms_page = get_terms_page_link();
        
        ?>
	<div class="<?php echo $atts['class'] ?>">
		<div class="quickform_container <?php echo $atts['class'] ?>">
			<div class="quickform"><?php
                    echo $form->open([
                        'id'     => 'sidebar_form',
                        'method' => 'GET',
                    ]);
                ?>

				<div class="form_header">
					<h2>Free <span>application</span> form</h2>
					<ul class="form_ribbons">
						<li>$100 - $1000 Payday Loans</li>
						<li>$1000 - $35000 Installments Loans</li>
					</ul>
					<ul class="checkboxes">
						<li>✔️ Bad credit history doesn't matter</li>
						<li>✔️ Applying does NOT affect your credit score!</li>
						<li>✔️ Competitive rates and fees from 300+ US Direct Lenders</li>
					</ul>
				</div>
				<div class="form_body">
					<div class="form-group"><?php echo $loan_amount; ?></div><?php
                        if (isset($email)) {
                            ?>
							<div class="form-group relative"><?php echo $email; ?>
							</div><?php
                        } // email field end
                        if (isset($first_name) && isset($last_name)) {
                            ?>
							<div class="form-group names">
							<div class="row">
								<div class="col-sm-6"><?php echo $first_name; ?></div>
								<div class="col-sm-6"><?php echo $last_name; ?></div>
							</div>
							</div><?php // names field end
                        }
                    ?>
					<div class="submit">
						<input type="submit" value="<?php echo $atts['button'] ?>"
						       class="btn btn-lg btn-primary text-light"><?php
                            echo $form->close();
                        ?>
					</div>

				</div>
				<div class="form_footer">
					<p class="secured"><i class="fa fa-shield"></i>&nbsp;We keep your personal information secured!</p>
					<p class="pr_po">By submitting your information you agree to <a
								href="<?php echo get_privacy_policy_url(); ?>">Privacy Policy</a>, <a
								href="<?php echo $terms_page->link; ?>">Terms of Use</a> and
						Responsible Lending Practices</p>
				</div>
			</div>
		</div>
		</div><?php
        return ob_get_clean();
    }
    
    if ( ! (function_exists('get_image_by_desc'))) {
        function get_image_by_desc($descr)
        {
            $args           = array(
                'posts_per_page' => 1,
                'post_type'      => 'attachment',
                'name'           => trim($descr),
            );
            $get_attachment = new WP_Query($args);
            if ( ! $get_attachment || ! isset($get_attachment->posts, $get_attachment->posts[0])) {
                return false;
            }
            
            return $get_attachment->posts[0];
        }
    }