(function ($) {

    let large_form = $("form#large_form");
    ccABAInfo = {
        "bancorp": {"name": "Bancorp", "states": [{"name": "All Locations", "aba": "031101114"}]},
        "bankofamerica": {
            "name": "Bank of America",
            "states": [{"name": "Alabama", "aba": "051000017"}, {
                "name": "Alaska",
                "aba": "051000017"
            }, {"name": "Arizona", "aba": "122101706"}, {"name": "Arkansas", "aba": "082000073"}, {
                "name": "California",
                "aba": "121000358"
            }, {"name": "Colorado", "aba": "123103716"}, {
                "name": "Connecticut",
                "aba": "011900571"
            }, {"name": "Delaware", "aba": "031202084"}, {
                "name": "District of Columbia",
                "aba": "054001204"
            }, {"name": "Florida East", "aba": "063000047"}, {
                "name": "Florida West",
                "aba": "063100277"
            }, {"name": "Georgia", "aba": "061000052"}, {"name": "Hawaii", "aba": "051000017"}, {
                "name": "Idaho",
                "aba": "123103716"
            }, {"name": "Illinois", "aba": "081904808"}, {"name": "Indiana", "aba": "071214579"}, {
                "name": "Iowa",
                "aba": "073000176"
            }, {"name": "Kansas", "aba": "101100045"}, {"name": "Kentucky", "aba": "051000017"}, {
                "name": "Louisiana",
                "aba": "051000017"
            }, {"name": "Maine", "aba": "011200365"}, {
                "name": "Maryland",
                "aba": "052001633"
            }, {"name": "Massachusetts", "aba": "011000138"}, {
                "name": "Michigan",
                "aba": "051000017"
            }, {"name": "Minnesota", "aba": "071214579"}, {
                "name": "Mississippi",
                "aba": "051000017"
            }, {"name": "Missouri East", "aba": "081000032"}, {
                "name": "Missouri West",
                "aba": "101000035"
            }, {"name": "Montana", "aba": "051000017"}, {"name": "Nebraska", "aba": "051000017"}, {
                "name": "Nevada",
                "aba": "122400724"
            }, {"name": "New Hampshire", "aba": "011400495"}, {
                "name": "New Jersey",
                "aba": "021200339"
            }, {"name": "New Mexico", "aba": "107000327"}, {
                "name": "New York",
                "aba": "021000322"
            }, {"name": "North Carolina", "aba": "053000196"}, {
                "name": "North Dakota",
                "aba": "051000017"
            }, {"name": "Ohio", "aba": "051000017"}, {"name": "Oklahoma", "aba": "103000017"}, {
                "name": "Oregon",
                "aba": "323070380"
            }, {"name": "Pennsylvania", "aba": "031202084"}, {
                "name": "Rhode Island",
                "aba": "011500010"
            }, {"name": "South Carolina", "aba": "053904483"}, {
                "name": "South Dakota",
                "aba": "051000017"
            }, {"name": "Tennessee", "aba": "064000020"}, {
                "name": "Texas, North",
                "aba": "111000025"
            }, {"name": "Texas, South", "aba": "113000023"}, {"name": "Utah", "aba": "051000017"}, {
                "name": "Vermont",
                "aba": "051000017"
            }, {"name": "Virginia", "aba": "051000017"}, {
                "name": "Washington",
                "aba": "125000024"
            }, {"name": "West Virginia", "aba": "051000017"}, {
                "name": "Wisconsin",
                "aba": "051000017"
            }, {"name": "Wyoming", "aba": "051000017"}]
        },
        "bbt": {
            "name": "Branch Bank",
            "states": [{"name": "Alabama", "aba": "062203984"}, {
                "name": "District of Columbia",
                "aba": "054001547"
            }, {"name": "Florida", "aba": "263191387"}, {"name": "Georgia", "aba": "061113415"}, {
                "name": "Indiana",
                "aba": "083974289"
            }, {"name": "Kentucky", "aba": "083900680"}, {
                "name": "Maryland",
                "aba": "055003308"
            }, {"name": "North Carolina", "aba": "053101121"}, {
                "name": "South Carolina",
                "aba": "053201607"
            }, {"name": "Tennessee", "aba": "064208165"}, {"name": "Texas", "aba": "111017694"}, {
                "name": "Virginia",
                "aba": "051404260"
            }, {"name": "West Virginia", "aba": "051503394"}]
        },
        "bonneville": {"name": "Bonneville Bank", "states": [{"name": "All Locations", "aba": "124302529"}]},
        "chase": {
            "name": "Chase Bank",
            "states": [{"name": "Arizona", "aba": "122100024"}, {
                "name": "California",
                "aba": "322271627"
            }, {"name": "Colorado", "aba": "102001017"}, {
                "name": "Connecticut",
                "aba": "021100361"
            }, {"name": "Florida", "aba": "267084131"}, {"name": "Georgia", "aba": "061092387"}, {
                "name": "Idaho",
                "aba": "123271978"
            }, {"name": "Illinois", "aba": "071000013"}, {"name": "Indiana", "aba": "074000010"}, {
                "name": "Kentucky",
                "aba": "083000137"
            }, {"name": "Louisiana", "aba": "065400137"}, {"name": "Michigan", "aba": "072000326"}, {
                "name": "Nevada",
                "aba": "322271627"
            }, {"name": "New Jersey", "aba": "021202337"}, {
                "name": "New York – Downstate",
                "aba": "021000021"
            }, {"name": "New York – Upstate", "aba": "022300173"}, {
                "name": "Ohio",
                "aba": "044000037"
            }, {"name": "Oklahoma", "aba": "103000648"}, {"name": "Oregon", "aba": "325070760"}, {
                "name": "Texas",
                "aba": "111000614"
            }, {"name": "Utah", "aba": "124001545"}, {
                "name": "Washington",
                "aba": "325070760"
            }, {"name": "West Virginia", "aba": "051900366"}, {"name": "Wisconsin", "aba": "075000019"}]
        },
        "fifththird": {
            "name": "Fifth Third Bank",
            "states": [{"name": "Florida - Central", "aba": "063109935"}, {
                "name": "Florida - North",
                "aba": "063113057"
            }, {"name": "Florida - South", "aba": "067091719"}, {
                "name": "Florida - Tampa",
                "aba": "063103915"
            }, {"name": "Georgia", "aba": "263190812"}, {
                "name": "Illinois",
                "aba": "071923909"
            }, {"name": "Indiana - Central", "aba": "074908594"}, {
                "name": "Indiana - Southern",
                "aba": "086300041"
            }, {"name": "Kentucky - Central", "aba": "042101190"}, {
                "name": "Kentucky - Northern",
                "aba": "042100230"
            }, {"name": "Kentucky - Southwestern", "aba": "083002342"}, {
                "name": "Michigan - Eastern",
                "aba": "072405455"
            }, {"name": "Michigan - Northern", "aba": "072401404"}, {
                "name": "Michigan - Western",
                "aba": "072400052"
            }, {"name": "Missouri", "aba": "081019104"}, {
                "name": "North Carolina",
                "aba": "053100737"
            }, {"name": "Ohio - Cincinnati", "aba": "042000314"}, {
                "name": "Ohio - Columbus",
                "aba": "044002161"
            }, {"name": "Ohio - Northeastern", "aba": "041002711"}, {
                "name": "Ohio - Northwestern",
                "aba": "041200050"
            }, {"name": "Ohio - Southern", "aba": "042207735"}, {
                "name": "Ohio - Western",
                "aba": "042202196"
            }, {"name": "Pennsylvania", "aba": "043018868"}, {"name": "Tennessee", "aba": "064103833"}]
        },
        "firstcalifornia": {"name": "First California Bank", "states": [{"name": "All Locations", "aba": "122244184"}]},
        "fnbtexas": {
            "name": "First National Bank Texas",
            "states": [{"name": "Arizona", "aba": "122106455"}, {
                "name": "New Mexico",
                "aba": "122106455"
            }, {"name": "Texas", "aba": "111906271"}]
        },
        "mt": {
            "name": "M&T Bank",
            "states": [{"name": "Delaware", "aba": "031302955"}, {
                "name": "District of Columbia",
                "aba": "052000113"
            }, {"name": "Maryland", "aba": "052000113"}, {
                "name": "New York",
                "aba": "022000046"
            }, {"name": "Pennsylvania", "aba": "031302955"}, {
                "name": "Virginia",
                "aba": "052000113"
            }, {"name": "West Virginia", "aba": "052000113"}]
        },
        "meta": {
            "name": "MetaBank",
            "states": [{"name": "MetaBank", "aba": "073972181"}, {
                "name": "MetaBank Memphis",
                "aba": "084003997"
            }, {"name": "Brookins Division - MetaBank", "aba": "291471024"}]
        },
        "navyfederal": {"name": "Navy Federal Credit Union", "states": [{"name": "All Locations", "aba": "256074974"}]},
        "pnc": {
            "name": "PNC Bank",
            "states": [{"name": "Delaware", "aba": "031100089"}, {
                "name": "Florida",
                "aba": "267084199"
            }, {"name": "Greater Washington Area", "aba": "054000030"}, {
                "name": "Illinois",
                "aba": "071921891"
            }, {"name": "Indiana", "aba": "071921891"}, {
                "name": "Kentucky",
                "aba": "083000108"
            }, {"name": "Kentucky - Northern", "aba": "042100188"}, {
                "name": "New Jersey",
                "aba": "031207607"
            }, {"name": "Michigan", "aba": "041000124"}, {"name": "Missouri", "aba": "071921891"}, {
                "name": "Ohio",
                "aba": "042000398"
            }, {"name": "Ohio Alternate", "aba": "041000124"}, {
                "name": "Ohio - Youngstown",
                "aba": "043000096"
            }, {"name": "Pennsylvania - Central, North", "aba": "043000096"}, {
                "name": "Pennsylvania - Central, South",
                "aba": "031312738"
            }, {"name": "Pennsylvania - Northeast", "aba": "031300012"}, {
                "name": "Pennsylvania - Northwest",
                "aba": "043300738"
            }, {"name": "Pennsylvania - Philadelphia", "aba": "031000053"}, {
                "name": "Pennsylvania - Pittsburgh",
                "aba": "043000096"
            }, {"name": "Wisconsin", "aba": "071921891"}]
        },
        "regions": {
            "name": "Regions Bank",
            "states": [{"name": "Alabama", "aba": "062000019"}, {
                "name": "Arkansas",
                "aba": "082000109"
            }, {"name": "Florida", "aba": "063104668"}, {"name": "Georgia", "aba": "061101375"}, {
                "name": "Illinois",
                "aba": "071122661"
            }, {"name": "Indiana", "aba": "074014213"}, {"name": "Iowa", "aba": "073900438"}, {
                "name": "Kentucky",
                "aba": "083901744"
            }, {"name": "Louisiana", "aba": "065403626"}, {
                "name": "Mississippi",
                "aba": "065305436"
            }, {"name": "Missouri", "aba": "081001387"}, {
                "name": "North Carolina",
                "aba": "053012029"
            }, {"name": "South Carolina", "aba": "053201814"}, {
                "name": "Tennessee",
                "aba": "064000017"
            }, {"name": "Texas", "aba": "111900785"}, {"name": "Virginia", "aba": "051009296"}]
        },
        "suntrust": {"name": "SunTrust Bank", "states": [{"name": "All Locations", "aba": "061000104"}]},
        "td": {
            "name": "TD Bank",
            "states": [{"name": "Connecticut", "aba": "011103093"}, {
                "name": "Delaware",
                "aba": "031201360"
            }, {"name": "District of Columbia", "aba": "054001725"}, {
                "name": "Florida",
                "aba": "067014822"
            }, {"name": "Maine", "aba": "211274450"}, {
                "name": "Maryland",
                "aba": "054001725"
            }, {"name": "Massachusetts", "aba": "211370545"}, {
                "name": "New Hampshire",
                "aba": "011400071"
            }, {"name": "New Jersey", "aba": "031201360"}, {
                "name": "New York - Metro",
                "aba": "026013673"
            }, {"name": "New York - Upstate", "aba": "021302567"}, {
                "name": "North Carolina",
                "aba": "053902197"
            }, {"name": "Pennsylvania", "aba": "036001808"}, {
                "name": "Rhode Island",
                "aba": "211370545"
            }, {"name": "South Carolina", "aba": "053902197"}, {
                "name": "Vermont",
                "aba": "011600033"
            }, {"name": "Virginia", "aba": "054001725"}]
        },
        "usaa": {"name": "USAA Federal Savings Bank", "states": [{"name": "All Locations", "aba": "314074269"}]},
        "usbank": {
            "name": "US Bank",
            "states": [{"name": "Arizona", "aba": "122105155"}, {
                "name": "Arkansas",
                "aba": "082000549"
            }, {"name": "California - Northern", "aba": "121122676"}, {
                "name": "California - Southern",
                "aba": "122235821"
            }, {"name": "Colorado - Aspen", "aba": "102101645"}, {
                "name": "Colorado - All other areas",
                "aba": "102000021"
            }, {"name": "Idaho", "aba": "123103729"}, {
                "name": "Illinois - Northern",
                "aba": "071904779"
            }, {"name": "Illinois - Southern", "aba": "081202759"}, {
                "name": "Indiana",
                "aba": "074900783"
            }, {"name": "Iowa - Council Bluffs", "aba": "104000029"}, {
                "name": "Iowa - All other areas",
                "aba": "073000545"
            }, {"name": "Kansas", "aba": "101000187"}, {
                "name": "Kentucky - Northern",
                "aba": "042100175"
            }, {"name": "Kentucky - Western", "aba": "083900363"}, {
                "name": "Minnesota - East Grand Forks",
                "aba": "091215927"
            }, {"name": "Minnesota - Moorhead", "aba": "091300023"}, {
                "name": "Minnesota - All other areas",
                "aba": "091000022"
            }, {"name": "Missouri", "aba": "081000210"}, {"name": "Montana", "aba": "092900383"}, {
                "name": "Nebraska",
                "aba": "104000029"
            }, {"name": "Nevada", "aba": "121201694"}, {
                "name": "New Mexico",
                "aba": "107002312"
            }, {"name": "North Dakota", "aba": "091300023"}, {
                "name": "Ohio - Cleveland",
                "aba": "041202582"
            }, {"name": "Ohio - All other areas", "aba": "042000013"}, {
                "name": "Oregon",
                "aba": "123000220"
            }, {"name": "South Dakota", "aba": "091408501"}, {"name": "Tennessee", "aba": "064000059"}, {
                "name": "Utah",
                "aba": "124302150"
            }, {"name": "Washington", "aba": "125000105"}, {
                "name": "Wisconsin",
                "aba": "075000022"
            }, {"name": "Wyoming", "aba": "307070115"}, {"name": "All other states", "aba": "091000022"}]
        },
        "wellsfargo": {
            "name": "Wells Fargo",
            "states": [{"name": "Alabama", "aba": "062000080"}, {
                "name": "Alaska",
                "aba": "125200057"
            }, {"name": "Arizona", "aba": "122105278"}, {"name": "Arkansas", "aba": "111900659"}, {
                "name": "California",
                "aba": "121042882"
            }, {"name": "Colorado", "aba": "102000076"}, {
                "name": "Connecticut",
                "aba": "021101108"
            }, {"name": "Delaware", "aba": "031100869"}, {
                "name": "District of Columbia",
                "aba": "054001220"
            }, {"name": "Florida", "aba": "063107513"}, {"name": "Georgia", "aba": "061000227"}, {
                "name": "Hawaii",
                "aba": "121042882"
            }, {"name": "Idaho", "aba": "124103799"}, {"name": "Illinois", "aba": "071101307"}, {
                "name": "Indiana",
                "aba": "074900275"
            }, {"name": "Iowa", "aba": "073000228"}, {"name": "Kansas", "aba": "101089292"}, {
                "name": "Kentucky",
                "aba": "121042882"
            }, {"name": "Louisiana", "aba": "121042882"}, {"name": "Maine", "aba": "121042882"}, {
                "name": "Maryland",
                "aba": "055003201"
            }, {"name": "Massachusetts", "aba": "121042882"}, {
                "name": "Michigan",
                "aba": "091101455"
            }, {"name": "Minnesota", "aba": "091000019"}, {
                "name": "Mississippi",
                "aba": "062203751"
            }, {"name": "Missouri", "aba": "121042882"}, {"name": "Montana", "aba": "092905278"}, {
                "name": "Nebraska",
                "aba": "104000058"
            }, {"name": "Nevada", "aba": "321270742"}, {
                "name": "New Hampshire",
                "aba": "121042882"
            }, {"name": "New Jersey", "aba": "021200025"}, {
                "name": "New Mexico",
                "aba": "107002192"
            }, {"name": "New York", "aba": "026012881"}, {
                "name": "North Carolina",
                "aba": "053000219"
            }, {"name": "North Dakota", "aba": "091300010"}, {"name": "Ohio", "aba": "041215537"}, {
                "name": "Oklahoma",
                "aba": "121042882"
            }, {"name": "Oregon", "aba": "123006800"}, {
                "name": "Pennsylvania",
                "aba": "031000503"
            }, {"name": "Rhode Island", "aba": "121042882"}, {
                "name": "South Carolina",
                "aba": "053207766"
            }, {"name": "South Dakota", "aba": "091400046"}, {
                "name": "Tennessee",
                "aba": "064003768"
            }, {"name": "Texas", "aba": "111900659"}, {"name": "Texas - El Paso", "aba": "112000066"}, {
                "name": "Utah",
                "aba": "124002971"
            }, {"name": "Vermont", "aba": "121042882"}, {"name": "Virginia", "aba": "051400549"}, {
                "name": "Washington",
                "aba": "125008547"
            }, {"name": "West Virginia", "aba": "121042882"}, {
                "name": "Wisconsin",
                "aba": "075911988"
            }, {"name": "Wyoming", "aba": "102301092"}]
        }
    };

    let holidays = [
        "2021-01-01", // New Year's Day observed
        "2021-01-18", // Martin Luther King Day
        "2021-02-15", // Washington's Birthday
        "2021-05-31", // Memorial Day
        "2021-07-04", // Independence Day
        "2021-09-06", // Labor Day
        "2021-10-11", // Columbus Day
        "2021-11-25", // Thanksgiving Day
        "2021-12-25", // Christmas Day
        "2022-01-01", // New Year's Day observed
        "2022-01-17", // Martin Luther King Day
        "2022-02-21", // Washington's Birthday
        "2022-05-30", // Memorial Day
        "2022-07-04", // Independence Day
        "2022-09-05", // Labor Day
        "2022-10-10", // Columbus Day
        "2022-11-24", // Thanksgiving Day
        "2022-12-25", // Christmas Day
        "2023-01-01", // New Year's Day observed
        "2023-01-16", // Martin Luther King Day
        "2023-02-20", // Washington's Birthday
        "2023-05-29", // Memorial Day
        "2023-07-04", // Independence Day
        "2023-09-04", // Labor Day
        "2023-10-09", // Columbus Day
        "2023-11-23", // Thanksgiving Day
        "2023-12-25", // Christmas Day
        "2024-01-01", // New Year's Day observed
        "2024-01-15", // Martin Luther King Day
        "2024-02-19", // Washington's Birthday
        "2024-05-27", // Memorial Day
        "2024-07-04", // Independence Day
        "2024-09-02", // Labor Day
        "2024-10-14", // Columbus Day
        "2024-11-28", // Thanksgiving Day
        "2024-12-25", // Christmas Day
        "2025-01-01", // New Year's Day observed
        "2025-01-20", // Martin Luther King Day
        "2025-02-17", // Washington's Birthday
        "2025-05-26", // Memorial Day
        "2025-07-04", // Independence Day
        "2025-09-01", // Labor Day
        "2025-10-13", // Columbus Day
        "2025-11-27", // Thanksgiving Day
        "2025-12-25", // Christmas Day
        "2026-01-01", // New Year's Day observed
        "2026-01-19", // Martin Luther King Day
        "2026-02-16", // Washington's Birthday
        "2026-05-25", // Memorial Day
        "2026-07-04", // Independence Day
        "2026-09-07", // Labor Day
        "2026-10-12", // Columbus Day
        "2026-11-26", // Thanksgiving Day
        "2026-12-25", // Christmas Day
        "2027-01-01", // New Year's Day observed
        "2027-01-18", // Martin Luther King Day
        "2027-02-15", // Washington's Birthday
        "2027-05-31", // Memorial Day
        "2027-07-04", // Independence Day
        "2027-09-06", // Labor Day
        "2027-10-11", // Columbus Day
        "2027-11-25", // Thanksgiving Day
        "2027-12-25", // Christmas Day
        "2028-01-01", // New Year's Day observed
        "2028-01-17", // Martin Luther King Day
        "2028-02-21", // Washington's Birthday
        "2028-05-29", // Memorial Day
        "2028-07-04", // Independence Day
        "2028-09-04", // Labor Day
        "2028-10-09", // Columbus Day
        "2028-11-23", // Thanksgiving Day
        "2028-12-25", // Christmas Day
        "2029-01-01", // New Year's Day observed
        "2029-01-15", // Martin Luther King Day
        "2029-02-19", // Washington's Birthday
        "2029-05-28", // Memorial Day
        "2029-07-04", // Independence Day
        "2029-09-03", // Labor Day
        "2029-10-08", // Columbus Day
        "2029-11-22", // Thanksgiving Day
        "2029-12-25"  // Christmas Day
    ];
    large_form.validate({
        rules: {
            "tr[loanamount]": {
                required: true
            },
            address: {
                required: true,
                maxlength: 256,
                minlength: 2
            },
            "first-name": {
                required: true,
                maxlength: 64,
                normalizer: function (value) {
                    if (/[A-Za-z ]/g.test(value)) {
                        return value;
                    }
                    else {
                        return false;
                    }
                }
            },
            "last-name": {
                required: true,
                maxlength: 64,
                normalizer: function (value) {
                    if (/[A-Za-z ]/g.test(value)) {
                        return value;
                    }
                    else {
                        return false;
                    }
                }
            },
            "e-mail": {
                email: true,
                minlength: 5,
                maxlength: 100
            },
            "tr[day]": {
                required: true
            },
            "tr[month]": {
                required: true
            },
            "tr[year]": {
                required: true
            },
            workCompanyName: {
                required: true,
                maxlength: 128
            },
            driversLicenseNumber: {
                required: true,
                maxlength: 25,
                normalizer: function (value) {
                    if (/^[a-zA-Z0-9]+$/.test(value)) {
                        return value;
                    }
                    else {
                        return false;
                    }
                }
            },
            ssn: {
                required: true,
            },
            "tr[incomenetmonthly]": {
                required: true
            },
            incomeType: {
                required: true
            },
            activeMilitary: {
                required: true
            },
            aba: {
                required: true,
                minlength: 5,
                maxlength: 15,
                digits: true
            },
            "tr[bankaccountnumber]": {
                required: true,
                minlength: 4,
                maxlength: 25,
                digits: true
            },
            bankDirectDeposit: {
                required: true
            },
            bankAccountType: {
                required: true
            },
            zipcode: {
                required: true,
                digits: true
            }
        },
        messages: {
            loanAmount: "Select loan amount.",
            address: "Field may not be less than 2 letters and 1 number.",
            email: {
                required: "We need your email address to contact you",
                email: "Your email address must be in the format of name@domain.com"
            },
            workCompanyName: {
                required: "Field may not be less than 2 letters.",
            },
            driversLicenseNumber: "Entry must consist of alpha-numeric characters only. Symbols will not be accepted.",
            ssn: "Must be 9 digits and only consist of numeric values.",
            homePhone: "Must only contain numeric values. Number must be 10 digits (including area code).",
            workPhone: "Must only contain numeric values. Number must be 10 digits (including area code).",
            incomeType: "This field is required.",
            activeMilitary: "This field is required.",
            bankDirectDeposit: "This field is required.",
            bankAccountType: "This field is required.",
            bankAba: {
                required: "A valid ABA/bank routing number must be 9 digits long.",
                normalizer: "Invalid Bank ABA/Routing Number"
            },
            bankAccountNumber: "May only include numeric values.",
        },
        errorClass: "error",
        pendingClass: "pending",
        validClass: "valid",
        errorElement: "span",
        errorPlacement: function (error, element) {
            if (element.is(":radio")) {
                error.appendTo(element.parents('.col-md-6'));
            }
            else { // This is the default behavior
                error.insertAfter(element);
            }
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass(errorClass).removeClass(validClass);
            $(element.large_form).find("label[for=" + element.id + "]").addClass(errorClass);
            $(element.large_form).find("label[for=" + element.id + "]").parents(".form-item").addClass(errorClass + '-field');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass(errorClass).addClass(validClass);
            $(element.large_form).find("label[for=" + element.id + "]").removeClass(errorClass);
            $(element.large_form).find("label[for=" + element.id + "]").parents(".form-item").removeClass(errorClass + '-field');
        },
    });

    $('form#large_form div.form_steps').steps({
        headerTag: 'h3',
        saveState: false,
        bodyTag: 'section',
        transitionEffect: 'fade',
        titleTemplate: '<span class="number">#index#</span> #title#',
        onStepChanging: function (event, currentIndex, newIndex) {

            if (currentIndex > newIndex) {
                return true
            }
            large_form.validate().settings.ignore = ':disabled,:hidden';
            return large_form.valid()
        },
        onStepChanged: function (event, currentIndex) {
            let next_step_button = $('div.actions a[href="#next"]')
            if ($('div#sending_text').hasClass('hidden')) {
                $('div#sending_text').removeClass('hidden')
                $('div#ajax_response').addClass('hidden')
            }
            if (currentIndex === 2) {
                next_step_button.text('Submit').addClass('submit')
            }
            else if (currentIndex === 3) {
                large_form.validate().settings.ignore = ":disabled, :hidden";
                send_bigform()
                return large_form.valid();
            }
            else {
                next_step_button.text('Next step').removeClass('submit')
            }
            return true
        },
        onFinishing: function () {
            large_form.validate().settings.ignore = ":disabled, :hidden";
            return large_form.valid()
        },
        onFinished: function () {
            window.onbeforeunload = null;
        },
        onInit: function (event, currentIndex) {
            $('div.actions a[href="#finish"]').remove()
            $('div.steps ul > li').each(function (index) {
                $(this).prepend('<span class="number for-sm">' + (index + 1) + '</span>')
            })
            $('div.steps ul > li.last span.number').html('<i class="fa fa-check"></i>')
            $('div.content.clearfix h3').remove()
        },
        /*labels: {
            cancel: "Cancel",
            current: "current step:",
            pagination: "Pagination",
            finish: "Submit",
            next: "Next step",
            previous: "Previous step",
            loading: "Loading ..."
        }*/
    });

    let pay_frequency_select = $('#tr_field_22_tr_incomepaymentfrequency');
    let start_date_datepicker_input = $('#tr_field_24_tr_incomenextdate1');
    let finish_date_datepicker_input = $('#tr_field_26_tr_incomenextdate2');
    let privacy_link = $("a.privacy_link");
    let terms_link = $("a.terms_link");

    pay_frequency_select.on('change', function () {
        start_date_datepicker_input.datepicker({
            dateFormat: 'mm/dd/yy',
            firstDay: 7,
            showAnim: "",
            numberOfMonths: (screen.width > 740 ? 2 : 1),
            showButtonPanel: false,
            minDate: '+1d',
            maxDate: '+61d',
            beforeShow: function () {
                $(this).blur();
            },
            beforeShowDay: noWeekendsOrHolidays,
            hideIfNoPrevNext: true,
            onSelect: function (value, element) {
                addSecondDate(element);
            }
        });
        start_date_datepicker_input.datepicker('show');
        finish_date_datepicker_input.val('');
    });

    finish_date_datepicker_input.datepicker({
        dateFormat: 'mm/dd/yy',
        firstDay: 7,
        showAnim: "",
        numberOfMonths: (screen.width > 740 ? 2 : 1),
        showButtonPanel: true,
        minDate: '+1d',
        maxDate: '+61d',
        beforeShow: function () {
            $(this).blur();
        },
        beforeShowDay: noWeekendsOrHolidays,
        hideIfNoPrevNext: true,
        onSelect: function (dateText, inst) {
        }
    });

    function send_bigform() {
        let form_data = $("form#large_form :input[value!='']").serialize()
        jQuery.ajax({
            dataType: 'json',
            url: ajaxout.url,
            data: form_data,
            method: 'POST',
            action: 'apply_now_form',
            success: function (response) {
                window.onbeforeunload = null;
                $('div#sending_text').addClass('hidden')
                if (response.status === 1) {
                    document.location.href = response.redirect_url
                }
                else {
                    $('div#ajax_response').html(response.message).removeClass('hidden')
                }
            },
            error: function (error) {
                console.log(error)
            },
        })
    }

    function noWeekendsOrHolidays(date) {
        let string = $.datepicker.formatDate('yy-mm-dd', date);

        let t = date.getDay() * 1;
        return (holidays.indexOf(string) === -1 && t > 0 && t < 6) ? [-1] : [0];
    }

    function checkdate(date, direction) {
        let string = $.datepicker.formatDate('yy-mm-dd', date);

        let t = date.getDay();
        if (t === 0) {
            if (direction) {
                date.setDate(date.getDate() + 1);
            }
            else {
                date.setDate(date.getDate() - 2);
            }
        }
        else if (t === 6) {
            if (direction) {
                date.setDate(date.getDate() + 2);
            }
            else {
                date.setDate(date.getDate() - 1);
            }
        }
        else if (holidays.indexOf(string) !== -1) {
            if (direction) {
                date.setDate(date.getDate() + 1);
            }
            else {
                date.setDate(date.getDate() - 1);
            }
        }
        return date;
    }

    function addSecondDate(value) {
        let paymentFrequency = pay_frequency_select;
        paymentFrequency = paymentFrequency.val() ? paymentFrequency.val() : '';
        if ((paymentFrequency === 'MONTHLY' || paymentFrequency === 'BIWEEKLY' || paymentFrequency === 'WEEKLY' || paymentFrequency === 'TWICEMONTHLY') && value) {
            let selected_Day = value.selectedDay * 1;
            let selected_Month = value.selectedMonth * 1;
            let selected_Year = value.selectedYear * 1;
            let selected_Date = new Date(selected_Year, selected_Month, selected_Day);
            let finish_date = new Date();


            switch (paymentFrequency) {
                case 'MONTHLY':
                    finish_date = new Date(selected_Date.setMonth(selected_Date.getMonth() + 1));
                    selected_Date = checkdate(finish_date, 1);
                    break;
                case 'WEEKLY':
                    finish_date.setDate(selected_Date.getDate() + 7);
                    selected_Date = checkdate(finish_date, 0);
                    break;
                case 'BIWEEKLY':
                    finish_date.setDate(selected_Date.getDate() + 14);
                    selected_Date = checkdate(finish_date, 0);
                    break;
                case 'TWICEMONTHLY':
                    finish_date.setDate(selected_Date.getDate() + 17);
                    selected_Date = checkdate(finish_date, 0);
                    break;
                default:
                    break;
            }
            selected_Month = selected_Date.getMonth() + 1;
            if (selected_Month < 10) {
                selected_Month = '0' + selected_Month;
            }
            let selectedDay = selected_Date.getDate();
            if (selectedDay < 10) {
                selectedDay = '0' + selectedDay
            }
            finish_date_datepicker_input.val(selected_Month + '/' + selectedDay + '/' + selected_Date.getFullYear())
            let finish_date_validate = large_form.validate()
            finish_date_validate.element(finish_date_datepicker_input)
        }
    }


    /* ZIP search and processing */
    let zip_input = $('input#tr_field_11_tr_zip_code')
    zip_input.on('change', function (e) {
        let zipcode = zip_input.val();
        if (zipcode.length >= 3) {
            var data = {
                action: 'is_region_serviced',
                service_id: 2,
                zipcode: zipcode
            };
            jQuery.ajax({
                dataType: 'JSON',
                url: ajaxout.url,
                data: data,
                method: 'POST',
                success: function (response) {
                    if (response['region']) { // region found
                        if (response['services'] !== JSON.stringify(data.service_id)) { // TOdO: services array in multisite installation check
                            let sorry_message = "<p>We\'re sorry, we currently do not offer any services in <strong>" + response['region'] + "</strong>.</p><p>Please check back with us in the future. If you have any questions, please don’t hesitate to contact our customer service team. Thank you!</p>"
                            if (zip_input.val() !== '') $.fancybox.open('<div class="error-message-fancybox"><p>' + sorry_message + '</p></div>')
                            zip_input.toggleClass('valid error').val('')
                        }
                    }
                    else {
                        zip_input.addClass('error')
                        if (zip_input.val() !== '') $.fancybox.open('<div class="error-message-fancybox"><p>Region not found.</p></div>')
                        zip_input.val('')
                    }
                },
                error: function (error) {
                }
            })
        }
    });

    function bankToABAfull() {
        let aba_select = $("#tr_field_28_tr_aba_routing_number");
        let banks_select = $("#tr_field_31_tr_bankname");
        let banks_state_select = $("#tr_field_32_tr_bankstate");

        let banks = Object.entries(ccABAInfo).map(([key, value]) => {
            banks_select.append('<option value="' + key + '">' + value.name + '</option>')
        })


        if (banks_select.length && !banks_select.val().length) {
            banks_state_select.attr('disabled', true);
        }
        let ABAInfo = typeof (ccABAInfo) !== "undefined" ? ccABAInfo : {};


        banks_select.on('change', function () {
            if (banks_select.val() !== "other") {
                aba_select.val('');
                banks_state_select.children().remove();
                banks_state_select.append($("<option/>").attr({
                    value: "",
                    disabled: true,
                    selected: true
                }).text('Bank State'));
                banks_state_select.attr('disabled', false);
                var states = ABAInfo[banks_select.val()].states;
                if (states.length > 1) {
                    banks_state_select.append($("<option/>").attr('value', 'other').text('Other'));
                }
                for (let i in states) {
                    banks_state_select.append($("<option/>").attr('value', states[i].aba).text(states[i].name));
                }
            }
            else {
                aba_select.val('');
                banks_state_select.attr('disabled', true);
            }
        });

        banks_state_select.on('change', function () {
            var val = $(this).val();
            if (val.length > 0 && val !== "other") {
                aba_select.val(val).focus();
            }
            else {
                aba_select.val('');
            }
        });
        if (aba_select.length) {
            banks_state_select.attr('aria-invalid', 'false');
        }
    }

    bankToABAfull();

    if (large_form.length) {
        window.onbeforeunload = function () {
            return "Do you really want to close?";
        }
    }

    /***********************************************   DOM READY   ***************************************/
    $(document).ready(function () {
        $("#tr_field_14_tr_social_security_number").mask('999-99-9999', {autoclear: false}).addClass('mask-applied');
        $("#tr_field_15_tr_primary_phone").mask('(999) 999-9999', {autoclear: false}).addClass('mask-applied');
        $("#tr_field_16_tr_employer_phone").mask('(999) 999-9999', {autoclear: false}).addClass('mask-applied');
        start_date_datepicker_input.not('.mask-applied').mask("99/99/9999").addClass('mask-applied').attr("data-mask", "MM/DD/YYYY");
        finish_date_datepicker_input.not('.mask-applied').mask("99/99/9999").addClass('mask-applied').attr("data-mask", "MM/DD/YYYY");

        zip_input.mask("99999").addClass('mask-applied').attr({
            "data-mask": "99999",
            'type': 'tel'
        });

        let aba_select = $("#tr_field_28_tr_aba_routing_number");
        aba_select.not('.mask-applied').mask("999999999").addClass('mask-applied').attr({
            "data-mask": "_________",
            'type': 'tel'
        });

        $('.mask-applied').on('click focus', function () {
            $(this).selectRange(0)
        });


        $.fn.selectRange = function (start, end) {
            if (end === undefined) {
                end = start;
            }
            return this.each(function () {
                if ('selectionStart' in this) {
                    this.selectionStart = start;
                    this.selectionEnd = end;
                }
                else if (this.setSelectionRange) {
                    this.setSelectionRange(start, end);
                }
                else if (this.createTextRange) {
                    var range = this.createTextRange();
                    range.collapse(true);
                    range.moveEnd('character', end);
                    range.moveStart('character', start);
                    range.select();
                }
            });
        };

        $('#large_form .form-control').on('change', function () {
            if ($(this).hasClass('valid')) {
                if (!$(this).val().length) {
                    $(this).removeClass('valid');
                }
            }
        });

        $('a.toggle-aba-help').on('click', function (e) {
            e.preventDefault();
            $('div#aba-help-fields').toggleClass('hidden');
        })

        function get_ajax_data(data) {
            jQuery.ajax({
                url: ajaxout.url,
                data: data,
                method: 'POST',
                success: function (response) {
                    $.fancybox.open(response);
                },
                error: function (error) {
                    console.log(error)
                }
            })
        }

        privacy_link.on('click', function (e) {
            e.preventDefault()
            let data = {
                action: 'get_ajax_data',
                data_type: 'privacy_policy'
            }
            get_ajax_data(data);
        })
        terms_link.on('click', function (e) {
            e.preventDefault()
            let data = {
                action: 'get_ajax_data',
                data_type: 'terms_conditions'
            }
            get_ajax_data(data);
        })
    }); // document.ready end
})(jQuery);